<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/misc/TextExtras.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/misc/TextExtras.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="TextExtras.m3">TextExtras</A></interface>;

IMPORT <A HREF="../../../types/src/ASCII.i3">ASCII</A>;

TYPE T = TEXT;

PROCEDURE <A HREF="TextExtras.m3#CIEqual">CIEqual</A>(t, u: T): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> Return TRUE if t and u have the same length and the same
   (case-insensitive) contents. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextExtras.m3#Compare">Compare</A>(t, u: T): INTEGER RAISES {};
</PRE><BLOCKQUOTE><EM> Result is &lt;, =, &gt; 0 accordingly as t is &lt;, =, &gt; u (ascii sort order) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextExtras.m3#CICompare">CICompare</A>(t, u: T): INTEGER RAISES {};
</PRE><BLOCKQUOTE><EM> Case-insensitive version of Compare. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextExtras.m3#FindChar">FindChar</A>(
    t: T;
    ch: CHAR;
    VAR (*inout*) index: CARDINAL)
    : BOOLEAN
    RAISES {};
</PRE><BLOCKQUOTE><EM><P>
  Search 't' for 'ch', starting from the 'index'th position.
  If 'index' is initially equal to the length of 't' FALSE is returned and
  'index' is left unchanged.
  It is a checked runtime error if 'index' is initially greater than the
  length of 't'.
  If 'ch' is found then 'index' is set to the corresponding position and
  TRUE is returned. Otherwise, 'index' is set to the length of 't' and FALSE
  is returned.
  Any character---including Nul---may be searched for.
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextExtras.m3#FindCharSet">FindCharSet</A>(
    t: T;
    READONLY charSet: ASCII.Set;
    VAR (* inout *) index: CARDINAL)
    : BOOLEAN
    RAISES {};
</PRE><BLOCKQUOTE><EM> As FindChar but matches any of the characters in 'charSet'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextExtras.m3#FindSub">FindSub</A>(
  t, sub: T;
  VAR (* inout *) index: CARDINAL): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> As FindChar, but matching substring 'sub'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextExtras.m3#Extract">Extract</A>(
  t: T; fx, tx: CARDINAL): T RAISES {};
</PRE><BLOCKQUOTE><EM> Equivalent to, but more convenient than, Sub(t, fx, tx-fx), especially
when used with FindXXX; </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextExtras.m3#Join">Join</A>(t1, t2, t3, t4, t5: T := NIL): T RAISES {};
</PRE><BLOCKQUOTE><EM> Returns the concatenation of all its non NIL arguments. Non NIL arguments
must precede NIL arguments; it is a checked runtime error if they do not. e.g.
if 't4' is non NIL 't1' to 't4' must be non NIL as well.
  It is a checked runtime error if all the arguments are NIL </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextExtras.m3#JoinN">JoinN</A>(READONLY texts: ARRAY OF TEXT): T RAISES {};
</PRE><BLOCKQUOTE><EM> Returns the concatenation of all the elements of 'texts'. It is a checked
runtime error if any element of 'texts' is NIL or if 'NUMBER(texts) = 0'  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextExtras.m3#CIHash">CIHash</A>(t: T): INTEGER;
</PRE><BLOCKQUOTE><EM> Case insensitive version of <CODE>Text.Hash</CODE>, for case-insensitive tables. </EM></BLOCKQUOTE><PRE>

END TextExtras.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
