<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/misc/TextExtras.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/misc/TextExtras.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="TextExtras.i3">TextExtras</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../../../text/src/TextF.i3">TextF</A>;
FROM <A HREF="../../../text/src/TextF.i3">TextF</A> IMPORT New;
FROM <A HREF="../../../text/src/Text.i3">Text</A> IMPORT Length, Sub;
IMPORT <A HREF="../../../types/src/ASCII.i3">ASCII</A>;

PROCEDURE <A NAME="Compare"><procedure>Compare</procedure></A>(t, u: T): INTEGER RAISES {} =
  VAR
    minLength := Length(t);
    otherLength := Length(u);
    lengthDiff: INTEGER := minLength - otherLength;
    i: CARDINAL := 0;
  BEGIN
    IF lengthDiff &gt; 0 THEN minLength := otherLength END;
    WHILE i &lt; minLength DO
      VAR ti := ORD(t[i]); ui := ORD(u[i]); (* workaround compiler bug *)
      BEGIN                                 (* on byte subtractions *)
        WITH diff = ti - ui DO
          IF diff # 0 THEN RETURN diff ELSE INC(i) END;
        END;
      END;
    END;
    RETURN lengthDiff;
  END Compare;

PROCEDURE <A NAME="CICompare"><procedure>CICompare</procedure></A>(t, u: T): INTEGER RAISES {} =
  VAR
    minLength := Length(t);
    otherLength := Length(u);
    lengthDiff := minLength - otherLength;
    i: CARDINAL := 0;
  BEGIN
    IF lengthDiff &gt; 0 THEN minLength := otherLength END;
    WHILE i &lt; minLength DO
      WITH diff = ORD(ASCII.Upper[t[i]]) - ORD(ASCII.Upper[u[i]]) DO
        IF diff # 0 THEN RETURN diff ELSE INC(i) END;
      END;
    END;
    RETURN lengthDiff;
  END CICompare;

PROCEDURE <A NAME="CIEqual"><procedure>CIEqual</procedure></A>(t, u: T): BOOLEAN RAISES {} =
  VAR
    lt: CARDINAL := Length(t);
    lu: CARDINAL := Length(u);
    i: CARDINAL := 0;
  BEGIN
    IF lt = lu THEN
      WHILE i&lt;lt DO
        IF ASCII.Upper[t[i]] # ASCII.Upper[u[i]] THEN
          RETURN FALSE
        ELSE INC(i)
        END;
      END;
      RETURN TRUE;
    ELSE RETURN FALSE
    END;
  END CIEqual;

EXCEPTION BadFind;

PROCEDURE <A NAME="FindChar"><procedure>FindChar</procedure></A>(t: T; ch: CHAR; VAR index: CARDINAL): BOOLEAN RAISES {} =
  VAR
    i: CARDINAL := index;
    lt: CARDINAL := Length(t);
  BEGIN
    IF i &gt;= lt THEN
      IF i = lt THEN RETURN FALSE ELSE
        &lt;*FATAL BadFind *&gt; BEGIN RAISE BadFind END;
      END;
    END;
    REPEAT
      IF t[i] = ch THEN index := i; RETURN TRUE END;
      INC(i);
    UNTIL i = lt;
    index := i;
    RETURN FALSE;
  END FindChar;

PROCEDURE <A NAME="FindCharSet"><procedure>FindCharSet</procedure></A>(
    t: T;
    READONLY charSet: ASCII.Set;
    VAR index: CARDINAL)
    : BOOLEAN
    RAISES {} =
  VAR
    i: CARDINAL := index;
    lt: CARDINAL := Length(t);
  BEGIN
    IF i &gt;= lt THEN
      IF i = lt THEN RETURN FALSE ELSE
        &lt;*FATAL BadFind*&gt; BEGIN RAISE BadFind END;
      END
    END;
    REPEAT
      IF t[i] IN charSet THEN index := i; RETURN TRUE END;
      INC(i);
    UNTIL i = lt;
    index := i;
    RETURN FALSE;
  END FindCharSet;

PROCEDURE <A NAME="FindSub"><procedure>FindSub</procedure></A>(t, sub: T; VAR index: CARDINAL): BOOLEAN RAISES {} =
  VAR
    i: CARDINAL := index;
    lt: CARDINAL := Length(t);
    lsub: CARDINAL := Length(sub);
  BEGIN
    IF i &gt; lt THEN &lt;*FATAL BadFind*&gt; BEGIN RAISE BadFind END; END;
    IF lsub = 0 THEN
      RETURN TRUE
    ELSE
      IF lsub &lt;= lt THEN
        VAR
          lastStart := lt - lsub;
          firstCh := sub[0];
        BEGIN
          WHILE i &lt;= lastStart DO
            IF t[i] = firstCh THEN
              VAR
                j: CARDINAL := 1;
              BEGIN
                LOOP
                  IF j = lsub THEN
                    index := i;
                    RETURN TRUE;
                  ELSIF i + j &gt;= lt OR t[i+j] # sub[j] THEN
                    EXIT
                  ELSE
                    INC(j);
                  END;
                END;
              END;
            END;
            INC(i);
          END;
        END;
      END;
      index := lt;
      RETURN FALSE;
    END;
  END FindSub;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Extract"><procedure>Extract</procedure></A>(t: T; fx, tx: CARDINAL): T RAISES {} =
  BEGIN
    RETURN Sub(t, fx, tx-fx);
  END Extract;

EXCEPTION
  JoinFailed;

PROCEDURE <A NAME="Join"><procedure>Join</procedure></A>(t1, t2, t3, t4, t5: T := NIL): T RAISES {}=
  VAR
    a := ARRAY [0..4] OF T {t1, t2, t3, t4, t5};
    pos := LAST(a);
  BEGIN
    LOOP
      IF a[pos] # NIL THEN
        RETURN JoinN(SUBARRAY(a, 0, pos + 1));
      ELSIF pos = 0 THEN
        &lt;*FATAL JoinFailed*&gt; BEGIN RAISE JoinFailed; END;
      ELSE
        DEC(pos);
      END;
    END;
  END Join;

PROCEDURE <A NAME="JoinN"><procedure>JoinN</procedure></A>(READONLY texts: ARRAY OF TEXT): T RAISES {}=
  VAR
    n := NUMBER(texts);
    result: T;
  BEGIN
    IF n = 0 THEN &lt;*FATAL JoinFailed*&gt; BEGIN RAISE JoinFailed END; END;

    VAR
      length := 0;
    BEGIN
      FOR i := 0 TO n - 1 DO INC(length, Length(texts[i])) END;
      result := New(length);
    END;

    VAR
      pos := 0;
    BEGIN
      FOR i := 0 TO n - 1 DO
        WITH t = texts[i], tl = Length(t) DO
          IF tl &gt; 0 THEN
            SUBARRAY(result^, pos, tl) := SUBARRAY(t^, 0, tl);
            INC(pos, tl);
          END;
        END;
      END; (* for *)
    END;

    RETURN result;
  END JoinN;

CONST
    Multiplier  = -1664117991;
        (* = LOOPHOLE( ROUND( .6125423371 * 2^32 ), INTEGER ) *)

PROCEDURE <A NAME="CIHash"><procedure>CIHash</procedure></A> (t: T): INTEGER =
  VAR result := 0;
  BEGIN
    FOR i := 0 TO NUMBER (t^) - 1 DO
      result := result * Multiplier + ORD (ASCII.Upper[t [i]]);
    END;
    RETURN result;
  END CIHash;

BEGIN

END TextExtras.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
