<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/pl/M3LDepends.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/pl/M3LDepends.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3LDepends.i3">M3LDepends</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>, <A HREF="../ast/M3AST_PL_F.i3">M3AST_PL_F</A>;

IMPORT <A HREF="../../derived/SeqM3AST_AS_Used_interface_id.i3">SeqM3AST_AS_Used_interface_id</A>;
IMPORT <A HREF="../../derived/SeqM3AST_AS_Module.i3">SeqM3AST_AS_Module</A>, <A HREF="../../derived/SeqM3AST_AS_Module_id.i3">SeqM3AST_AS_Module_id</A>;

IMPORT <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>;
IMPORT <A HREF="../toolmisc/M3Context.i3">M3Context</A>;
</PRE>Debug IMPORT M3CId, Wr, Stdio, Fmt; Debug

<P><PRE>CONST  (* states of computation *)
  Needed = 0;
  InProgress = 1;
  Done = 2;

NoGenerics =
  M3CUnit.TypeSet{M3CUnit.Type.Interface, M3CUnit.Type.Interface_gen_ins,
                  M3CUnit.Type.Module, M3CUnit.Type.Module_gen_ins};
TYPE
  ContextClosure = M3Context.Closure OBJECT
    dependsClosure: Closure;
  END;

REVEAL <A NAME="Closure">Closure</A> = Closure_public BRANDED OBJECT END;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="Set"><procedure>Set</procedure></A>(c: M3Context.T; cl: Closure) RAISES {}=
  &lt;*FATAL ANY*&gt;
  BEGIN
    Clear(c);
    M3Context.ApplyToSet(c, NEW(M3Context.Closure, callback := SetExportedBy),
      NoGenerics);
    M3Context.ApplyToSet(c, NEW(ContextClosure, dependsClosure := cl,
      callback := SetSimpleDependsOn), NoGenerics);
    M3Context.ApplyToSet(c, NEW(ContextClosure, dependsClosure := cl,
      callback := CloseDependsOn), NoGenerics);
</PRE><BLOCKQUOTE><EM>Debug     M3Context.Apply(c, NEW(M3Context.Closure, callback := Debug));  Debug</EM></BLOCKQUOTE><PRE>
  END Set;
</PRE>PUBLIC
<PRE>PROCEDURE <A NAME="Clear"><procedure>Clear</procedure></A>(c: M3Context.T) RAISES {}=
  &lt;*FATAL ANY*&gt;
  BEGIN
    M3Context.ApplyToSet(c, NEW(M3Context.Closure, callback := ClearUnit),
        NoGenerics);
  END Clear;

PROCEDURE <A NAME="ClearUnit"><procedure>ClearUnit</procedure></A>(
    &lt;*UNUSED*&gt; cl: M3Context.Closure;
    ut: M3CUnit.Type;
    &lt;*UNUSED*&gt; name: TEXT;
    cu: M3AST_AS.Compilation_Unit) RAISES {}=
  BEGIN
    cu := M3CUnit.ToGenIns(cu, ut);
    TYPECASE cu.as_root OF &lt;*NOWARN*&gt;
    | M3AST_AS.Module(m) =&gt;
        m.pl_tmp_dep_status := Needed;
        m.pl_dependson_s := NIL;
    | M3AST_AS.Interface(i) =&gt;
        VAR
          id: M3AST_AS.Interface_id := i.as_id;
        BEGIN
          id.pl_isexportedby_s := SeqM3AST_AS_Module_id.Null;
        END;
    END; (* if *)
  END ClearUnit;
</PRE>Debug
PROCEDURE Debug(
    cl: M3Context.Closure;
    ut: M3CUnit.Type;
    name: TEXT;
    cu: M3AST_AS.Compilation_Unit) RAISES {}=
  VAR
    iter: SeqM3AST_AS_Module.Iter;
    m, tm: M3AST_AS.Module;
  BEGIN
    cu := M3CUnit.ToGenIns(cu, ut);
    TYPECASE cu.as_root OF
    <PRE>
      M3AST_AS.Module(m) =&gt;
        </PRE>
Put(<CODE>\nDependsOn list for %s\n - </CODE>, m, NIL);
        iter := SeqM3AST_AS_Module.NewIter(m.pl_dependson_s);
        WHILE SeqM3AST_AS_Module.Next(iter, tm) DO
          Put(<CODE>%s  </CODE>, tm, NIL);
        END;
    ELSE
    END;
  END Debug;
Debug

<P>PRIVATE
<PRE>PROCEDURE <A NAME="SetExportedBy"><procedure>SetExportedBy</procedure></A>(
    &lt;*UNUSED*&gt; cl: M3Context.Closure;
    ut: M3CUnit.Type;
    &lt;*UNUSED*&gt; name: TEXT;
    cu: M3AST_AS.Compilation_Unit) RAISES {}=
  VAR
    iter: SeqM3AST_AS_Used_interface_id.Iter;
    used_intf_id: M3AST_AS.Used_interface_id;
  BEGIN
    cu := M3CUnit.ToGenIns(cu, ut);
    TYPECASE cu.as_root OF
    | M3AST_AS.Module(m) =&gt;
        m.pl_tmp_dep_status := Needed;
        (* add myself to exportedby list of all interfaces *)
        iter := SeqM3AST_AS_Used_interface_id.NewIter(m.sm_export_s);
        WHILE SeqM3AST_AS_Used_interface_id.Next(iter, used_intf_id) DO
          (* be graceful about unresolved names *)
          IF used_intf_id.sm_def # NIL THEN
            SeqM3AST_AS_Module_id.AddFront(
              NARROW(used_intf_id.sm_def,
                M3AST_AS.Interface_id).pl_isexportedby_s, m.as_id);
          END; (* if *)
        END; (* while *)
    ELSE
    END; (* typecase *)
  END SetExportedBy;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="SetSimpleDependsOn"><procedure>SetSimpleDependsOn</procedure></A>(
    cl: ContextClosure;
    ut: M3CUnit.Type;
    &lt;*UNUSED*&gt; name: TEXT;
    cu: M3AST_AS.Compilation_Unit) RAISES {}=
  VAR
    i: M3AST_AS.Interface;
    iter: SeqM3AST_AS_Used_interface_id.Iter;
    used_intf_id: M3AST_AS.Used_interface_id;
  BEGIN
    cu := M3CUnit.ToGenIns(cu, ut);
    TYPECASE cu.as_root OF
    | M3AST_AS.Module(m) =&gt;
        iter := SeqM3AST_AS_Used_interface_id.NewIter(m.sm_import_s);
        WHILE SeqM3AST_AS_Used_interface_id.Next(iter, used_intf_id) DO
          i := InterfaceFromUsedId(used_intf_id);
          IF (i # NIL) AND cl.dependsClosure.callback(m, i) THEN (* finally! *)
            AddExporters(m, i);
          END; (* if *)
        END; (* while *)
    ELSE
    END;
  END SetSimpleDependsOn;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="CloseDependsOn"><procedure>CloseDependsOn</procedure></A>(
    cl: ContextClosure;
    ut: M3CUnit.Type;
    &lt;*UNUSED*&gt; name: TEXT;
    cu: M3AST_AS.Compilation_Unit) RAISES {}=
  BEGIN
    cu := M3CUnit.ToGenIns(cu, ut);
    TYPECASE cu.as_root OF
    | M3AST_AS.Module =&gt;
        DoCloseDependsOn(cu.as_root, cl);
    ELSE
    END;
  END CloseDependsOn;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="DoCloseDependsOn"><procedure>DoCloseDependsOn</procedure></A>(m: M3AST_AS.Module; cl: ContextClosure) RAISES {}=
  VAR
    iter, iter2: SeqM3AST_AS_Module.Iter;
    tm, ttm: M3AST_AS.Module;
    depends, ndepends: SeqM3AST_AS_Module.T;
    secondary := FALSE;
  BEGIN
    (*Debug Put(&quot;DoCloseDependsOn m= %s - &quot;, m);  Debug*)
    IF m.pl_tmp_dep_status = Done THEN
      (*Debug Put(&quot;Done\n&quot;);  Debug*)
      RETURN
    ELSIF m.pl_tmp_dep_status = InProgress THEN
      (*Debug Put(&quot;InProgress\n&quot;); Cycle(m); Debug*)
      RETURN
    ELSE
      (*Debug Put(&quot;Starting\n&quot;); Debug*)
      m.pl_tmp_dep_status := InProgress;
      depends := m.pl_dependson_s;
      REPEAT
        ndepends := NIL;
        iter := SeqM3AST_AS_Module.NewIter(depends);
        WHILE SeqM3AST_AS_Module.Next(iter, tm) DO
          IF tm.pl_tmp_dep_status = Needed THEN DoCloseDependsOn(tm, cl); END;
          iter2 := SeqM3AST_AS_Module.NewIter(tm.pl_dependson_s);
          WHILE SeqM3AST_AS_Module.Next(iter2, ttm) DO
            IF AddModule(m, ttm) THEN
              IF secondary THEN Trap() END;
              SeqM3AST_AS_Module.AddFront(ndepends, ttm);
            END;
          END;
        END; (* while *)
        depends := ndepends;
        secondary := TRUE;
      UNTIL SeqM3AST_AS_Module.Empty(depends);
      m.pl_tmp_dep_status := Done;
      (*Debug Put(&quot;DoCloseDependsOn m= %s - &quot;, m);
         Put(&quot;Finished (%s)\n&quot;, m);  Debug*)
    END;
  END DoCloseDependsOn;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="Trap"><procedure>Trap</procedure></A>()= BEGIN END Trap;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="InterfaceFromUsedId"><procedure>InterfaceFromUsedId</procedure></A>(used_intf_id: M3AST_AS.Used_interface_id
    ): M3AST_AS.Interface RAISES {}=
  BEGIN
    (* be graceful about unresolved names *)
    IF used_intf_id.sm_def = NIL THEN RETURN NIL
    ELSE RETURN NARROW(used_intf_id.sm_def, M3AST_AS.Interface_id).sm_spec;
    END;
  END InterfaceFromUsedId;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="AddModule"><procedure>AddModule</procedure></A>(m, dm: M3AST_AS.Module): BOOLEAN RAISES {}=
  VAR
    xm: M3AST_AS.Module;
    iter: SeqM3AST_AS_Module.Iter;
  BEGIN
    (* No dependency on self *)
    IF m = dm THEN RETURN FALSE
    ELSE
      (* Have we already seen this *)
      iter := SeqM3AST_AS_Module.NewIter(m.pl_dependson_s);
      WHILE SeqM3AST_AS_Module.Next(iter, xm) DO
        IF xm = dm THEN RETURN FALSE END;
      END; (* while *)
      (*Debug Put(&quot;Adding %s to dependson list of %s\n&quot;, dm, m); Debug*)
      SeqM3AST_AS_Module.AddFront(m.pl_dependson_s, dm);
      RETURN TRUE;
    END;
  END AddModule;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="AddExporters"><procedure>AddExporters</procedure></A>(
    m: M3AST_AS.Module;
    i: M3AST_AS.Interface) RAISES {}=
  VAR
    iter := SeqM3AST_AS_Module_id.NewIter(
        NARROW(i.as_id, M3AST_AS.Interface_id).pl_isexportedby_s);
    mod_id: M3AST_AS.Module_id;
  BEGIN
    (* Add all the exporters of 'i' to the depends-on list of 'm' *)
    (*Debug Put(&quot;AddExporters of %s to %s\n&quot;, i, m);  Debug*)
    WHILE SeqM3AST_AS_Module_id.Next(iter, mod_id) DO
      EVAL AddModule(m, mod_id.sm_spec);
    END; (* while *)
  END AddExporters;
</PRE>Debug
PROCEDURE Put(t: TEXT; u1, u2: M3AST_AS.UNIT := NIL) RAISES {}=
  VAR t1, t2: TEXT := NIL;
  BEGIN
    IF u1 # NIL THEN t1 := M3CId.ToText(u1.as_id.lx_symrep); END;
    IF u2 # NIL THEN t2 := M3CId.ToText(u2.as_id.lx_symrep) END;
    Wr.PutText(Stdio.stdout, Fmt.F(t, t1, t2));
  END Put;
Debug

<P>PUBLIC
<PRE>PROCEDURE <A NAME="Default"><procedure>Default</procedure></A>(): Closure RAISES {}=
  BEGIN
    RETURN NEW(Closure, callback := DefaultUses);
  END Default;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="DefaultUses"><procedure>DefaultUses</procedure></A>(
    &lt;*UNUSED*&gt; cl: Closure_public;
    &lt;*UNUSED*&gt; m: M3AST_AS.Module;
    &lt;*UNUSED*&gt; i: M3AST_AS.Interface): BOOLEAN RAISES {}=
  BEGIN
    (* 'm' depends on 'i' if 'i' is on the sm_import_s list of 'm'. *)
    RETURN TRUE;
  END DefaultUses;
</PRE>****************************************************
(*PRIVATE
<PRE>PROCEDURE Cycle(&lt;*UNUSED*&gt; m: M3AST_AS.Module) RAISES {}=
  BEGIN
  END Cycle;
***************************************************)

BEGIN
END M3LDepends.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
