<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/pl/M3LExports.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/pl/M3LExports.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3LExports.i3">M3LExports</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../../../text/src/Text.i3">Text</A>;
IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../ast/M3AST_SM.i3">M3AST_SM</A>, <A HREF="../ast/M3AST_PG.i3">M3AST_PG</A>, <A HREF="../toolmisc/M3Context.i3">M3Context</A>, <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_PG_F.i3">M3AST_PG_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>;

IMPORT <A HREF="../ast/M3ASTWalk.i3">M3ASTWalk</A>;

REVEAL
  <A NAME="Closure">Closure</A> = Closure_public BRANDED OBJECT
  OVERRIDES
    callback := CheckUnit
  END;

TYPE
  WalkClosure = M3ASTWalk.Closure OBJECT
    unit: M3AST_AS.Compilation_Unit;
    ccl: Closure;
  OVERRIDES
    callback := CheckNode;
  END;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A>(c: M3Context.T; cl: Closure) RAISES {}=
  &lt;*FATAL ANY*&gt;
  BEGIN
    M3Context.Apply(c, cl, findStandard := FALSE);
  END Check;

PROCEDURE <A NAME="CheckUnit"><procedure>CheckUnit</procedure></A>(cl: Closure; ut: M3CUnit.Type; &lt;*UNUSED*&gt; name: Text.T;
    cu: M3AST_AS.Compilation_Unit) RAISES {}=
  &lt;*FATAL ANY*&gt;
  BEGIN
    IF ut = M3CUnit.Type.Interface THEN
      M3ASTWalk.VisitNodes(cu, NEW(WalkClosure, unit := cu, ccl := cl));
    END; (* if *)
  END CheckUnit;

PROCEDURE <A NAME="CheckNode"><procedure>CheckNode</procedure></A>(wcl: WalkClosure;
    an: AST.NODE; &lt;*UNUSED*&gt; vm: M3ASTWalk.VisitMode) RAISES {}=
  VAR
    ts: M3AST_SM.TYPE_SPEC_UNSET;
    external_id: M3AST_PG.EXTERNAL_ID;
  BEGIN
    IF M3AST_PG.IsA_EXTERNAL_ID(an, external_id) THEN
      IF external_id.pg_external = NIL THEN
        TYPECASE an OF
        | M3AST_AS.Proc_id(proc_id) =&gt;
            IF proc_id.sm_concrete_proc_id = NIL THEN
              wcl.ccl.report(wcl.unit, an);
            END; (* if *)

        | M3AST_AS.Type_id(type_id) =&gt;
            ts := type_id.sm_type_spec;
            TYPECASE ts OF
            | M3AST_AS.Opaque_type(opaque_type) =&gt;
              IF opaque_type.sm_concrete_type_spec = NIL THEN
                wcl.ccl.report(wcl.unit, an);
              END; (* if *)
            ELSE (* who cares *)
            END; (* typecase *)
        ELSE
        END; (* typecase *)
      END; (* if *)
    END; (* if *)
  END CheckNode;

BEGIN
END M3LExports.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
