<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/pl/M3LMain.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/pl/M3LMain.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3LMain.i3">M3LMain</A></implements></module>;

IMPORT <A HREF="../../../libm3/derived/RefList.i3">RefList</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>, <A HREF="../toolmisc/M3Context.i3">M3Context</A>, <A HREF="../syn/M3CId.i3">M3CId</A>;
IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>;
IMPORT <A HREF="../../derived/SeqM3AST_AS_Used_interface_id.i3">SeqM3AST_AS_Used_interface_id</A>;

TYPE
  FindExporterClosure = M3Context.Closure OBJECT
    unitId: M3CId.T;
    seqCu: RefList.T := NIL;
  OVERRIDES
    callback := FindExporter;
  END;

PROCEDURE <A NAME="Module"><procedure>Module</procedure></A>(c: M3Context.T): RefList.T=
  VAR
    cl: FindExporterClosure;
  BEGIN
    cl := NEW(FindExporterClosure, unitId := M3CId.Enter(Name));
    (* try to find modules that exports an interface called 'name'. *)
    &lt;*FATAL ANY*&gt; BEGIN
      M3Context.Apply(c, cl);
    END;
    RETURN cl.seqCu;
  END Module;
</PRE>PRIVATE
<PRE>PROCEDURE <A NAME="FindExporter"><procedure>FindExporter</procedure></A>(
    cl: FindExporterClosure;
    ut: M3CUnit.Type;
    &lt;*UNUSED*&gt; name: TEXT;
    cu: M3AST_AS.Compilation_Unit) RAISES {}=
  VAR
    iter: SeqM3AST_AS_Used_interface_id.Iter;
    used_intf_id: M3AST_AS.Used_interface_id;
  BEGIN
    cu := M3CUnit.ToGenIns(cu, ut);
    IF ut = M3CUnit.Type.Module THEN
      iter := SeqM3AST_AS_Used_interface_id.NewIter(
                NARROW(cu.as_root, M3AST_AS.Module).sm_export_s);
      WHILE SeqM3AST_AS_Used_interface_id.Next(iter, used_intf_id) DO
        IF used_intf_id.lx_symrep = cl.unitId THEN
          cl.seqCu := RefList.AppendD(cl.seqCu, RefList.List1(cu));
        END;
      END; (* while *)
    END; (* if *)
  END FindExporter;

BEGIN
END M3LMain.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
