<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/pl/M3LMethodTable.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/pl/M3LMethodTable.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3LMethodTable.i3">M3LMethodTable</A></implements></module>;

IMPORT <A HREF="../gast/ASTWalk.i3">ASTWalk</A>;
IMPORT <A HREF="../toolmisc/M3Context.i3">M3Context</A>, <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>, <A HREF="../sem/M3ASTNext.i3">M3ASTNext</A>;
IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>, <A HREF="../ast/M3AST_TM_F.i3">M3AST_TM_F</A>, <A HREF="../ast/M3AST_PL_F.i3">M3AST_PL_F</A>;

TYPE
  WClosure = ASTWalk.Closure OBJECT
  OVERRIDES callback := SetNode
  END;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A>(c: M3Context.T) RAISES {}=
  &lt;*FATAL ANY*&gt;
  BEGIN
    M3Context.Apply(c, NEW(M3Context.Closure, callback := SetUnit), FALSE);
  END Set;

PROCEDURE <A NAME="SetUnit"><procedure>SetUnit</procedure></A>(
    &lt;*UNUSED*&gt; cl: M3Context.Closure;
    &lt;*UNUSED*&gt; ut: M3CUnit.Type;
    &lt;*UNUSED*&gt; name: TEXT;
    cu: M3AST_AS.Compilation_Unit) RAISES {}=
  &lt;*FATAL ANY*&gt;
  BEGIN
    ASTWalk.VisitNodes(cu, NEW(WClosure));
  END SetUnit;

PROCEDURE <A NAME="SetNode"><procedure>SetNode</procedure></A>(&lt;*UNUSED*&gt; cl: WClosure;
                             n: AST.NODE;
                  &lt;*UNUSED*&gt; vm: ASTWalk.VisitMode) RAISES {}=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Object_type(ot) =&gt;
        GenerateMethodTable(ot);
    ELSE
    END; (* typecase *)
  END SetNode;

PROCEDURE <A NAME="MethodTableSize"><procedure>MethodTableSize</procedure></A>(ot: M3AST_AS.Object_type): CARDINAL RAISES {}=
  VAR
    iter := M3ASTNext.NewIterObjectMethod(ot);
    method: M3AST_AS.METHOD_OVERRIDE;
    is_override: BOOLEAN;
    count: CARDINAL := 0;
  BEGIN
    WHILE M3ASTNext.ObjectMethod(iter, method, is_override) DO
      IF NOT is_override THEN INC(count) END;
    END; (* while *)
    RETURN count;
  END MethodTableSize;

PROCEDURE <A NAME="GenerateMethodTable"><procedure>GenerateMethodTable</procedure></A>(ot: M3AST_AS.Object_type) RAISES {}=
  VAR
    mts := MethodTableSize(ot);
    mt := NEW(M3AST_PL_F.MethodTable, mts);
    iter := M3ASTNext.NewIterObjectMethod(ot);
    method: M3AST_AS.METHOD_OVERRIDE;
    is_override: BOOLEAN;
    count: CARDINAL := 0;
    slot: CARDINAL;
  BEGIN
    ot.pl_method_table := mt;
    WHILE M3ASTNext.ObjectMethod(iter, method, is_override) DO
      IF is_override THEN
        WITH o_method = method.as_id.vREDEF_ID.sm_int_def DO
          FOR i := 0 TO mts-1 DO
            IF mt[i].method_id = o_method THEN slot := i; EXIT END;
          END; (* for *)
        END;
      ELSE
        mt[count].method_id := method.as_id;
        slot := count;
        INC(count);
      END;
      (* fill in mt[slot] with the procedure value *)
      mt[slot].proc_id := GetDefault(method.as_id);
    END; (* while *)
  END GenerateMethodTable;

PROCEDURE <A NAME="GetDefault"><procedure>GetDefault</procedure></A>(m: M3AST_AS.METHOD_OVERRIDE_ID): M3AST_AS.Proc_id =
  VAR def_id: M3AST_AS.DEF_ID;
  BEGIN
    (* Find the procedure that is bound to 'm', and add 'ot'
    to the list of object types for which it is a default *)
    IF IsDEF_ID(m.vINIT_ID.sm_init_exp, def_id) THEN
      TYPECASE def_id OF
      | M3AST_AS.Proc_id(p) =&gt;
           RETURN p
      | M3AST_AS.METHOD_OVERRIDE_ID(method_id) =&gt;
          RETURN GetDefault(method_id);
      ELSE
      END; (* typecase *)
    END; (* if *)
    RETURN NIL;
  END GetDefault;

PROCEDURE <A NAME="IsDEF_ID"><procedure>IsDEF_ID</procedure></A>(exp: M3AST_AS.EXP;
    VAR (*out*) def_id: M3AST_AS.DEF_ID): BOOLEAN RAISES {}=
  BEGIN
    TYPECASE exp OF
    | NULL =&gt; RETURN FALSE
    | M3AST_AS.Exp_used_id(e) =&gt;
        def_id := e.vUSED_ID.sm_def;

    | M3AST_AS.Select(b) =&gt;
        def_id := b.as_id.vUSED_ID.sm_def;

    ELSE RETURN FALSE
    END; (* typecase *)
    RETURN def_id # NIL;
  END IsDEF_ID;

BEGIN

END M3LMethodTable.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
