<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/pl/M3LReveals.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/pl/M3LReveals.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3LReveals.i3">M3LReveals</A></implements></module>;

IMPORT <A HREF="../../../libm3/derived/TextRefTbl.i3">TextRefTbl</A>;
IMPORT <A HREF="../toolmisc/M3Context.i3">M3Context</A>, <A HREF="../syn/M3CId.i3">M3CId</A>, <A HREF="../toolmisc/M3Error.i3">M3Error</A>, <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>, <A HREF="../gast/ASTWalk.i3">ASTWalk</A>;
IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../ast/M3AST_SM.i3">M3AST_SM</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>;

IMPORT <A HREF="../../derived/SeqM3AST_AS_TYPE_SPEC.i3">SeqM3AST_AS_TYPE_SPEC</A>;
IMPORT <A HREF="../../derived/SeqM3AST_SM_Opaque_type_Revln.i3">SeqM3AST_SM_Opaque_type_Revln</A>;
IMPORT <A HREF="../sem/M3CTypeRelation.i3">M3CTypeRelation</A>, <A HREF="../sem/M3CTypesMisc.i3">M3CTypesMisc</A>;
IMPORT <A HREF="../target/M3CBackEnd_C.i3">M3CBackEnd_C</A>; (* for representation of brands *)

TYPE
  CClosure = M3Context.Closure OBJECT
    result := 0;
    table: TextRefTbl.T;
  OVERRIDES
    callback := CheckRevealsInUnit;
  END;

  WClosure = ASTWalk.Closure OBJECT
    unit: M3AST_AS.UNIT;
    ccl: CClosure;
  OVERRIDES
    callback := CheckBrands;
  END;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A>(c: M3Context.T): INTEGER RAISES {}=
  VAR cl := NEW(CClosure, table := NEW(TextRefTbl.Default).init(50));
  BEGIN
    &lt;*FATAL ANY*&gt; BEGIN
      M3Context.Apply(c, cl);
    END;
    RETURN cl.result;
  END Check;

PROCEDURE <A NAME="CheckRevealsInUnit"><procedure>CheckRevealsInUnit</procedure></A>(cl: CClosure; &lt;*UNUSED*&gt; ut: M3CUnit.Type;
    &lt;*UNUSED*&gt; name: TEXT; cu: M3AST_AS.Compilation_Unit) RAISES {}=
  VAR
    unit: M3AST_AS.UNIT_WITH_BODY := cu.as_root;
    iter := SeqM3AST_SM_Opaque_type_Revln.NewIter(unit.sm_reveal_s);
    otr: M3AST_SM.Opaque_type_Revln;
    ot: M3AST_AS.Opaque_type;
  BEGIN
    WHILE SeqM3AST_SM_Opaque_type_Revln.Next(iter, otr) DO
      ot := NARROW(otr.sm_type_id, M3AST_AS.TYPED_ID).sm_type_spec;
      (* we dont care about partial revelations for types not given
         a concrete revelation. *)
      IF ot.sm_concrete_type_spec # NIL THEN
        VAR
          iter2 := SeqM3AST_AS_TYPE_SPEC.NewIter(otr.sm_opaque_rev_s);
          ts, rts: M3AST_SM.TYPE_SPEC_UNSET;
        BEGIN
          (* the concrete revelation has to be a subtype of all the
             partial ones. *)
          WHILE SeqM3AST_AS_TYPE_SPEC.Next(iter2, ts) DO
            (* 'ts' may be opaque, and for M3CTypeRelation.SubType
                to work, we must use the rhs of the opaque definition. *)
            rts := M3CTypesMisc.Reveal(ts);
            IF NOT M3CTypeRelation.SubType(ot.sm_concrete_type_spec, rts) THEN
              M3Error.SetCu(cu);
              M3Error.ReportWithId(FindRevelationInUnit(cu, ts),
                &quot;incompatible partial \'REVEAL\' for opaque type \'%s\'&quot;,
                   otr.sm_type_id.lx_symrep);
              cl.result := -1;
            END; (* if *)
          END; (* while *)
        END; (* begin *)
      END; (* if *)
    END; (* while *)

    &lt;*FATAL ANY*&gt; BEGIN
      ASTWalk.VisitNodes(cu, NEW(WClosure, ccl := cl, unit := cu.as_root));
    END;
  END CheckRevealsInUnit;

TYPE FClosure = ASTWalk.Closure OBJECT
    ts: M3AST_AS.TYPE_SPEC;
    n: M3AST_AS.Subtype_reveal := NIL;
  OVERRIDES
    callback := FindRevelation;
  END;

PROCEDURE <A NAME="FindRevelationInUnit"><procedure>FindRevelationInUnit</procedure></A>(cu: M3AST_AS.Compilation_Unit;
    ts: M3AST_AS.TYPE_SPEC
    ): M3AST_AS.Subtype_reveal RAISES {}=
  VAR fcl := NEW(FClosure, ts := ts);
  BEGIN
    &lt;*FATAL ANY*&gt; BEGIN
      ASTWalk.VisitNodes(cu, fcl);
    END;
    RETURN fcl.n;
  END FindRevelationInUnit;

PROCEDURE <A NAME="FindRevelation"><procedure>FindRevelation</procedure></A>(fcl: FClosure; n: AST.NODE;
    &lt;*UNUSED*&gt; vm: ASTWalk.VisitMode) RAISES {ASTWalk.Aborted}=
  VAR
    reveal_ts: M3AST_AS.TYPE_SPEC;
  BEGIN
    TYPECASE n OF
    | M3AST_AS.Subtype_reveal(s) =&gt;
        M3CTypesMisc.GetTYPE_SPECFromM3TYPE(
                        s.as_type, reveal_ts);
        IF fcl.ts = reveal_ts THEN
	  fcl.n := s;
	  ASTWalk.Abort();
        END;
    ELSE (* ignore *)
    END;
  END FindRevelation;

PROCEDURE <A NAME="CheckBrands"><procedure>CheckBrands</procedure></A>(wcl: WClosure; n: AST.NODE;
    &lt;*UNUSED*&gt; vm: ASTWalk.VisitMode) RAISES {}=
  VAR id: REFANY;
  BEGIN
    TYPECASE n OF
    | NULL =&gt;
    | M3AST_AS.Brand(b) =&gt;
        IF b.as_exp # NIL THEN
         VAR brand := NARROW(b.sm_brand, M3CBackEnd_C.Text_value).sm_value;
         BEGIN
          IF wcl.ccl.table.put(brand, wcl.unit) THEN
            VAR unit: M3AST_AS.UNIT;
            BEGIN
              EVAL wcl.ccl.table.get(brand, id);
              unit := NARROW(id, M3AST_AS.UNIT);
              wcl.ccl.result := -1;
              M3Error.Report(n,
                &quot;brand &quot; &amp; brand &amp; &quot; already used in &quot; &amp;
                UnitTypeName(unit) &amp; &quot; \'&quot; &amp;
                M3CId.ToText(unit.as_id.lx_symrep) &amp; &quot;\'&quot;);
            END;
           END;
          END; (* if *)
        END; (* if *)
    ELSE
    END;
  END CheckBrands;

PROCEDURE <A NAME="UnitTypeName"><procedure>UnitTypeName</procedure></A>(unit: M3AST_AS.UNIT): TEXT RAISES {}=
  BEGIN
    IF ISTYPE(unit, M3AST_AS.Interface) THEN RETURN &quot;interface&quot;;
    ELSE RETURN &quot;module&quot;;
    END;
  END UnitTypeName;

BEGIN

END M3LReveals.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
