<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/pl/M3LSubtype.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/pl/M3LSubtype.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3LSubtype.i3">M3LSubtype</A></implements></module>;

IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../gast/ASTWalk.i3">ASTWalk</A>, <A HREF="../sem/M3ASTNext.i3">M3ASTNext</A>;
IMPORT <A HREF="../../derived/SeqM3AST_AS_Object_type.i3">SeqM3AST_AS_Object_type</A>;
IMPORT <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>, <A HREF="../ast/M3AST_PL_F.i3">M3AST_PL_F</A>;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A>(cu: M3AST_AS.Compilation_Unit) RAISES {}=
  &lt;*FATAL ANY*&gt;
  BEGIN
    ASTWalk.VisitNodes(cu,
        NEW(ASTWalk.Closure, callback := SetNode));
  END Set;

PROCEDURE <A NAME="SetNode"><procedure>SetNode</procedure></A>(
    &lt;*UNUSED*&gt; cl: ASTWalk.Closure;
    n: AST.NODE;
    &lt;*UNUSED*&gt; vm: ASTWalk.VisitMode)
    RAISES {}=
 BEGIN
   TYPECASE n OF
   | M3AST_AS.Object_type(ot) =&gt;
      (* add self to immediate ancestor *)
      VAR me := ot;
        st: M3AST_AS.Object_type;
      BEGIN
        IF SuperType(ot, st) THEN
          SeqM3AST_AS_Object_type.AddFront(st.pl_subtype_s, me);
        END; (* while *)
      END;
   ELSE
   END; (* typecase *)
 END SetNode;

PROCEDURE <A NAME="SuperType"><procedure>SuperType</procedure></A>(
    object: M3AST_AS.Object_type;
    VAR (* OUT *) superType: M3AST_AS.Object_type)
    : BOOLEAN
    RAISES {}=
  VAR
    ts: M3AST_AS.TYPE_SPEC;
  BEGIN
    IF M3ASTNext.SimpleSuperType(object, ts) AND ts # NIL THEN
      TYPECASE ts OF
      | M3AST_AS.Object_type =&gt;
          superType := ts;
          RETURN TRUE
      | M3AST_AS.Opaque_type(ot) =&gt;
          WITH c = ot.sm_concrete_type_spec DO
            IF c # NIL THEN superType := c; RETURN TRUE; END;
          END;
      ELSE
      END;
    END; (* if *)
    RETURN FALSE;
  END SuperType;
BEGIN

END M3LSubtype.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
