<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/pl/M3LTool.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/pl/M3LTool.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3LTool.i3">M3LTool</A></implements></module>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="#x1">Err</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../../libm3/derived/RefList.i3">RefList</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_PL_F.i3">M3AST_PL_F</A>, <A HREF="../ast/M3AST_TM_F.i3">M3AST_TM_F</A>;

IMPORT <A HREF="../../derived/SeqM3AST_AS_Proc_id.i3">SeqM3AST_AS_Proc_id</A>;

IMPORT <A HREF="../misc/M3Args.i3">M3Args</A>, <A HREF="../toolmisc/M3Context.i3">M3Context</A>;
IMPORT <A HREF="../toolmisc/M3Error.i3">M3Error</A>, <A HREF="../syn/M3CId.i3">M3CId</A>;
IMPORT <A HREF="M3LExports.i3">M3LExports</A>, <A HREF="M3LDepends.i3">M3LDepends</A>, <A HREF="M3LInitOrder.i3">M3LInitOrder</A>, <A HREF="M3LOpaque.i3">M3LOpaque</A>;
IMPORT <A HREF="M3LBackEnd.i3">M3LBackEnd</A>, <A HREF="M3LMain.i3">M3LMain</A>, <A HREF="M3LReveals.i3">M3LReveals</A>;
IMPORT <A HREF="M3LTypeCodes.i3">M3LTypeCodes</A>, <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>;

CONST
  DebugTypeCodes_Arg = &quot;DebugTypeCodes&quot;;
  Main_Arg = &quot;MainModule&quot;;
  MutualDependencies_Arg = &quot;MutualDependencies&quot;;
  ForceInitOrder_Arg = &quot;ForceInitOrder&quot;;

  Version = &quot;Oct-2-92&quot;;

VAR
  tool_g: M3Args.T;

TYPE CClosure = M3Context.Closure OBJECT OVERRIDES callback := ShowErrors END;

PROCEDURE <A NAME="Run"><procedure>Run</procedure></A>(c: M3Context.T; do_depends := TRUE): INTEGER RAISES {}=
  &lt;*FATAL ANY*&gt;
  VAR
    r := DoRun(c, do_depends);
  BEGIN
    M3Context.Apply(c, NEW(CClosure));
    RETURN r;
  END Run;

PROCEDURE <A NAME="ShowErrors"><procedure>ShowErrors</procedure></A>(&lt;*UNUSED*&gt; cl: CClosure;
                     &lt;*UNUSED*&gt; ut: M3CUnit.Type;
                     &lt;*UNUSED*&gt; name: TEXT;
                     cu: M3AST_AS.Compilation_Unit) RAISES {}=
  BEGIN
    M3Error.SetCu(cu); M3Error.ShowAll(cu.as_root);
  END ShowErrors;

PROCEDURE <A NAME="CheckResult"><procedure>CheckResult</procedure></A>(rc: INTEGER; VAR (*inout*) trc: INTEGER) RAISES {}=
  BEGIN
    IF rc &lt; 0 THEN trc := rc; END;
  END CheckResult;

PROCEDURE <A NAME="DoRun"><procedure>DoRun</procedure></A>(c: M3Context.T; do_depends: BOOLEAN): INTEGER RAISES {}=
  TYPE EClosure = M3LExports.Closure BRANDED OBJECT END;
  VAR
    main: M3AST_AS.Compilation_Unit;
    result: INTEGER := 0;
    e_closure: EClosure;
    t: M3LInitOrder.T;
  BEGIN
    IF M3Args.Find(tool_g) THEN
      e_closure := NEW(EClosure, report := ReportExports);
      M3LOpaque.SetReveal(c);
      M3LExports.Check(c, e_closure);
      (* the above call sets up info needed by this pass *)
      CheckResult(M3LReveals.Check(c), result);
      IF result &lt; 0 THEN RETURN result END;
      (* no point in proceeding further *)
      IF do_depends THEN
        M3LDepends.Set(c, M3LDepends.Default());
      END;
      main := MainModule(c, result);
      IF result &lt; 0 THEN RETURN result END;
      VAR cb: M3LInitOrder.MDCallback := NIL;
      BEGIN
        IF M3Args.GetFlag(tool_g, MutualDependencies_Arg) THEN
          cb := NEW(M3LInitOrder.MDCallback, callback := ReportMD);
        END;
        t := NEW(M3LInitOrder.T).init(c, main, cb);
      END;
      VAR
        tcl: M3LTypeCodes.T;
      BEGIN
        tcl := M3LTypeCodes.Set(c, genTexts := TRUE, genFingerPrints := TRUE);
        RETURN M3LBackEnd.Run(c, t, tcl);
      END;
    ELSE
      RETURN -1
    END; (* if *)
  END DoRun;

PROCEDURE <A NAME="ReportMD"><procedure>ReportMD</procedure></A>(&lt;*UNUSED*&gt; cb: M3LInitOrder.MDCallback;
                   m1, m2: M3AST_AS.Module)=
  BEGIN
    Err.Print(Fmt.F(&quot;mutual dependency between %s and %s&quot;,
                    M3CId.ToText(m1.as_id.lx_symrep),
                    M3CId.ToText(m2.as_id.lx_symrep)),
              Err.Severity.Warning);
  END ReportMD;

PROCEDURE <A NAME="MainModule"><procedure>MainModule</procedure></A>(c: M3Context.T;
    VAR (*inout*) result: INTEGER): M3AST_AS.Compilation_Unit RAISES {}=
  VAR
    name: Text.T;
    cu_s: RefList.T;
    cu: M3AST_AS.Compilation_Unit;
  BEGIN
    cu_s := M3LMain.Module(c);
    name := M3Args.GetString(tool_g, Main_Arg);
    IF cu_s = NIL THEN
      Err.Print(&quot;failed to find any main program modules&quot;, Err.Severity.Error);
      result := -1; RETURN NIL;
    ELSE
      cu := cu_s.head;
      IF name = NIL THEN (* there had better be only one *)
        IF cu_s.tail # NIL THEN
          Err.Print(Fmt.F(&quot;more than one exporter of \'%s\' interface&quot;,
              M3LMain.Name),
              Err.Severity.Error);
          result := -1; RETURN NIL;
        ELSE
          RETURN cu (* take first *)
	END;
      END;

      (* take one which matches given name *)
      WHILE cu_s # NIL DO
        cu := cu_s.head;
      	IF Text.Equal(name, M3CId.ToText(cu.as_root.as_id.lx_symrep)) THEN
	  RETURN cu;
	END; (* if *)
        cu_s := cu_s.tail;
      END; (* while *)
      Err.Print(Fmt.F(&quot;no module named \'%s\' which exports \'%s\'&quot;,
                      name, M3LMain.Name), Err.Severity.Error);
      result := -1; RETURN NIL;
    END; (* if *)
  END MainModule;

PROCEDURE <A NAME="ReportExports"><procedure>ReportExports</procedure></A>(
    &lt;*UNUSED*&gt; cl: M3LExports.Closure;
    cu: M3AST_AS.Compilation_Unit;
    an: M3AST_AS.SRC_NODE) RAISES {}=
  VAR
    en: M3Error.ERROR_NODE;
    id1, id2: M3CId.T;
  BEGIN
    id1 := NARROW(an, M3AST_AS.DEF_ID).lx_symrep;
    id2 := NARROW(cu.as_root, M3AST_AS.Interface).as_id.lx_symrep;
    en := an;
    M3Error.SetCu(cu);
    TYPECASE an OF &lt;*NOWARN*&gt;
    | M3AST_AS.Proc_id(proc_id) =&gt;
       IF NOT M3LBackEnd.HardWired(M3CId.ToText(id2), M3CId.ToText(id1)) THEN
        M3Error.WarnWithId(en,
            &quot;procedure \'%s\' in interface \'%s\' is not implemented&quot;, id1, id2);
        SeqM3AST_AS_Proc_id.AddRear(
            NARROW(proc_id.tmp_unit_id, M3AST_AS.Interface_id).pl_missing_proc_s,
            an);
       END;

    | M3AST_AS.Type_id =&gt;
        M3Error.WarnWithId(en,
            &quot;opaque type %s in interface %s is not implemented&quot;, id1, id2);
    END; (* case *)
  END ReportExports;

PROCEDURE <A NAME="Initialise"><procedure>Initialise</procedure></A>(): M3Args.T RAISES {}=
  BEGIN
    tool_g := M3Args.New(&quot;m3l&quot;, &quot;Modula-3 Pre-Linker&quot;, Version);
    M3Args.RegisterString(tool_g, Main_Arg,
      &quot;name of main program module (default \'Main\')&quot;);
    M3Args.RegisterString(tool_g, ForceInitOrder_Arg,
      &quot;force initialisation order from given file&quot;);
    M3Args.RegisterFlag(tool_g, DebugTypeCodes_Arg,
      &quot;debug typecode generation&quot;);
    M3Args.RegisterFlag(tool_g, MutualDependencies_Arg,
      &quot;show mutual dependencies between modules&quot;);
    M3LBackEnd.RegisterArgs(tool_g);
    RETURN tool_g;
  END Initialise;

BEGIN
END M3LTool.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Err is in:
</A><UL>
<LI><A HREF="../../../dps/src/Err.i3#0TOP0">dps/src/Err.i3</A>
<LI><A HREF="../misc/Err.i3#0TOP0">m3tk/src/misc/Err.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
