<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/pl/M3LTypeCodes.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/pl/M3LTypeCodes.i3</H2></A><HR>
<inInterface>
<PRE>INTERFACE <interface><A HREF="M3LTypeCodes.m3">M3LTypeCodes</A></interface>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="../toolmisc/M3Context.i3">M3Context</A>;
IMPORT <A HREF="M3LFingerPrint.i3">M3LFingerPrint</A>;

TYPE
  T = RECORD
    types: REF ARRAY OF M3AST_AS.TYPE_SPEC;
    texts: REF ARRAY OF TEXT := NIL;
    fingerprints: REF ARRAY OF M3LFingerPrint.T := NIL;
  END; (* record *)

PROCEDURE <A HREF="M3LTypeCodes.m3#Set">Set</A>(
    c: M3Context.T;
    allTypes := FALSE;
    genTexts := TRUE;
    genFingerPrints := TRUE;
    ): T RAISES {};
</PRE> This procedure visits all the units in <CODE>c</CODE> and computes
   the <CODE>tmp_type_code</CODE> attribute (see M3AST_TM) for a subset of 
   the <CODE>TYPE_SPEC</CODE> nodes found in those units. If <CODE>allTypes = TRUE</CODE>, 
   then every <CODE>TYPE_SPEC</CODE> node is included, otherwise only those
   types on the <CODE>UNIT_NORMAL.sm_type_spec_s</CODE> sequence, and
   those types reachable from these are included. This
   restricted set corresponds to the set of reference types,
   for which a Modula-3 runtime environment must have
   type codes.
<P>
   The result of the procedure is a record containing one, two or three
   arrays, all off the same length. The <CODE>types</CODE> array contains
   all the (distinct) types for which a value of <CODE>tmp_type_code</CODE> was 
   computed. Every member of the <CODE>types</CODE> array represents a different 
   type in the sense defined by the Modula-3 structural equivalance
   rules. The value of the <CODE>tmp_type_code</CODE> attribute is an index
   in the range <CODE>0 .. NUMBER(T.types^)-1</CODE>
<P>
   The <CODE>texts</CODE> array is only generated if <CODE>genTexts = TRUE</CODE>.
   The <CODE>fingerprints</CODE> array is only generated if <CODE>genFingerPrints = TRUE</CODE>.
   A member of the <CODE>texts</CODE> array, <CODE>texts[i], is a canonical textual 
   representation for the </CODE>TYPE_SPEC<CODE> in </CODE>types[i]<CODE>. It will
   be distinct for each value of </CODE>i<CODE>. The interface </CODE>M3LTypeToText<CODE>
   documents the format of the generated text. A member of the </CODE>fingerprints<CODE>
   array, </CODE>fingerprints[i]<CODE>, is a unique fingerprint generated from
   the text </CODE>texts[i]<CODE>. 


<P><PRE>END M3LTypeCodes.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
