<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/pl/M3LTypeCodes.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/pl/M3LTypeCodes.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3LTypeCodes.i3">M3LTypeCodes</A></implements></module>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../../../property/src/PropertyV.i3">PropertyV</A>, <A HREF="../../../rw/src/Common/TextWr.i3">TextWr</A>, <A HREF="../../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../../libm3/derived/IntIntTbl.i3">IntIntTbl</A>;

IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../ast/M3AST_SM.i3">M3AST_SM</A>, <A HREF="../toolmisc/M3CUnit.i3">M3CUnit</A>, <A HREF="../gast/ASTWalk.i3">ASTWalk</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>, <A HREF="../ast/M3AST_FE_F.i3">M3AST_FE_F</A>, <A HREF="../ast/M3AST_TM_F.i3">M3AST_TM_F</A>, <A HREF="../ast/M3AST_TL_F.i3">M3AST_TL_F</A>;

IMPORT <A HREF="../../derived/SeqM3AST_AS_TYPE_SPEC.i3">SeqM3AST_AS_TYPE_SPEC</A>;

IMPORT <A HREF="../toolmisc/M3Context.i3">M3Context</A>;
IMPORT <A HREF="../misc/M3Assert.i3">M3Assert</A>;

IMPORT <A HREF="M3LTypeEquiv.i3">M3LTypeEquiv</A>, <A HREF="../sem/M3CTypesMisc.i3">M3CTypesMisc</A>;
IMPORT <A HREF="M3LTypeSpecToText.i3">M3LTypeSpecToText</A>, <A HREF="M3LFingerPrint.i3">M3LFingerPrint</A>;
</PRE> We keep a list of opaque types so that we can quickly set their
   typecode to that of the concrete counterpart.


<P><PRE>IMPORT <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;
&lt;*FATAL Wr.Failure, Thread.Alerted*&gt;

TYPE
  CClosure = M3Context.Closure OBJECT
    componentTypes: IntIntTbl.T;
    allTypes := FALSE;
  OVERRIDES
    callback := SetUnit;
  END;

  WClosure = ASTWalk.Closure OBJECT
    ccl: CClosure;
  OVERRIDES
    callback := AddTypeSpec;
  END;

CONST
  NoGenericDefs = M3CUnit.TypeSet{
      M3CUnit.Type.Interface, M3CUnit.Type.Interface_gen_ins,
      M3CUnit.Type.Module, M3CUnit.Type.Module_gen_ins};

PROCEDURE <A NAME="AddArrayType"><procedure>AddArrayType</procedure></A>(array: M3AST_AS.Array_type) RAISES {}=
  VAR
    a: M3AST_AS.Array_type;
    elem: M3AST_SM.TYPE_SPEC_UNSET := NIL;
  BEGIN
    a := array.sm_norm_type;
    IF array # a THEN
      M3LTypeEquiv.Add(array);
    END;
    LOOP
      (* on multiple dimension arrays, a is elem.sm_norm_type *)
      IF a # elem THEN
        M3LTypeEquiv.Add(a);
      END;
      M3CTypesMisc.GetTYPE_SPECFromM3TYPE(a.as_elementtype, elem);
      M3LTypeEquiv.Add(elem);
      IF ISTYPE(elem, M3AST_AS.Array_type) THEN
        a := NARROW(elem, M3AST_AS.Array_type).sm_norm_type;
      ELSE
        EXIT;
      END;
    END;
  END AddArrayType;

PROCEDURE <A NAME="AddComponentTypeSpec"><procedure>AddComponentTypeSpec</procedure></A>(
    wcl: WClosure; t: M3AST_SM.TYPE_SPEC_UNSET) RAISES {}=
  VAR
    void: INTEGER;
    unique_id := GetHackUniqueId(t);
  BEGIN
    IF M3CTypesMisc.IsRef(t) OR
        wcl.ccl.componentTypes.get(unique_id, void) THEN
      (* If is a reference type it will be handled when 'SetUnit' is
       called on the interface in which it is declared. If it is noted
       in the 'componentTypes' table it has already been dealt with *)
    ELSE
      EVAL wcl.ccl.componentTypes.put(unique_id, 0);
      ASTWalk.VisitNodes(t, wcl); &lt;*NOWARN*&gt;
    END;
  END AddComponentTypeSpec;

PROCEDURE <A NAME="AddTypeSpec"><procedure>AddTypeSpec</procedure></A>(
    wcl: WClosure; any: AST.NODE; &lt;*UNUSED*&gt; vm: ASTWalk.VisitMode) RAISES {}=
  BEGIN
    TYPECASE any OF
    | M3AST_AS.Fields(fields) =&gt;
        IF fields.as_type = NIL THEN
          AddComponentTypeSpec(wcl, fields.as_default.sm_exp_type_spec);
        END;
    | M3AST_AS.Formal_param(formal) =&gt;
        IF formal.as_formal_type = NIL THEN
          AddComponentTypeSpec(wcl, formal.as_default.sm_exp_type_spec);
        END;
    | M3AST_AS.Array_type(array_type) =&gt;
        AddArrayType(array_type);
    | M3AST_AS.Subrange_type(set_type) =&gt;
        M3LTypeEquiv.Add(set_type);
        M3LTypeEquiv.Add(set_type.sm_base_type_spec);
    | M3AST_SM.Any_type, M3AST_SM.Type_type =&gt;
        (* do nothing with these *)
    | M3AST_AS.TYPE_SPEC =&gt;
        M3LTypeEquiv.Add(any);
    | M3AST_AS.Named_type(named_type) =&gt;
        AddComponentTypeSpec(wcl, named_type.sm_type_spec);
    | M3AST_AS.EXP(e) =&gt;
        IF NOT ISTYPE(e.sm_exp_type_spec, M3AST_SM.Void_type) THEN
          M3LTypeEquiv.Add(e.sm_exp_type_spec)
        END (* IF *)
    ELSE
      (* nothing *)
    END; (* case *)
  END AddTypeSpec;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A>(
    c: M3Context.T;
    allTypes := FALSE;
    genTexts := TRUE;
    genFingerPrints := TRUE;
    ): T RAISES {}=
  VAR
    ccl := NEW(CClosure, componentTypes := NEW(IntIntTbl.Default).init(),
               allTypes := allTypes);
    res: T;
  BEGIN
    HackUniqueIds(c);
    M3LTypeEquiv.Initialize();
    M3Context.ApplyToSet(c, ccl, NoGenericDefs, TRUE); &lt;*NOWARN*&gt;
    res.types := M3LTypeEquiv.Partition();
    IF genTexts THEN
      (* must be after partition for sm_type_codes *)
      M3LTypeSpecToText.Initialize();
      VAR
        textStream: TextWr.T;
      BEGIN
        res.texts := NEW(REF ARRAY OF TEXT, NUMBER(res.types^));
        FOR i := 0 TO LAST(res.texts^) DO
          textStream := TextWr.New();
          M3LTypeSpecToText.TypeSpec(textStream, res.types[i]);
          res.texts[i] := TextWr.ToText(textStream);
          Wr.Close(textStream);
        END; (* for *)
      END;
    END;
    IF genTexts AND genFingerPrints THEN
      res.fingerprints := M3LFingerPrint.Generate(res.texts);
    END; (* if *)
    RETURN res;
  END Set;

PROCEDURE <A NAME="SetUnit"><procedure>SetUnit</procedure></A>(ccl: CClosure; ut: M3CUnit.Type; &lt;*UNUSED*&gt; name: Text.T;
    cu: M3AST_AS.Compilation_Unit) RAISES {}=
  VAR
    wcl := NEW(WClosure, ccl := ccl);
  BEGIN
    cu := M3CUnit.ToGenIns(cu, ut);
    IF cu = NIL OR NOT(M3CUnit.State.SemChecked IN cu.fe_status) OR
                       M3CUnit.State.SErrors IN cu.fe_status THEN
      (* bullet proofing *)
      RETURN
    END;

    IF ccl.allTypes THEN
      ASTWalk.VisitNodes(cu, wcl) &lt;*NOWARN*&gt;
    ELSE
      VAR
        iter := SeqM3AST_AS_TYPE_SPEC.NewIter(
                    NARROW(cu.as_root, M3AST_AS.UNIT_NORMAL).sm_type_spec_s);
        type_spec: M3AST_AS.TYPE_SPEC;
      BEGIN
        (* visit all the TYPE_SPECs hung off the sm_type_spec_s list *)
        WHILE SeqM3AST_AS_TYPE_SPEC.Next(iter, type_spec) DO
          ASTWalk.VisitNodes(type_spec, wcl); &lt;*NOWARN*&gt;
        END; (* while *)
      END;
    END;
  END SetUnit;
</PRE> Since we cant use HashRef, we need a way to uniqely identify (with
an integer) a TYPE_SPEC node. This is a temporary lash up. 

<P><PRE>TYPE
  HackClosure = M3Context.Closure OBJECT
    id := 0;
  OVERRIDES
    callback := HackUniqueIdForUnit;
  END;

PROCEDURE <A NAME="HackUniqueIds"><procedure>HackUniqueIds</procedure></A>(c: M3Context.T) RAISES {}=
  BEGIN
    M3Context.ApplyToSet(c, NEW(HackClosure), NoGenericDefs, TRUE); &lt;*NOWARN*&gt;
  END HackUniqueIds;

PROCEDURE <A NAME="HackUniqueIdForUnit"><procedure>HackUniqueIdForUnit</procedure></A>(cl: HackClosure; ut: M3CUnit.Type;
                              &lt;*UNUSED*&gt; name: Text.T;
                              cu: M3AST_AS.Compilation_Unit) RAISES {}=
  VAR
    ri := NEW(REF INTEGER);
  BEGIN
    cu := M3CUnit.ToGenIns(cu, ut);
    IF cu = NIL THEN RETURN END;
    ri^ := cl.id; INC(cl.id);
    PropertyV.Put(cu.tl_pset, ri);
  END HackUniqueIdForUnit;

PROCEDURE <A NAME="GetHackUniqueId"><procedure>GetHackUniqueId</procedure></A>(t: M3AST_AS.TYPE_SPEC): INTEGER RAISES {}=
  VAR
    x: INTEGER;
  BEGIN
    IF t.tmp_unit_id = NIL THEN x := 0; (* built-ins *)
    ELSE
      VAR
        cu := t.tmp_unit_id.sm_spec.sm_comp_unit;
        ri: REF INTEGER := PropertyV.Get(cu.tl_pset, TYPECODE(REF INTEGER));
      BEGIN
        M3Assert.Check(t.lx_srcpos # 0);
        x := ri^;
      END;
    END;
    RETURN Word.Or(Word.Shift(x, 16), t.lx_srcpos);
  END GetHackUniqueId;

BEGIN
END M3LTypeCodes.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
