<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/sem/M3ASTNext.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/sem/M3ASTNext.i3</H2></A><HR>
<inInterface>
<PRE>INTERFACE <interface><A HREF="M3ASTNext.m3">M3ASTNext</A></interface>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../ast/M3AST_LX.i3">M3AST_LX</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../ast/M3AST_SM.i3">M3AST_SM</A>;
IMPORT <A HREF="../../derived/SeqM3AST_AS_Var_decl.i3">SeqM3AST_AS_Var_decl</A>, <A HREF="../../derived/SeqM3AST_AS_Fields.i3">SeqM3AST_AS_Fields</A>, <A HREF="../../derived/SeqM3AST_AS_Formal_param.i3">SeqM3AST_AS_Formal_param</A>,
    <A HREF="../../derived/SeqM3AST_AS_Case.i3">SeqM3AST_AS_Case</A>, <A HREF="../../derived/SeqM3AST_AS_Handler.i3">SeqM3AST_AS_Handler</A>, <A HREF="../../derived/SeqM3AST_AS_Tcase.i3">SeqM3AST_AS_Tcase</A>,
    <A HREF="../../derived/SeqM3AST_AS_IMPORTED.i3">SeqM3AST_AS_IMPORTED</A>;
</PRE>------------------------------- 
 FLATTENING COMPLEX ITERATIONS 
-------------------------------

<P>  A series of iterators for flattening nasty M3 AST iterations e.g. the 'Var'
iterator just iterates all the 'Var_id's in a 'seqVar_decl', so the user
doesn't have to iterate the 'Var_decl's then the 'Var_id's for each decl.
  They are all used in a similar manner; here is an example using the 'Var'
iterator.
<P>
    VAR
      iter := M3ASTNext.IterVar(seqVar_decl);
    BEGIN
      WHILE M3ASTNext.Var(iter, varId) DO
        ..your code..
      END;


<P><PRE>TYPE
  <A HREF="M3ASTNext.m3#IterVar">IterVar</A> &lt;: REFANY;

PROCEDURE <A HREF="M3ASTNext.m3#NewIterVar">NewIterVar</A>(seqVar_decl: SeqM3AST_AS_Var_decl.T): IterVar RAISES {};

PROCEDURE <A HREF="M3ASTNext.m3#Var">Var</A>(
    VAR (* INOUT *) iter: IterVar;
    VAR (* OUT *) var_id: M3AST_AS.Var_id)
    : BOOLEAN
    RAISES {};

TYPE
  <A HREF="M3ASTNext.m3#IterField">IterField</A> &lt;: REFANY;

PROCEDURE <A HREF="M3ASTNext.m3#NewIterField">NewIterField</A>(seqFields: SeqM3AST_AS_Fields.T): IterField RAISES {};

PROCEDURE <A HREF="M3ASTNext.m3#Field">Field</A>(
    VAR (* INOUT *) iter: IterField;
    VAR (* OUT *) field_id: M3AST_AS.Field_id)
    : BOOLEAN
    RAISES {};

TYPE
  <A HREF="M3ASTNext.m3#IterFormal">IterFormal</A> &lt;: REFANY;

PROCEDURE <A HREF="M3ASTNext.m3#NewIterFormal">NewIterFormal</A>(
    seqFormal_param: SeqM3AST_AS_Formal_param.T)
    : IterFormal
    RAISES {};

PROCEDURE <A HREF="M3ASTNext.m3#Formal">Formal</A>(
    VAR (* INOUT *) iter: IterFormal;
    VAR (* OUT *) formal_param: M3AST_AS.Formal_param;
    VAR (* OUT *) formal_id: M3AST_AS.FORMAL_ID)
    : BOOLEAN
    RAISES {};

TYPE
  <A HREF="M3ASTNext.m3#IterCaseLabel">IterCaseLabel</A> &lt;: REFANY;

PROCEDURE <A HREF="M3ASTNext.m3#NewIterCaseLabel">NewIterCaseLabel</A>(
    seqCase: SeqM3AST_AS_Case.T)
    : IterCaseLabel
    RAISES {};

PROCEDURE <A HREF="M3ASTNext.m3#CaseLabel">CaseLabel</A>(
    VAR (* INOUT *) iter: IterCaseLabel;
    VAR (* OUT *) m3_case: M3AST_AS.Case;
    VAR (* OUT *) label: M3AST_AS.RANGE_EXP)
    : BOOLEAN
    RAISES {};

TYPE
  <A HREF="M3ASTNext.m3#IterHandlerLabel">IterHandlerLabel</A> &lt;: REFANY;

PROCEDURE <A HREF="M3ASTNext.m3#NewIterHandlerLabel">NewIterHandlerLabel</A>(
    seqHandler: SeqM3AST_AS_Handler.T)
    : IterHandlerLabel
    RAISES {};

PROCEDURE <A HREF="M3ASTNext.m3#HandlerLabel">HandlerLabel</A>(
    VAR (* INOUT *) iter: IterHandlerLabel;
    VAR (* OUT *) handler: M3AST_AS.Handler;
    VAR (* OUT *) label: M3AST_AS.Qual_used_id)
    : BOOLEAN
    RAISES {};

TYPE
  <A HREF="M3ASTNext.m3#IterTypeCaseLabel">IterTypeCaseLabel</A> &lt;: REFANY;

PROCEDURE <A HREF="M3ASTNext.m3#NewIterTypeCaseLabel">NewIterTypeCaseLabel</A>(
    seqTcase: SeqM3AST_AS_Tcase.T)
    : IterTypeCaseLabel
    RAISES {};

PROCEDURE <A HREF="M3ASTNext.m3#TypeCaseLabel">TypeCaseLabel</A>(
    VAR (* INOUT *) iter: IterTypeCaseLabel;
    VAR (* OUT *) tcase: M3AST_AS.Tcase;
    VAR (* OUT *) label: M3AST_AS.M3TYPE)
    : BOOLEAN
    RAISES {};

TYPE
  <A HREF="M3ASTNext.m3#IterImportedId">IterImportedId</A> &lt;: REFANY;

PROCEDURE <A HREF="M3ASTNext.m3#NewIterImportedId">NewIterImportedId</A>(i: SeqM3AST_AS_IMPORTED.T): IterImportedId RAISES {};

PROCEDURE <A HREF="M3ASTNext.m3#ImportedId">ImportedId</A>(
    VAR (*inout*) iter: IterImportedId;
    VAR (*out*) used_intf_id: M3AST_AS.Used_interface_id)
    : BOOLEAN
    RAISES {};
</PRE><BLOCKQUOTE><EM> Returns the sequence of imported interface ids in the order they
appear in the AST. </EM></BLOCKQUOTE><PRE>
</PRE>--------------
 OBJECT TYPES 
--------------

<P> A series of iterators for object types. They provide ways of finding the
supertype and iterating fields and methods 

<P><PRE>PROCEDURE <A HREF="M3ASTNext.m3#SimpleSuperType">SimpleSuperType</A>(
    type: M3AST_AS.Object_type;
    VAR (* OUT *) superType: M3AST_SM.TYPE_SPEC_UNSET)
    : BOOLEAN
    RAISES {};
</PRE><BLOCKQUOTE><EM> If 'type' has no supertype (other than ones common to all object types)
returns FALSE and leaves 'superType' unchanged.
  Otherwise returns TRUE. If the supertype is unresolved (e.g. an undeclared
name) or recursive sets 'superType' to unset otherwise sets 'superType' to
the supertype, even if it is unsuitable i.e. not an object or opaque type.
  This routine assumes that names (in particular the name of the supertype of
'type', if any!) are resolved. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3ASTNext.m3#SuperType">SuperType</A>(
    type: M3AST_AS.Object_type;
    VAR (* OUT *) superType: M3AST_AS.Object_type)
    : BOOLEAN
    RAISES {};
</PRE><BLOCKQUOTE><EM> This routine is intended for use when iterating fields and methods. If
'type' has a supertype (other than the ones common to all object types e.g.
REFANY) this supertype can validly be either an opaque type which is revealed
to be an object type or a simple object type.
  If 'type' has an opaque supertype which is revealed to be an object type and
that object type is not the root object type (i.e. OBJANY) TRUE is returned and
'superType' is set to be the revealed object type.
  If 'type' has a supertype which is a simple object type TRUE is returned
and 'superType' is set to be that object type.
  Otherwise FALSE is returned and 'superType' is not altered.
  This routine assumes that names (in particular the name of the supertype of
'type', if any!) are resolved. It also uses 'M3CConcTypeSpec.CurrentReveal' to
find the current revelation for an opaque supertype </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="M3ASTNext.m3#IterObjectField">IterObjectField</A> &lt;: REFANY;

PROCEDURE <A HREF="M3ASTNext.m3#NewIterObjectField">NewIterObjectField</A>(
    o: M3AST_AS.Object_type)
    : IterObjectField
    RAISES {};

PROCEDURE <A HREF="M3ASTNext.m3#ObjectField">ObjectField</A>(
    VAR (* INOUT *) iter: IterObjectField;
    VAR (* OUT *) field_id: M3AST_AS.Field_id)
    : BOOLEAN
    RAISES {};
</PRE><BLOCKQUOTE><EM> Starts with the root super-type and goes through the current type iterating
each type's fields.  </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="M3ASTNext.m3#IterObjectMethod">IterObjectMethod</A> &lt;: REFANY;

PROCEDURE <A HREF="M3ASTNext.m3#NewIterObjectMethod">NewIterObjectMethod</A>(
    o: M3AST_AS.Object_type)
    : IterObjectMethod
    RAISES {};

PROCEDURE <A HREF="M3ASTNext.m3#ObjectMethod">ObjectMethod</A>(
    VAR (* INOUT *) iter: IterObjectMethod;
    VAR (* OUT *) method: M3AST_AS.METHOD_OVERRIDE;
    VAR (* OUT *) overrides: BOOLEAN)
    : BOOLEAN
    RAISES {};
</PRE><BLOCKQUOTE><EM> Starts with the root super-type and goes through the current type iterating
each the type's methods.  Overrides is true if the method only overrides a
super-type's method procedure.  This is a convenience for backward 
compatibility, since <CODE>overrides = ISTYPE(method, M3AST_AS.Override)</CODE> </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="M3ASTNext.m3#IterFieldOrMethod">IterFieldOrMethod</A> &lt;: REFANY;

PROCEDURE <A HREF="M3ASTNext.m3#NewIterFieldOrMethod">NewIterFieldOrMethod</A>(
    o: M3AST_AS.Object_type)
    : IterFieldOrMethod
    RAISES {};

PROCEDURE <A HREF="M3ASTNext.m3#FieldOrMethod">FieldOrMethod</A>(
    VAR iter: IterFieldOrMethod;
    VAR field: M3AST_AS.Field_id;
    VAR method: M3AST_AS.Method;
    VAR symrep: M3AST_LX.Symbol_rep)
    : BOOLEAN
    RAISES {};
</PRE><BLOCKQUOTE><EM> Iterator for the fields and methods in an object. The iteration order is
fields then methods at the current level then, if the object type has any
supertypes, fields then methods of the supertype and so on.
  If 'FieldOrMethod' succeeds in finding another field or method it returns
TRUE and sets 'symrep' to be the name of the field or method. If a field was
found 'field' is set appropriately and 'method' is set to NIL otherwise
'method' is set and 'field' is set to NIL. The iteration skips any method
overrides.
  If there are no more fields or methods FALSE is returned.
  The iteration uses the 'SuperType' procedure; hence names must be resolved
and the current revelation of any opaque super type must be available.
  So a typical iteration might be:
    IDL.InitSEQIterator(iter);
    WHILE M3ASTNext.FieldOrMethod(o, iter, field, method, symrep) DO
      .. whatever ..
    END; (* while </EM></BLOCKQUOTE><PRE>;
*)
</PRE>-------------
 ARRAY TYPES 
-------------

<P> An iterator for multi dimensional arrays 

<P><PRE>PROCEDURE <A HREF="M3ASTNext.m3#Array">Array</A>(
    array: M3AST_AS.Array_type;
    VAR (* OUT *) elementType: M3AST_SM.TYPE_SPEC_UNSET;
    VAR (* OUT *) openArray: BOOLEAN;
    VAR (* OUT *) indexType: M3AST_SM.TYPE_SPEC_UNSET)
    : BOOLEAN (* elementtype is an array i.e. array is multi-dimensional *)
    RAISES {};
</PRE><BLOCKQUOTE><EM> A bit of a mess, but useful.  Take an array and return it element and
   index types.  If the array is open, then there is no indexType.
   Return TRUE if the elements of the array are arrays.  This requires
   sm_norm_type to have been computed.
<P>
   Loop would look like:
<P>
   array := ...
   LOOP
     multiDim := M3ASTNext.Array(array, elementType, openArray, indexType);
     ...
     IF NOT multiDim THEN EXIT END;
   END;
</EM></BLOCKQUOTE><PRE>

END M3ASTNext.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
