<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/sem/M3CConsActualS.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/sem/M3CConsActualS.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3CConsActualS.i3">M3CConsActualS</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../ast/M3AST_SM.i3">M3AST_SM</A>, <A HREF="M3ASTNext.i3">M3ASTNext</A>;

IMPORT <A HREF="../ast/M3AST_LX_F.i3">M3AST_LX_F</A>, <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>;

IMPORT <A HREF="../../derived/SeqM3AST_AS_RANGE_EXP.i3">SeqM3AST_AS_RANGE_EXP</A>, <A HREF="../../derived/SeqM3AST_AS_CONS_ELEM.i3">SeqM3AST_AS_CONS_ELEM</A>;

IMPORT <A HREF="../toolmisc/M3Error.i3">M3Error</A>, <A HREF="M3CTypesMisc.i3">M3CTypesMisc</A>, <A HREF="M3CTypeChkUtil.i3">M3CTypeChkUtil</A>, <A HREF="M3CActualUtil.i3">M3CActualUtil</A>,
    <A HREF="M3CExpValue.i3">M3CExpValue</A>, <A HREF="M3CBackEnd.i3">M3CBackEnd</A>;

&lt;*INLINE*&gt; PROCEDURE <A NAME="AddConstructorElement"><procedure>AddConstructorElement</procedure></A>(
    constructor: M3AST_AS.Constructor;
    rangeExp: M3AST_AS.RANGE_EXP)
    RAISES {}=
  BEGIN
    SeqM3AST_AS_RANGE_EXP.AddRear(constructor.sm_actual_s, rangeExp);
  END AddConstructorElement;

&lt;*INLINE*&gt; PROCEDURE <A NAME="AddNewRangeExp"><procedure>AddNewRangeExp</procedure></A>(
    constructor: M3AST_AS.Constructor;
    exp: M3AST_AS.EXP)
    RAISES {}=
  VAR
    r: M3AST_AS.Range_EXP := NIL;
  BEGIN
    IF exp # NIL THEN
      r := NEW(M3AST_AS.Range_EXP).init();
      r.lx_srcpos := exp.lx_srcpos;
      r.as_exp := exp;
    END;
    AddConstructorElement(constructor, r);
  END AddNewRangeExp;

PROCEDURE <A NAME="RecordBuild"><procedure>RecordBuild</procedure></A>(
    cons: M3AST_AS.Constructor;
    recordType: M3AST_AS.Record_type)
    RAISES {}=
  VAR
    elements := M3CActualUtil.ElementList(cons);
    iterFields := M3ASTNext.NewIterField(recordType.as_fields_s);
    fieldId: M3AST_AS.Field_id;
    exp: M3AST_AS.EXP;
  BEGIN

    FOR pos := 0 TO M3CActualUtil.PositionalActuals(elements) - 1 DO
      IF M3ASTNext.Field(iterFields, fieldId) THEN
        AddNewRangeExp(cons,
            M3CActualUtil.ActualAt(elements, pos, fieldId.lx_symrep));
      ELSE
        M3Error.Report(cons, &quot;too many elements in record constructor&quot;);
        M3CActualUtil.FindUnmatched(elements);
        RETURN;
      END;
    END;

    (* For the remaining fields, see if there is a keyword element.
     If there is, use its expression.  If not, use the default. *)
    WHILE M3ASTNext.Field(iterFields, fieldId) DO
      IF NOT M3CActualUtil.ActualByKeyword(elements, fieldId, exp) THEN
        exp := fieldId.vINIT_ID.sm_init_exp;
        IF exp # NIL THEN
          (* Should be a default *)
          IF exp = M3AST_SM.UNSET_EXP() THEN
            (* Error elsewhere - set 'exp' to NIL *)
            exp := NIL;
          ELSE
            (* Default has been correctly set up *)
          END;
        ELSE
          IF fieldId.lx_symrep # NIL THEN
            M3Error.ReportWithId(cons,
                &quot;no value for field \'%s\'&quot;, fieldId.lx_symrep);
          END;
        END;
      END;
      (* Always append 'exp' to list, even if it is NIL, so that the later
       typechecking phase can compare the correct expression against the
       correct field *)
      AddNewRangeExp(cons, exp);
    END;

    IF cons.as_propagate # NIL THEN
      M3Error.Report(cons, &quot;propagation not allowed in record constructor&quot;);
    END; (* if *)

    M3CActualUtil.FindUnmatched(elements);
  END RecordBuild;

PROCEDURE <A NAME="CheckClass"><procedure>CheckClass</procedure></A>(exp: M3AST_SM.EXP_UNSET): BOOLEAN RAISES {}=
  BEGIN
    IF exp = NIL THEN
      RETURN FALSE;
    ELSE
      RETURN M3CTypeChkUtil.IsNormalEXP(exp);
    END;
  END CheckClass;

&lt;*INLINE*&gt; PROCEDURE <A NAME="CheckClassAndAddConstructorElement"><procedure>CheckClassAndAddConstructorElement</procedure></A>(
    cons: M3AST_AS.Constructor;
    rangeExp: M3AST_AS.Range_EXP)
    RAISES {}=
  BEGIN
    (* In array and set constructors we are not worried by the order of
     the 'sm_actual_s' list so we do not bother to add NIL elements *)
    IF CheckClass(rangeExp.as_exp) THEN
      AddConstructorElement(cons, rangeExp);
    END;
  END CheckClassAndAddConstructorElement;

PROCEDURE <A NAME="ArrayBuild"><procedure>ArrayBuild</procedure></A>(cons: M3AST_AS.Constructor) RAISES {}=
  VAR
    iter := SeqM3AST_AS_CONS_ELEM.NewIter(cons.as_element_s);
    elem: M3AST_AS.CONS_ELEM;
  BEGIN
    WHILE SeqM3AST_AS_CONS_ELEM.Next(iter, elem) DO
      TYPECASE elem OF &lt;*NOWARN*&gt;
      | M3AST_AS.Actual_elem =&gt;
          M3Error.Report(elem,
              &quot;keyword bindings not allowed in array constructor&quot;);
      | M3AST_AS.RANGE_EXP_elem(rangeExpElem) =&gt;
          TYPECASE rangeExpElem.as_range_exp OF &lt;*NOWARN*&gt;
          | M3AST_AS.Range =&gt;
              M3Error.Report(elem, &quot;range not allowed in array constructor&quot;);
          | M3AST_AS.Range_EXP(rangeExp) =&gt;
              CheckClassAndAddConstructorElement(cons, rangeExp);
          END;
      END; (* typecase *)
    END;
  END ArrayBuild;

PROCEDURE <A NAME="SetBuild"><procedure>SetBuild</procedure></A>(cons: M3AST_AS.Constructor) RAISES {}=
  VAR
    iter := SeqM3AST_AS_CONS_ELEM.NewIter(cons.as_element_s);
    elem: M3AST_AS.CONS_ELEM;
  BEGIN
    WHILE SeqM3AST_AS_CONS_ELEM.Next(iter, elem) DO
      TYPECASE elem OF &lt;*NOWARN*&gt;
      | M3AST_AS.Actual_elem =&gt;
          M3Error.Report(elem,
               &quot;keyword bindings not allowed in set constructor&quot;);
      | M3AST_AS.RANGE_EXP_elem(rangeExpElem) =&gt;
          TYPECASE rangeExpElem.as_range_exp OF &lt;*NOWARN*&gt;
          | M3AST_AS.Range(range) =&gt;
              IF CheckClass(range.as_exp1) AND CheckClass(range.as_exp2) THEN
                AddConstructorElement(cons, range);
              END;
          | M3AST_AS.Range_EXP(rangeExp) =&gt;
              CheckClassAndAddConstructorElement(cons, rangeExp);
          END;
      END;
    END;
    IF cons.as_propagate # NIL THEN
      M3Error.Report(cons, &quot;propagation not allowed in set constructor&quot;);
    END; (* if *)
  END SetBuild;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A>(constructor: M3AST_AS.Constructor) RAISES {}=
  BEGIN
    TYPECASE M3CTypesMisc.CheckedUnpack(constructor.sm_exp_type_spec) OF
    | NULL =&gt;
        (* ignore it *)
    | M3AST_AS.Array_type =&gt;
        ArrayBuild(constructor);
    | M3AST_AS.Record_type(recordType) =&gt;
        RecordBuild(constructor, recordType);
    | M3AST_AS.Set_type =&gt;
        SetBuild(constructor);
    ELSE
      M3Error.Report(constructor, &quot;bad type for constructor&quot;);
    END;
  END Set;

&lt;*INLINE*&gt; PROCEDURE <A NAME="ExpCheck"><procedure>ExpCheck</procedure></A>(
    type: M3AST_SM.TYPE_SPEC_UNSET;
    exp: M3AST_AS.EXP;
    safe: BOOLEAN)
    RAISES {}=
  BEGIN
    IF exp # NIL AND NOT M3CTypeChkUtil.EXPAssignable(type, exp, safe) THEN
      M3Error.Report(exp,
          &quot;expression in constructor not assignable to element type&quot;);
    END; (* if *)
  END ExpCheck;

PROCEDURE <A NAME="ElementCheck"><procedure>ElementCheck</procedure></A>(
    type: M3AST_SM.TYPE_SPEC_UNSET;
    rangeExp: M3AST_AS.RANGE_EXP;
    safe: BOOLEAN)
    RAISES {}=
  BEGIN
    TYPECASE rangeExp OF &lt;*NOWARN*&gt;
    | NULL =&gt;
    | M3AST_AS.Range_EXP(rExp) =&gt;
        ExpCheck(type, rExp.as_exp, safe);
    | M3AST_AS.Range(range) =&gt;
        ExpCheck(type, range.as_exp1, safe);
        ExpCheck(type, range.as_exp2, safe);
    END;
  END ElementCheck;

PROCEDURE <A NAME="NumberCheck"><procedure>NumberCheck</procedure></A>(
    cons: M3AST_AS.Constructor;
    arrayType: M3AST_AS.Array_type;
    count: INTEGER)
    RAISES {}=
  VAR
    propagate := cons.as_propagate # NIL;
    indexType: M3AST_SM.TYPE_SPEC_UNSET;
    number: M3AST_SM.Exp_value;
    intNumber: INTEGER;
  BEGIN
    CASE M3CTypesMisc.Index(arrayType, indexType) OF
    | M3CTypesMisc.Ix.Open =&gt;
        IF propagate THEN
          M3Error.Report(cons,
              &quot;propagation not allowed in open array constructor&quot;);
        END; (* if *)
    | M3CTypesMisc.Ix.Ordinal =&gt;
        IF M3CExpValue.Number(indexType, number) =
                M3CBackEnd.NumStatus.Valid AND
            M3CBackEnd.Ord(number, intNumber) = M3CBackEnd.NumStatus.Valid THEN
          IF intNumber &lt; count THEN
            M3Error.Report(cons, &quot;too many elements in array constructor&quot;);
          ELSIF intNumber &gt; count AND NOT propagate THEN
            M3Error.Report(cons, &quot;too few elements in array constructor&quot;);
          END; (* if *)
        END; (* if *)
    ELSE
      (* bad or unset index type; can't do any checking *)
    END; (* case *)
  END NumberCheck;

PROCEDURE <A NAME="RecordCheck"><procedure>RecordCheck</procedure></A>(
    recordType: M3AST_AS.Record_type;
    rangeExps: SeqM3AST_AS_RANGE_EXP.T;
    safe: BOOLEAN)
    RAISES {}=
  VAR
    iterFields := M3ASTNext.NewIterField(recordType.as_fields_s);
    iterRangeExps := SeqM3AST_AS_RANGE_EXP.NewIter(rangeExps);
    fieldId: M3AST_AS.Field_id;
    rangeExp: M3AST_AS.RANGE_EXP;
  BEGIN
    WHILE M3ASTNext.Field(iterFields, fieldId) AND
        SeqM3AST_AS_RANGE_EXP.Next(iterRangeExps, rangeExp) DO
      ElementCheck(fieldId.sm_type_spec, rangeExp, safe);
    END; (* while *)
  END RecordCheck;

PROCEDURE <A NAME="ElementsCheck"><procedure>ElementsCheck</procedure></A>(
    type: M3AST_SM.TYPE_SPEC_UNSET;
    rangeExps: SeqM3AST_AS_RANGE_EXP.T;
    safe: BOOLEAN)
    : INTEGER
    RAISES {}=
  VAR
    iter := SeqM3AST_AS_RANGE_EXP.NewIter(rangeExps);
    rangeExp: M3AST_AS.RANGE_EXP;
    count := 0;
  BEGIN
    WHILE SeqM3AST_AS_RANGE_EXP.Next(iter, rangeExp) DO
      ElementCheck(type, rangeExp, safe);
      INC(count);
    END; (* while *)
    RETURN count;
  END ElementsCheck;

PROCEDURE <A NAME="TypeCheck"><procedure>TypeCheck</procedure></A>(
    constructor: M3AST_AS.Constructor;
    safe: BOOLEAN)
    RAISES {}=
  VAR
    rangeExps := constructor.sm_actual_s;
    elementType: M3AST_SM.TYPE_SPEC_UNSET;
  BEGIN
    TYPECASE M3CTypesMisc.CheckedUnpack(constructor.sm_exp_type_spec) OF
    | NULL =&gt;
    | M3AST_AS.Array_type(arrayType) =&gt;
        M3CTypesMisc.GetTYPE_SPECFromM3TYPE(
          arrayType.sm_norm_type.as_elementtype, elementType);
        NumberCheck(constructor, arrayType,
            ElementsCheck(elementType, rangeExps, safe));
    | M3AST_AS.Record_type(recordType) =&gt;
        RecordCheck(recordType, rangeExps, safe);
    | M3AST_AS.Set_type(setType) =&gt;
        M3CTypesMisc.GetTYPE_SPECFromM3TYPE(setType.as_type, elementType);
        EVAL ElementsCheck(elementType, rangeExps, safe);
    ELSE
     (* nothing to do *)
    END;
  END TypeCheck;

BEGIN
END M3CConsActualS.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
