<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/sem/M3CExpsMisc.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/sem/M3CExpsMisc.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3CExpsMisc.i3">M3CExpsMisc</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../../../text/src/Text.i3">Text</A>;

IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../ast/M3AST_SM.i3">M3AST_SM</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>;

IMPORT <A HREF="../../derived/SeqM3AST_AS_Actual.i3">SeqM3AST_AS_Actual</A>;

IMPORT <A HREF="../toolmisc/M3Error.i3">M3Error</A>, <A HREF="../misc/M3Assert.i3">M3Assert</A>, <A HREF="M3CStdProcs.i3">M3CStdProcs</A>;

PROCEDURE <A NAME="Classify"><procedure>Classify</procedure></A>(exp: M3AST_AS.EXP): Class RAISES {}=
  BEGIN
    TYPECASE exp OF
    | M3AST_AS.Exp_used_id(expUsedId) =&gt;
        TYPECASE expUsedId.vUSED_ID.sm_def OF
        | NULL =&gt;
            (* assume normal *)
        | M3AST_AS.Interface_id, M3AST_AS.Interface_AS_id =&gt;
            RETURN Class.Interface;
        | M3AST_AS.Module_id =&gt;
            M3Assert.Fail(); (* can't happen? *)
        | M3AST_AS.Type_id =&gt;
            RETURN Class.Type;
        | M3AST_AS.Exc_id =&gt;
            RETURN Class.Exception;
        | M3AST_AS.METHOD_OVERRIDE_ID =&gt;
            RETURN Class.Method;
        ELSE
          (* normal *)
        END; (* case *)
    | M3AST_AS.Select(select) =&gt;
          WITH class2 = Classify(select.as_id) DO
            IF class2 = Class.Method AND
                Classify(select.as_exp) = Class.Type THEN
              (* ObjectType.method *)
              RETURN Class.Normal;
            ELSE
              RETURN class2;
            END; (* if *)
          END;
    ELSE
      (* take the default *)
    END; (* case *)
    (* if we get here everything looks normal *)
    RETURN Class.Normal;
  END Classify;

PROCEDURE <A NAME="WrongClass"><procedure>WrongClass</procedure></A>(en: M3Error.ERROR_NODE; class: Class) RAISES {}=
  VAR
    text: Text.T;
  BEGIN
    CASE class OF
    | Class.Normal =&gt;    text := &quot;invalid use of expression&quot;;
    | Class.Type =&gt;      text := &quot;invalid use of type&quot;;
    | Class.Interface =&gt; text := &quot;invalid use of interface&quot;;
    | Class.Method =&gt;    text := &quot;invalid use of method&quot;;
    | Class.Exception =&gt; text := &quot;invalid use of exception&quot;;
    ELSE
      M3Assert.Fail();
    END; (* case *)
    M3Error.Report(en, text);
  END WrongClass;

PROCEDURE <A NAME="Index"><procedure>Index</procedure></A>(
    index: M3AST_AS.Index;
    VAR writable: BOOLEAN)
    : BOOLEAN
    RAISES {}=
  VAR
    array := index.as_array;
  BEGIN
    TYPECASE array.sm_exp_type_spec OF
    | NULL =&gt;
    | M3AST_AS.Array_type =&gt;
        RETURN IsDesignator(array, writable);
    ELSE
    END; (* if *)
    (* could validly be a ref type or could just be an error. In either
     case we go for: *)
    writable := TRUE;
    RETURN TRUE;
  END Index;

PROCEDURE <A NAME="FirstParam"><procedure>FirstParam</procedure></A>(
    params: SeqM3AST_AS_Actual.T;
    VAR writable: BOOLEAN)
    : BOOLEAN
    RAISES {}=
  VAR
    actual: M3AST_AS.Actual;
    seqActual := SeqM3AST_AS_Actual.NewIter(params);
  BEGIN
    IF SeqM3AST_AS_Actual.Next(seqActual, actual) THEN
      TYPECASE actual.as_exp_type OF
      | M3AST_AS.EXP(exp) =&gt;
          RETURN IsDesignator(exp, writable);
      ELSE
      END; (* if *)
    END; (* if *)
    (* we get here if there has been a previous error; the default is
     optimistic: *)
    writable := TRUE;
    RETURN TRUE;
  END FirstParam;

PROCEDURE <A NAME="Selection"><procedure>Selection</procedure></A>(
    b: M3AST_AS.Select;
    VAR writable: BOOLEAN)
    : BOOLEAN
    RAISES {}=
  VAR
    exp1: M3AST_AS.EXP;
  BEGIN
    exp1 := b.as_exp;
    CASE Classify(exp1) OF
    | Class.Normal =&gt;
        TYPECASE exp1.sm_exp_type_spec OF
        | NULL =&gt;
            (* take the default *)
        | M3AST_AS.Record_type =&gt;
            RETURN IsDesignator(exp1, writable);
        | M3AST_AS.Object_type =&gt;
            VAR
              defId := b.as_id.vUSED_ID.sm_def;
            BEGIN
              IF defId # NIL AND
                 ISTYPE(defId, M3AST_AS.METHOD_OVERRIDE_ID) THEN
                RETURN FALSE;
              END;
            END;
        ELSE
          (* could validly be a ref type or it may be an error; in either
             case we take the default *)
        END; (* case *)
    | Class.Interface =&gt;
        RETURN IsDesignator(b.as_id, writable);
    | Class.Type =&gt;
        (* ObjectType.blah, Enumeration.blah *)
        RETURN FALSE;
    ELSE
      (* there has been a cockup; be optimistic and take the default *)
    END; (* case *)
    writable := TRUE;
    RETURN TRUE;
  END Selection;

PROCEDURE <A NAME="IsDesignator"><procedure>IsDesignator</procedure></A>(
    exp: M3AST_AS.EXP;
    VAR writable: BOOLEAN)
    : BOOLEAN
    RAISES {}=
  VAR
    def_id: M3AST_SM.DEF_ID_UNSET;
    pf: M3CStdProcs.T;
  BEGIN
    TYPECASE exp OF
    | M3AST_AS.Exp_used_id(exp_used_id) =&gt;
        def_id := exp_used_id.vUSED_ID.sm_def;
        IF def_id = NIL THEN writable := TRUE; RETURN TRUE END;
        TYPECASE def_id OF
        | M3AST_AS.Var_id,
          M3AST_AS.F_Var_id,
          M3AST_AS.F_Value_id,
          M3AST_AS.Tcase_id,
          M3AST_AS.Handler_id =&gt;
            writable := TRUE;
            RETURN TRUE;
        | M3AST_AS.F_Readonly_id,
          M3AST_AS.For_id =&gt;
            writable := FALSE;
            RETURN TRUE;
        | M3AST_AS.With_id(with_id) =&gt;
            WITH withExp = with_id.vINIT_ID.sm_init_exp DO
              IF withExp = NIL THEN
                writable := TRUE;
                RETURN TRUE;
              ELSE
                IF NOT IsDesignator(withExp, writable) THEN
                  writable := FALSE;
                END;
                RETURN TRUE;
              END;
            END;
        ELSE
          (* no *)
        END; (* case *)

    | M3AST_AS.Select(select) =&gt;
        RETURN Selection(select, writable);

    | M3AST_AS.Deref(*unary*) =&gt;
        writable := TRUE;
        RETURN TRUE;

    | M3AST_AS.Call(call) =&gt;
        IF M3CStdProcs.IsStandardCall(exp, pf) AND
            ((pf = M3CStdProcs.T.Subarray) OR (pf = M3CStdProcs.T.Loophole)) THEN
          RETURN FirstParam(call.as_param_s, writable);
        END; (* if *)
    | M3AST_AS.Index(index) =&gt;
        RETURN Index(index, writable);
    ELSE
      (* no way *)
    END; (* case *)
    (* if we get here then it doesn't look at all like a designator *)
    RETURN FALSE;
  END IsDesignator;

PROCEDURE <A NAME="IsId"><procedure>IsId</procedure></A>(
    exp: M3AST_AS.EXP;
    VAR defId: M3AST_AS.DEF_ID)
    : BOOLEAN
    RAISES {}=
  VAR
    id: M3AST_AS.Exp_used_id;
  BEGIN
    TYPECASE exp OF
    | M3AST_AS.Exp_used_id(expUsedId) =&gt;
        id := expUsedId;
    | M3AST_AS.Select(select) =&gt;
        IF Classify(select.as_exp) = Class.Interface THEN
          id := select.as_id;
        ELSE
          RETURN FALSE;
        END;
    ELSE
      RETURN FALSE
    END;
    (* If we get this far 'id' has been set up *)
    IF id.vUSED_ID.sm_def # NIL THEN
      defId := id.vUSED_ID.sm_def;
      RETURN TRUE;
    ELSE
      RETURN FALSE;
    END;
  END IsId;

BEGIN
END M3CExpsMisc.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
