<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/sem/M3CInitExp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/sem/M3CInitExp.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3CInitExp.i3">M3CInitExp</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../ast/M3AST.i3">M3AST</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>;

IMPORT <A HREF="../../derived/SeqM3AST_AS_Var_id.i3">SeqM3AST_AS_Var_id</A>, <A HREF="../../derived/SeqM3AST_AS_FORMAL_ID.i3">SeqM3AST_AS_FORMAL_ID</A>, <A HREF="../../derived/SeqM3AST_AS_Field_id.i3">SeqM3AST_AS_Field_id</A>;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A>(an: M3AST.NODE) RAISES {}=
  VAR
    varId: M3AST_AS.Var_id;
    formalId: M3AST_AS.FORMAL_ID;
    fieldId: M3AST_AS.Field_id;
    expVoid: M3AST_AS.EXP_NULL;
    iterVarIds: SeqM3AST_AS_Var_id.Iter;
    iterFormalIds: SeqM3AST_AS_FORMAL_ID.Iter;
    iterFieldIds: SeqM3AST_AS_Field_id.Iter;
  BEGIN
    TYPECASE an OF

    | M3AST_AS.Const_decl(constDecl) =&gt;
        constDecl.as_id.vINIT_ID.sm_init_exp := constDecl.as_exp;

    | M3AST_AS.Var_decl(varDecl) =&gt;
        expVoid := varDecl.as_default;
        iterVarIds := SeqM3AST_AS_Var_id.NewIter(varDecl.as_id_s);
        WHILE SeqM3AST_AS_Var_id.Next(iterVarIds, varId) DO
          varId.vINIT_ID.sm_init_exp := expVoid;
        END; (* while *)

    | M3AST_AS.Formal_param(formalParam) =&gt; (* very like a Var_decl *)
        expVoid := formalParam.as_default;
        iterFormalIds := SeqM3AST_AS_FORMAL_ID.NewIter(formalParam.as_id_s);
        WHILE SeqM3AST_AS_FORMAL_ID.Next(iterFormalIds, formalId) DO
          TYPECASE formalId OF
          | M3AST_AS.F_Value_id(valueId) =&gt;
              valueId.vINIT_ID.sm_init_exp := expVoid;
          | M3AST_AS.F_Readonly_id(readonlyId) =&gt;
              readonlyId.vINIT_ID.sm_init_exp := expVoid;
          ELSE
          END;
        END; (* while *)

    | M3AST_AS.Fields(fields) =&gt;
        expVoid := fields.as_default;
        iterFieldIds := SeqM3AST_AS_Field_id.NewIter(fields.as_id_s);
        WHILE SeqM3AST_AS_Field_id.Next(iterFieldIds, fieldId) DO
          fieldId.vINIT_ID.sm_init_exp := expVoid;
        END; (* while *)

    | M3AST_AS.Binding(binding) =&gt;
        binding.as_id.vINIT_ID.sm_init_exp := binding.as_exp;

    | M3AST_AS.For_st(for) =&gt;
        for.as_id.vINIT_ID.sm_init_exp := for.as_from;

    | M3AST_AS.METHOD_OVERRIDE(m_o) =&gt;
        m_o.as_id.vINIT_ID.sm_init_exp := m_o.as_default;
    ELSE
    END; (* case *)
  END Set;

BEGIN
END M3CInitExp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
