<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/sem/M3CNEWActualS.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/sem/M3CNEWActualS.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3CNEWActualS.i3">M3CNEWActualS</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../../../text/src/Text.i3">Text</A>;

IMPORT <A HREF="../ast/M3AST_LX.i3">M3AST_LX</A>,<A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../ast/M3AST_SM.i3">M3AST_SM</A>, <A HREF="M3ASTNext.i3">M3ASTNext</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>;

IMPORT <A HREF="../../derived/SeqM3AST_AS_EXP.i3">SeqM3AST_AS_EXP</A>;

IMPORT <A HREF="../toolmisc/M3Error.i3">M3Error</A>, <A HREF="M3CTypesMisc.i3">M3CTypesMisc</A>, <A HREF="M3CExpsMisc.i3">M3CExpsMisc</A>, <A HREF="M3CTypeChkUtil.i3">M3CTypeChkUtil</A>, <A HREF="M3CActualUtil.i3">M3CActualUtil</A>,
    <A HREF="M3COrdinal.i3">M3COrdinal</A>;

PROCEDURE <A NAME="NewOpenArray"><procedure>NewOpenArray</procedure></A>(
    call: M3AST_AS.Call;
    actuals: M3CActualUtil.List;
    array: M3AST_AS.Array_type)
    RAISES {}=
  VAR
    norm: M3AST_AS.Array_type;
    exp: M3AST_AS.EXP;
    base, elementType: M3AST_SM.TYPE_SPEC_UNSET;
  BEGIN
    norm := array.sm_norm_type;
    FOR pos := 1 TO M3CActualUtil.PositionalActuals(actuals) - 1 DO
      IF norm = NIL THEN
        M3CActualUtil.TooManyArguments(call);
        RETURN;
      ELSE
        exp := M3CActualUtil.ActualAt(actuals, pos, NIL);
        IF exp # NIL THEN
          IF ISTYPE(exp, M3AST_SM.TypeActual) THEN
            M3CExpsMisc.WrongClass(M3CActualUtil.OriginalActual(call, pos),
                M3CExpsMisc.Class.Type);
          ELSE
            SeqM3AST_AS_EXP.AddRear(call.sm_actual_s, exp);
            IF M3COrdinal.Is(exp.sm_exp_type_spec, base) AND
                (base = NIL OR NOT ISTYPE(base, M3AST_AS.Enumeration_type)) THEN
              (* i.e. is INTEGER or unset meaning ok or previous error *)
            ELSE
              M3CActualUtil.ArgumentIsWrongType(exp);
            END;
          END;
        ELSE
          (* actual was wrong class; error message already given *)
        END;
        M3CTypesMisc.GetTYPE_SPECFromM3TYPE(
            norm.as_elementtype, elementType);
        IF M3CTypesMisc.IsOpenArray(elementType) THEN
          norm := NARROW(elementType, M3AST_AS.Array_type).sm_norm_type;
        ELSE
          norm := NIL;
        END; (* if *)
      END; (* if 'norm = NIL' *)
    END; (* for *)
    IF norm # NIL THEN M3CActualUtil.TooFewArguments(call) END;
  END NewOpenArray;

TYPE
  FieldAndMethodIterRec = RECORD
    record: M3AST_AS.Record_type; (* one of 'record' and 'object' is NIL *)
    object: M3AST_AS.Object_type;
    iterR: M3ASTNext.IterField;
    iterO: M3ASTNext.IterFieldOrMethod;
    field_id: M3AST_AS.Field_id;
  END; (* record *)

PROCEDURE <A NAME="InitFieldAndMethodIter"><procedure>InitFieldAndMethodIter</procedure></A>(
    o: M3AST_AS.Object_type;
    r: M3AST_AS.Record_type;
    VAR i: FieldAndMethodIterRec)
    RAISES {}=
  BEGIN
    i.object := o;
    i.record := r;
    IF r # NIL THEN
      i.iterR := M3ASTNext.NewIterField(r.as_fields_s);
    ELSE
      i.iterO := M3ASTNext.NewIterFieldOrMethod(o);
    END;
    i.field_id := NIL;
  END InitFieldAndMethodIter;

PROCEDURE <A NAME="CheckFieldActual"><procedure>CheckFieldActual</procedure></A>(
    i: FieldAndMethodIterRec;
    exp: M3AST_AS.EXP;
    safe: BOOLEAN)
    RAISES {}=
  BEGIN
    IF exp # NIL THEN
        IF NOT M3CTypeChkUtil.EXPAssignable(
            i.field_id.sm_type_spec, exp, safe) THEN
          M3Error.Report(exp,
              &quot;argument to NEW not assignable to record or object field&quot;);
        END; (* if *)
    ELSE
      (* was illegal use of type; error message already given *)
    END; (* if *)
  END CheckFieldActual;

PROCEDURE <A NAME="NextField"><procedure>NextField</procedure></A>(
    VAR i: FieldAndMethodIterRec)
    : BOOLEAN
    RAISES {}=
  VAR
    field_id: M3AST_AS.Field_id;
  BEGIN
    IF i.object # NIL  THEN
      VAR
        method: M3AST_AS.Method;
        symrep: M3AST_LX.Symbol_rep;
      BEGIN
        LOOP
          IF M3ASTNext.FieldOrMethod(i.iterO, field_id, method, symrep) THEN
            IF method = NIL THEN
              i.field_id := field_id;
              RETURN TRUE;
            END;
          ELSE
            RETURN FALSE;
          END;
        END;
      END;
    ELSE
      IF M3ASTNext.Field(i.iterR, field_id) THEN
        i.field_id := field_id;
        RETURN TRUE;
      ELSE
        RETURN FALSE;
      END;
    END;
  END NextField;

PROCEDURE <A NAME="NewObjectOrRecord"><procedure>NewObjectOrRecord</procedure></A>(
    call: M3AST_AS.Call;
    actuals: M3CActualUtil.List;
    object: M3AST_AS.Object_type;
    record: M3AST_AS.Record_type;
    safe: BOOLEAN)
    RAISES {}=
  VAR
    iter: FieldAndMethodIterRec;
    exp: M3AST_AS.EXP;
  BEGIN
    InitFieldAndMethodIter(object, record, iter);

    IF M3CActualUtil.PositionalActuals(actuals) &gt; 1 THEN
      M3Error.Report(call,
          &quot;positional binding not allowed for field or method&quot;);
    END;

    (* See if there is a keyword actual for each field. If there is,
     use its expression.  If not, use the default. *)
    WHILE NextField(iter) DO
      IF M3CActualUtil.ActualByKeyword(actuals, iter.field_id, exp) THEN
        CheckFieldActual(iter, exp, safe);
      END; (* if *)
    END; (* while *)

  END NewObjectOrRecord;

PROCEDURE <A NAME="NewRef"><procedure>NewRef</procedure></A>(
    call: M3AST_AS.Call;
    actuals: M3CActualUtil.List;
    ref: M3AST_AS.Ref_type;
    safe: BOOLEAN)
    RAISES {}=
  VAR
    referent: M3AST_SM.TYPE_SPEC_UNSET;
  BEGIN
    M3CTypesMisc.GetTYPE_SPECFromM3TYPE(ref.as_type, referent);
    IF referent # NIL THEN
      IF NOT M3CTypesMisc.IsEmpty(referent) THEN
        IF M3CTypesMisc.IsOpenArray(referent) THEN
          NewOpenArray(call, actuals, referent);
        ELSIF ISTYPE(referent, M3AST_AS.Record_type) THEN
          NewObjectOrRecord(call, actuals, NIL, referent, safe);
        ELSE
          IF M3CActualUtil.PositionalActuals(actuals) &gt; 1 THEN
            M3CActualUtil.TooManyArguments(call);
          END; (* if *)
        END; (* if *)
      ELSE
        M3Error.Report(call, &quot;NEW of empty type&quot;);
      END; (* if *)
    ELSE
      (* referent is unset - forget it *)
    END; (* if *)
  END NewRef;

PROCEDURE <A NAME="SetAndTypeCheck"><procedure>SetAndTypeCheck</procedure></A>(call: M3AST_AS.Call; safe: BOOLEAN) RAISES {}=
  VAR
    actuals := M3CActualUtil.ActualList(call, TRUE);
    exp: M3AST_AS.EXP;
    ts: M3AST_SM.TYPE_SPEC_UNSET := NIL;
  BEGIN
    IF M3CActualUtil.PositionalActuals(actuals) &gt; 0 THEN
      exp := M3CActualUtil.ActualAt(actuals, 0, NIL);
      IF exp # NIL THEN
        VAR
          error: Text.T := NIL;
        BEGIN
          IF ISTYPE(exp, M3AST_SM.TypeActual) THEN
            SeqM3AST_AS_EXP.AddRear(call.sm_actual_s, exp);
            ts := M3CTypesMisc.Reveal(exp.sm_exp_type_spec);
            TYPECASE ts OF
            | NULL =&gt;
            | M3AST_AS.Object_type(objectType) =&gt;
                NewObjectOrRecord(call, actuals, objectType, NIL, safe);
            | M3AST_AS.Ref_type(refType) =&gt;
                NewRef(call, actuals, refType, safe);
            | M3AST_AS.RefAny_type =&gt;
                error := &quot;cannot NEW an opaque type known only as &lt;: REFANY&quot;;
            | M3AST_AS.Root_type =&gt;
               IF M3CActualUtil.TotalActuals(actuals) &gt; 1 THEN
                 M3CActualUtil.TooManyArguments(call);
               END;
            ELSE
              error := &quot;first argument to NEW must be reference type&quot;;
            END; (* if *)
          ELSE
            error := &quot;first argument to NEW must be a reference type&quot;;
          END;
          IF error # NIL THEN
            M3Error.Report(
                M3CActualUtil.OriginalActual(call, 0), error);
          END;
        END;
      ELSE
        (* argument was not a normal expression, error message already given *)
      END;
    ELSE
      IF M3CActualUtil.TotalActuals(actuals) = 0 THEN
        M3CActualUtil.TooFewArguments(call);
      ELSE
        M3Error.Report(call, &quot;NEW must have at least one positional argument&quot;);
      END; (* if *)
    END;
    IF ts # NIL THEN M3CActualUtil.FindUnmatched(actuals) END;
  END SetAndTypeCheck;

BEGIN
END M3CNEWActualS.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
