<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/sem/M3CSearch.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/sem/M3CSearch.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3CSearch.i3">M3CSearch</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../ast/M3AST_LX.i3">M3AST_LX</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="../syn/M3CId.i3">M3CId</A>; (* to reveal an M3AST_LX.Symrep *)

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>, <A HREF="../ast/M3AST_TM_F.i3">M3AST_TM_F</A>;

IMPORT <A HREF="../../derived/SeqM3AST_AS_Enum_id.i3">SeqM3AST_AS_Enum_id</A>;
IMPORT <A HREF="../toolmisc/M3Error.i3">M3Error</A>;
IMPORT <A HREF="M3ASTNext.i3">M3ASTNext</A>;

PROCEDURE <A NAME="Export"><procedure>Export</procedure></A>(
    int: M3AST_AS.Interface;
    id: M3AST_AS.USED_ID)
    RAISES {}=
  VAR
    symrep := id.lx_symrep;
    hashId: REFANY;
  BEGIN
    IF symrep = NIL THEN RETURN END;
    IF int.tmp_def_id_table.get(symrep.atom, hashId) THEN
      id.sm_def := hashId;
    ELSE
      (* if we get here we failed *)
      M3Error.ReportWithId(id, &quot;\'%s\' not found in interface \'%s\'&quot;,
          symrep, NARROW(int.as_id, M3AST_AS.Interface_id).lx_symrep);
    END;
  END Export;

PROCEDURE <A NAME="Member"><procedure>Member</procedure></A>(
    enum: M3AST_AS.Enumeration_type;
    id: M3AST_AS.USED_ID)
    RAISES {}=
  VAR
    symrep := id.lx_symrep;
    iterEnums: SeqM3AST_AS_Enum_id.Iter;
    member: M3AST_AS.Enum_id;
  BEGIN
    IF symrep = NIL THEN RETURN END;
    iterEnums := SeqM3AST_AS_Enum_id.NewIter(enum.as_id_s);
    WHILE SeqM3AST_AS_Enum_id.Next(iterEnums, member) DO
      IF member.lx_symrep = symrep THEN
        id.sm_def := member;
        RETURN;
      ELSE
        (* continue search *)
      END; (* if *)
    END; (* while *)
    M3Error.ReportWithId(id,
        &quot;Enumeration member \'%s\' not found&quot;, symrep);
  END Member;

PROCEDURE <A NAME="Field"><procedure>Field</procedure></A>(
    record: M3AST_AS.Record_type;
    id: M3AST_AS.USED_ID)
    RAISES {}=
  VAR
    symrep := id.lx_symrep;
    iter: M3ASTNext.IterField;
    fieldId: M3AST_AS.Field_id;
  BEGIN
    IF symrep = NIL THEN RETURN END;
    iter := M3ASTNext.NewIterField(record.as_fields_s);
    WHILE M3ASTNext.Field(iter, fieldId) DO
      IF fieldId.lx_symrep = symrep THEN
        id.sm_def := fieldId;
        RETURN;
      ELSE
        (* continue search *)
      END; (* if *)
    END; (* while *)
    M3Error.ReportWithId(id, &quot;Record field \'%s\' not found&quot;, symrep);
  END Field;

PROCEDURE <A NAME="FieldOrMethod"><procedure>FieldOrMethod</procedure></A>(
    object: M3AST_AS.Object_type;
    methodsOnly: BOOLEAN;
    id: M3AST_AS.USED_ID)
    RAISES {}=
  VAR
    symrep := id.lx_symrep;
    iter: M3ASTNext.IterFieldOrMethod;
    fieldId: M3AST_AS.Field_id;
    meth: M3AST_AS.Method;
    fieldOrMethodSymrep: M3AST_LX.Symbol_rep;
  BEGIN
    IF symrep = NIL THEN RETURN END;
    iter := M3ASTNext.NewIterFieldOrMethod(object);
    WHILE M3ASTNext.FieldOrMethod(iter, fieldId, meth, fieldOrMethodSymrep) DO
      IF symrep = fieldOrMethodSymrep THEN
        IF meth = NIL THEN
          IF methodsOnly THEN
            M3Error.ReportWithId(id,
                &quot;\'%s\' is a field not a method&quot;, symrep);
          ELSE
            id.sm_def := fieldId;
          END;
        ELSE
          id.sm_def := meth.as_id;
        END;
        RETURN
      END;
    END; (* while *)
    M3Error.ReportWithId(id,
        &quot;object field or method \'%s\' not found&quot;, symrep);
  END FieldOrMethod;

PROCEDURE <A NAME="Formal"><procedure>Formal</procedure></A>(
    proc: M3AST_AS.Procedure_type;
    id: M3AST_AS.USED_ID)
    RAISES {}=
  VAR
    symrep := id.lx_symrep;
    iter: M3ASTNext.IterFormal;
    formal: M3AST_AS.Formal_param;
    formalId: M3AST_AS.FORMAL_ID;
  BEGIN
    IF symrep = NIL THEN RETURN END;
    iter := M3ASTNext.NewIterFormal(proc.as_formal_param_s);
    WHILE M3ASTNext.Formal(iter, formal, formalId) DO
      IF formalId.lx_symrep = symrep THEN
        id.sm_def := formalId;
        RETURN;
      ELSE
        (* continue search *)
      END; (* if *)
    END; (* while *)
    M3Error.ReportWithId(id,
        &quot;Formal parameter \'%s\' not found&quot;, symrep);
  END Formal;

BEGIN
END M3CSearch.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
