<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/sem/M3CStdProcs.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/sem/M3CStdProcs.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3CStdProcs.i3">M3CStdProcs</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../libm3/derived/TextRefTbl.i3">TextRefTbl</A>;

IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>, <A HREF="../ast/M3AST_TM_F.i3">M3AST_TM_F</A>;

IMPORT <A HREF="../toolmisc/M3Context.i3">M3Context</A>, <A HREF="../syn/M3CId.i3">M3CId</A>, <A HREF="../misc/M3Assert.i3">M3Assert</A>;

VAR
  table_g: TextRefTbl.T;

PROCEDURE <A NAME="IsStandardUnit"><procedure>IsStandardUnit</procedure></A>(unitId: M3AST_AS.UNIT_ID): BOOLEAN RAISES {}=
  BEGIN
    RETURN NARROW(unitId.sm_spec, M3AST_AS.UNIT).sm_comp_unit =
        M3Context.Standard();
  END IsStandardUnit;

PROCEDURE <A NAME="IsStandardCall"><procedure>IsStandardCall</procedure></A>(
    call: M3AST_AS.Call;
    VAR pf: T)
    : BOOLEAN
    RAISES {}=
  BEGIN
    TYPECASE call.as_callexp OF
    | M3AST_AS.Exp_used_id(expUsedId) =&gt;
        VAR
          defId := expUsedId.vUSED_ID.sm_def;
          hashId: REFANY;
        BEGIN
          IF defId # NIL AND ISTYPE(defId, M3AST_AS.Proc_id) AND
              IsStandardUnit(defId.tmp_unit_id) THEN
            IF table_g.get(M3CId.ToText(defId.lx_symrep), hashId) THEN
              pf := NARROW(hashId, REF T)^;
              RETURN TRUE;
            ELSE
              M3Assert.Fail();
              &lt;*ASSERT FALSE*&gt;
            END; (* if *)
          ELSE
            RETURN FALSE;
          END; (* if *)
        END;
    ELSE
      RETURN FALSE;
    END; (* if *)
  END IsStandardCall;

PROCEDURE <A NAME="IsStandard"><procedure>IsStandard</procedure></A>(id: M3AST_AS.Proc_id; VAR pf: T): BOOLEAN RAISES {}=
  VAR
    hashId: REFANY;
  BEGIN
    IF IsStandardUnit(id.tmp_unit_id) THEN
      IF table_g.get(M3CId.ToText(id.lx_symrep), hashId) THEN
        pf := NARROW(hashId, REF T)^;
        RETURN TRUE;
      ELSE
        M3Assert.Fail();
        &lt;*ASSERT FALSE*&gt;
      END; (* if *)
    ELSE
      RETURN FALSE;
    END; (* if *)
  END IsStandard;

PROCEDURE <A NAME="Enter"><procedure>Enter</procedure></A>(s: Text.T; pf: T) RAISES {}=
  VAR
    new := NEW(REF T);
  BEGIN
    new^ := pf;
    EVAL table_g.put(s, new);
  END Enter;

PROCEDURE <A NAME="Initialise"><procedure>Initialise</procedure></A>() RAISES {}=
  BEGIN
    table_g := NEW(TextRefTbl.Default).init(32);
    Enter(&quot;NEW&quot;, T.New);
    Enter(&quot;INC&quot;, T.Inc);
    Enter(&quot;DEC&quot;, T.Dec);
    Enter(&quot;DISPOSE&quot;, T.Dispose);
    Enter(&quot;ABS&quot;, T.Abs);
    Enter(&quot;FLOAT&quot;, T.Float);
    Enter(&quot;FLOOR&quot;, T.Floor);
    Enter(&quot;CEILING&quot;, T.Ceiling);
    Enter(&quot;ROUND&quot;, T.Round);
    Enter(&quot;TRUNC&quot;, T.Trunc);
    Enter(&quot;MAX&quot;, T.Max);
    Enter(&quot;MIN&quot;, T.Min);
    Enter(&quot;ORD&quot;, T.Ord);
    Enter(&quot;VAL&quot;, T.Val);
    Enter(&quot;NUMBER&quot;, T.Number);
    Enter(&quot;FIRST&quot;, T.First);
    Enter(&quot;LAST&quot;, T.Last);
    Enter(&quot;TYPECODE&quot;, T.TypeCode);
    Enter(&quot;NARROW&quot;, T.Narrow);
    Enter(&quot;ISTYPE&quot;, T.IsType);
    Enter(&quot;BITSIZE&quot;, T.BitSize);
    Enter(&quot;BYTESIZE&quot;, T.ByteSize);
    Enter(&quot;ADRSIZE&quot;, T.AdrSize);
    Enter(&quot;LOOPHOLE&quot;, T.Loophole);
    Enter(&quot;ADR&quot;, T.Adr);
    Enter(&quot;SUBARRAY&quot;, T.Subarray);
  END Initialise;

BEGIN
  Initialise();
END M3CStdProcs.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
