<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/sem/M3CStdTypes.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/sem/M3CStdTypes.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3CStdTypes.i3">M3CStdTypes</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P> return (shared) instances of standard predefined TYPE_SPECs. 

<P><PRE>IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../ast/M3AST_SM.i3">M3AST_SM</A>;

IMPORT <A HREF="../ast/M3AST_LX_F.i3">M3AST_LX_F</A>, <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>;

IMPORT <A HREF="../syn/M3CSrcPos.i3">M3CSrcPos</A>;

VAR
  integer: M3AST_AS.Integer_type;
  real: M3AST_AS.Real_type;
  longReal: M3AST_AS.LongReal_type;
  extended: M3AST_AS.Extended_type;
  char: M3AST_AS.TYPE_SPEC;
  text: M3AST_AS.TYPE_SPEC;
  null: M3AST_AS.Null_type;
  boolean: M3AST_AS.TYPE_SPEC;
  cardinal: M3AST_AS.TYPE_SPEC;
  refany: M3AST_AS.RefAny_type;
  address: M3AST_AS.Address_type;
  root: M3AST_AS.Root_type;
  untracedRoot: M3AST_AS.Root_type;
  mutex: M3AST_AS.TYPE_SPEC;
  any: M3AST_SM.Any_type;
  type: M3AST_SM.Type_type;
  void: M3AST_SM.Void_type;

  charpos: CARDINAL;   (* each node gets a unique lx_srcpos *)

PROCEDURE <A NAME="Integer"><procedure>Integer</procedure></A>(): M3AST_AS.Integer_type RAISES {}=
  BEGIN
    RETURN integer;
  END Integer;

PROCEDURE <A NAME="Real"><procedure>Real</procedure></A>(): M3AST_AS.Real_type RAISES {}=
  BEGIN
    RETURN real;
  END Real;

PROCEDURE <A NAME="LongReal"><procedure>LongReal</procedure></A>(): M3AST_AS.LongReal_type RAISES {}=
  BEGIN
    RETURN longReal;
  END LongReal;

PROCEDURE <A NAME="Extended"><procedure>Extended</procedure></A>(): M3AST_AS.Extended_type RAISES {}=
  BEGIN
    RETURN extended;
  END Extended;

PROCEDURE <A NAME="Char"><procedure>Char</procedure></A>(): M3AST_AS.TYPE_SPEC RAISES {}=
  BEGIN
    RETURN char;
  END Char;

PROCEDURE <A NAME="Text"><procedure>Text</procedure></A>(): M3AST_AS.TYPE_SPEC RAISES {}=
  BEGIN
    RETURN text;
  END Text;

PROCEDURE <A NAME="Boolean"><procedure>Boolean</procedure></A>(): M3AST_AS.TYPE_SPEC RAISES {}=
  BEGIN
    RETURN boolean;
  END Boolean;

PROCEDURE <A NAME="Cardinal"><procedure>Cardinal</procedure></A>(): M3AST_AS.TYPE_SPEC RAISES {}=
  BEGIN
    RETURN cardinal;
  END Cardinal;

PROCEDURE <A NAME="RefAny"><procedure>RefAny</procedure></A>(): M3AST_AS.RefAny_type RAISES {}=
  BEGIN
    RETURN refany;
  END RefAny;

PROCEDURE <A NAME="Address"><procedure>Address</procedure></A>(): M3AST_AS.Address_type RAISES {}=
  BEGIN
    RETURN address;
  END Address;

PROCEDURE <A NAME="Root"><procedure>Root</procedure></A>(): M3AST_AS.Root_type RAISES {}=
  BEGIN
    RETURN root;
  END Root;

PROCEDURE <A NAME="Untraced_Root"><procedure>Untraced_Root</procedure></A>(): M3AST_AS.Root_type RAISES {}=
  BEGIN
    RETURN untracedRoot;
  END Untraced_Root;

PROCEDURE <A NAME="Mutex"><procedure>Mutex</procedure></A>(): M3AST_AS.TYPE_SPEC RAISES {}=
  BEGIN
    RETURN mutex;
  END Mutex;

PROCEDURE <A NAME="Null"><procedure>Null</procedure></A>(): M3AST_AS.Null_type RAISES {}=
  BEGIN
    RETURN null;
  END Null;

PROCEDURE <A NAME="Any"><procedure>Any</procedure></A>(): M3AST_SM.Any_type RAISES {}=
  BEGIN
    RETURN any;
  END Any;

PROCEDURE <A NAME="Type"><procedure>Type</procedure></A>(): M3AST_SM.Type_type RAISES {}=
  BEGIN
    RETURN type;
  END Type;

PROCEDURE <A NAME="Void"><procedure>Void</procedure></A>(): M3AST_SM.Void_type RAISES {}=
  BEGIN
    RETURN void;
  END Void;

PROCEDURE <A NAME="RegisterChar"><procedure>RegisterChar</procedure></A>(ts: M3AST_AS.TYPE_SPEC) RAISES {}=
  BEGIN
    char := ts;
  END RegisterChar;

PROCEDURE <A NAME="RegisterText"><procedure>RegisterText</procedure></A>(ts: M3AST_AS.TYPE_SPEC) RAISES {}=
  BEGIN
    text := ts;
  END RegisterText;

PROCEDURE <A NAME="RegisterBoolean"><procedure>RegisterBoolean</procedure></A>(ts: M3AST_AS.TYPE_SPEC) RAISES {}=
  BEGIN
    boolean := ts;
  END RegisterBoolean;

PROCEDURE <A NAME="RegisterCardinal"><procedure>RegisterCardinal</procedure></A>(ts: M3AST_AS.TYPE_SPEC) RAISES {}=
  BEGIN
    cardinal := ts;
  END RegisterCardinal;

PROCEDURE <A NAME="RegisterMutex"><procedure>RegisterMutex</procedure></A>(ts: M3AST_AS.TYPE_SPEC) RAISES {}=
  BEGIN
    mutex := ts;
  END RegisterMutex;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(n: M3AST_AS.SRC_NODE) RAISES {}=
  BEGIN
    INC(charpos);
    n.lx_srcpos := M3CSrcPos.Pack(0, charpos);
  END Init;

BEGIN
  charpos := 0;
  integer := NEW(M3AST_AS.Integer_type).init(); Init(integer);
  real := NEW(M3AST_AS.Real_type).init(); Init(real);
  longReal := NEW(M3AST_AS.LongReal_type).init(); Init(longReal);
  extended := NEW(M3AST_AS.Extended_type).init(); Init(extended);
  null := NEW(M3AST_AS.Null_type).init(); Init(null);
  any := NEW(M3AST_SM.Any_type).init(); Init(any);
  type := NEW(M3AST_SM.Type_type).init(); Init(type);
  void := NEW(M3AST_SM.Void_type).init(); Init(void);
  refany := NEW(M3AST_AS.RefAny_type).init(); Init(refany);
  address := NEW(M3AST_AS.Address_type).init(); Init(address);
  root := NEW(M3AST_AS.Root_type).init(); Init(root);
  untracedRoot := NEW(M3AST_AS.Root_type).init();
  untracedRoot.as_trace_mode := NEW(M3AST_AS.Untraced).init();
  Init(untracedRoot);
END M3CStdTypes.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
