<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/sem/M3CSundries.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/sem/M3CSundries.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3CSundries.i3">M3CSundries</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P>
<P><PRE>IMPORT <A HREF="../../../text/src/Text.i3">Text</A>;

IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>;

IMPORT <A HREF="../gast/ASTWalk.i3">ASTWalk</A>;

IMPORT <A HREF="../toolmisc/M3Error.i3">M3Error</A>, <A HREF="M3CDuplicate.i3">M3CDuplicate</A>, <A HREF="M3CNameClash.i3">M3CNameClash</A>;

PROCEDURE <A NAME="Call"><procedure>Call</procedure></A>(call: M3AST_AS.Call; isStatement: BOOLEAN) RAISES {}=
  VAR
    noResult: BOOLEAN;
  BEGIN
    TYPECASE call.as_callexp.sm_exp_type_spec OF
    | NULL =&gt;
    | M3AST_AS.Procedure_type(procType) =&gt;
        noResult := procType.as_result_type = NIL;
        IF noResult # isStatement THEN
          VAR
            e: Text.T;
          BEGIN
            IF isStatement THEN
              e := &quot;call of function procedure cannot be used as a statement&quot;;
            ELSE
              e := &quot;call of proper procedure cannot be used in an expression&quot;;
            END; (* if *)
            M3Error.Report(call, e);
          END;
        END; (* if *)
    ELSE
    END; (* typecase *)
  END Call;

PROCEDURE <A NAME="Procedure"><procedure>Procedure</procedure></A>(p: M3AST_AS.Proc_decl; isModule: BOOLEAN) RAISES {}=
  VAR
    hasBody := p.as_body # NIL;
  BEGIN
    IF hasBody # isModule THEN
      VAR
        e: Text.T;
      BEGIN
        IF hasBody THEN
          e := &quot;procedure in interface cannot have body&quot;;
        ELSE
          e := &quot;procedure in module must have body&quot;;
        END; (* if *)
        M3Error.Report(p, e);
      END;
    END; (* if *)
  END Procedure;

REVEAL
  <A NAME="Handle">Handle</A> = BRANDED OBJECT
    inModule, isProperCall: BOOLEAN;
    loopCount, procNesting: INTEGER := 0;
  END;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A>(h: Handle; any: AST.NODE; v: ASTWalk.VisitMode) RAISES {}=
  BEGIN
    IF v = ASTWalk.VisitMode.Entry THEN
      TYPECASE any OF
      | M3AST_AS.Loop_st, M3AST_AS.While_st,
        M3AST_AS.For_st, M3AST_AS.Repeat_st =&gt;
          INC(h.loopCount);
      | M3AST_AS.Call_st =&gt;
          h.isProperCall := TRUE;
      | M3AST_AS.Call(call) =&gt;
          Call(call, h.isProperCall);
          h.isProperCall := FALSE;
      | M3AST_AS.Proc_decl(proc_decl) =&gt;
          INC(h.procNesting);
          Procedure(proc_decl, h.inModule);
      | M3AST_AS.Exit_st =&gt;
          IF h.loopCount = 0 THEN
            M3Error.Report(any, &quot;EXIT must be inside loop&quot;);
          END;
      | M3AST_AS.Case_st(case_st) =&gt;
          M3CDuplicate.CaseLabels(case_st);
      | M3AST_AS.Try_except(try_except) =&gt;
          M3CDuplicate.HandlerExceptions(try_except);
      | M3AST_AS.Enumeration_type(enumeration_type)=&gt;
          M3CNameClash.Enumeration(enumeration_type);
      | M3AST_AS.Record_type(record_type) =&gt;
          M3CNameClash.Record(record_type);
      | M3AST_AS.Object_type(object_type) =&gt;
          M3CNameClash.Object(object_type);
      | M3AST_AS.Procedure_type(procedure_type) =&gt;
          M3CNameClash.Procedure(procedure_type);
      | M3AST_AS.Exc_decl_s =&gt;
          IF h.procNesting # 0 THEN
            M3Error.Report(any,
                &quot;exception must be declared at top level&quot;);
          END;
      | M3AST_AS.Concrete_reveal, M3AST_AS.Subtype_reveal =&gt;
          IF h.procNesting # 0 THEN
            M3Error.Report(any,
                &quot;type can only be revealed at top level&quot;);
          END;
      ELSE
        (* nothing *)
      END; (* if *)
    ELSE
      TYPECASE any OF
      | M3AST_AS.Loop_st, M3AST_AS.While_st,
        M3AST_AS.For_st, M3AST_AS.Repeat_st =&gt;
          DEC(h.loopCount);
      | M3AST_AS.Proc_decl =&gt;
          DEC(h.procNesting);
      ELSE
        (* nothing *)
      END; (* case *)
    END; (* case *)
  END Check;

PROCEDURE <A NAME="NewHandle"><procedure>NewHandle</procedure></A>(
    inModule, isProperCall, inLoop, inProc: BOOLEAN)
    : Handle
    RAISES {}=
  VAR
    new := NEW(Handle, inModule := inModule, isProperCall := isProperCall);
  BEGIN
    IF inLoop THEN INC(new.loopCount) END;
    IF inProc THEN INC(new.procNesting) END;
    RETURN new;
  END NewHandle;

BEGIN
END M3CSundries.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
