<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/sem/M3CTmpAtt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/sem/M3CTmpAtt.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>M3CTmpAtt</module> EXPORTS <A HREF="M3CTmpAtt.i3"><implements>M3CTmpAtt</A></implements>, <A HREF="../ast/M3ASTOp_SM.i3"><implements>M3ASTOp_SM</A></implements>;

IMPORT <A HREF="../../../libm3/derived/IntRefTbl.i3">IntRefTbl</A>;
IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../ast/M3ASTOp_SM.i3">M3ASTOp_SM</A>;
IMPORT <A HREF="../syn/M3CId.i3">M3CId</A>; (* to reveal an M3AST_LX.Symrep *)

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_TM_F.i3">M3AST_TM_F</A>;

IMPORT <A HREF="../../derived/SeqM3AST_AS_Override.i3">SeqM3AST_AS_Override</A>, <A HREF="../../derived/SeqM3AST_AS_Method.i3">SeqM3AST_AS_Method</A>;

IMPORT <A HREF="../gast/ASTWalk.i3">ASTWalk</A>;

CONST
  TmpDefIdTableSize = 64;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Set"><procedure>Set</procedure></A>(n: AST.NODE; id: M3AST_AS.UNIT_ID)=
  BEGIN
    n.set_tmp(id);
  END Set;

&lt;*INLINE*&gt; PROCEDURE <A NAME="SetTmpUnitId"><procedure>SetTmpUnitId</procedure></A>(n: AST.NODE; id: M3AST_AS.UNIT_ID)=
  BEGIN
    n.set_tmp_unit_id(id);
  END SetTmpUnitId;

&lt;*INLINE*&gt; PROCEDURE <A NAME="DefId"><procedure>DefId</procedure></A>(
    defId: M3AST_AS.DEF_ID;
    unitId: M3AST_AS.UNIT_ID)
    RAISES {}=
  BEGIN
    defId.tmp_unit_id := unitId;
    defId.tmp_recursive := FALSE;
  END DefId;

&lt;*INLINE*&gt; PROCEDURE <A NAME="TypeSpec"><procedure>TypeSpec</procedure></A>(
    ts: M3AST_AS.TYPE_SPEC;
    id: M3AST_AS.UNIT_ID)
    RAISES {}=
  BEGIN
    ts.tmp_unit_id := id;
  END TypeSpec;

TYPE
  Closure =
    ASTWalk.Closure OBJECT
      table: IntRefTbl.T;
    OVERRIDES
      callback := RecordId;
    END;

PROCEDURE <A NAME="RecordId"><procedure>RecordId</procedure></A>(
    c: Closure;
    an: AST.NODE;
    &lt;*UNUSED*&gt; vm: ASTWalk.VisitMode)
    RAISES {}=
  BEGIN
    TYPECASE an OF
    | M3AST_AS.DEF_ID(defId) =&gt;
        IF defId.lx_symrep # NIL THEN
          EVAL c.table.put(defId.lx_symrep.atom, defId);
        END; (* if *)
    | M3AST_AS.M3TYPE, M3AST_AS.EXP =&gt;
        ASTWalk.IgnoreChildren(c);
    ELSE
    END;
  END RecordId;

PROCEDURE <A NAME="SetTmpDefIdTable"><procedure>SetTmpDefIdTable</procedure></A>(int: M3AST_AS.Interface) RAISES {}=
  &lt;*FATAL ANY*&gt;
  VAR
    c: Closure;
    t: IntRefTbl.T;
  BEGIN
    t := NEW(IntRefTbl.Default).init(TmpDefIdTableSize);
    int.tmp_def_id_table := t;
    c := NEW(Closure, table := t);
    ASTWalk.VisitNodes(int.as_block, c);
  END SetTmpDefIdTable;

PROCEDURE <A NAME="Set_tmp"><procedure>Set_tmp</procedure></A>(an: M3ASTOp_SM.NODE; id: M3AST_AS.UNIT_ID) RAISES {} =
  VAR
    iter_m: SeqM3AST_AS_Method.Iter;
    iter_o: SeqM3AST_AS_Override.Iter;
    override: M3AST_AS.Override;
    method: M3AST_AS.Method;
  BEGIN
    TYPECASE an OF
    | M3AST_AS.Import_item(im) =&gt;
        IF im.as_id # NIL THEN
          im.as_id.tmp_used_id := im.as_intf_id;
        END; (* if *)
    | M3AST_AS.Concrete_decl(concreteDecl) =&gt;
        concreteDecl.as_id.tmp_type := concreteDecl.as_type;
    | M3AST_AS.Subtype_decl(subtypeDecl) =&gt;
        subtypeDecl.as_id.tmp_type := subtypeDecl.as_type;
    | M3AST_AS.Exc_decl(excDecl) =&gt;
        excDecl.as_id.tmp_type := excDecl.as_type;
    | M3AST_AS.Object_type(objectType) =&gt;
        iter_m := SeqM3AST_AS_Method.NewIter(objectType.as_method_s);
        WHILE SeqM3AST_AS_Method.Next(iter_m, method) DO
          method.tmp_type := objectType;
        END; (* while *)
        iter_o := SeqM3AST_AS_Override.NewIter(objectType.as_override_s);
        WHILE SeqM3AST_AS_Override.Next(iter_o, override) DO
          override.tmp_type := objectType;
        END; (* while *)
        TypeSpec(objectType, id);
    | M3AST_AS.Opaque_type(opaqueType) =&gt;
        opaqueType.tmp_rev_type_spec := NIL;
        TypeSpec(opaqueType, id);
    | M3AST_AS.Interface(interface) =&gt;
        SetTmpDefIdTable(interface);
    | M3AST_AS.DEF_ID(defId) =&gt;
        DefId(defId, id);
    | M3AST_AS.TYPE_SPEC(typeSpec) =&gt;
        TypeSpec(typeSpec, id);
    ELSE
    END;
  END Set_tmp;

PROCEDURE <A NAME="Set_tmp_unit_id"><procedure>Set_tmp_unit_id</procedure></A>(an: M3ASTOp_SM.NODE; id: M3AST_AS.UNIT_ID) RAISES {}=
  BEGIN
    TYPECASE an OF
    | M3AST_AS.DEF_ID(defId) =&gt;
        DefId(defId, id);
    | M3AST_AS.TYPE_SPEC(typeSpec) =&gt;
        TypeSpec(typeSpec, id);
    ELSE
    END;
  END Set_tmp_unit_id;

BEGIN
END M3CTmpAtt.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
