<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/sem/M3CTypeChkUtil.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/sem/M3CTypeChkUtil.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3CTypeChkUtil.i3">M3CTypeChkUtil</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P> To do:
-- Can texts screw up simple assumptions about checking whether a constant
-- expression is a member of a type?


<P><PRE>IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../ast/M3AST_SM.i3">M3AST_SM</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>, <A HREF="../ast/M3AST_TM_F.i3">M3AST_TM_F</A>;

IMPORT <A HREF="../../derived/SeqM3AST_AS_DECL_REVL.i3">SeqM3AST_AS_DECL_REVL</A>;

IMPORT <A HREF="M3CTypeRelation.i3">M3CTypeRelation</A>, <A HREF="M3CTypesMisc.i3">M3CTypesMisc</A>, <A HREF="M3CStdTypes.i3">M3CStdTypes</A>, <A HREF="M3CExpsMisc.i3">M3CExpsMisc</A>,
    <A HREF="M3COrdinal.i3">M3COrdinal</A>, <A HREF="M3CStdProcs.i3">M3CStdProcs</A>;

PROCEDURE <A NAME="IsBoolean"><procedure>IsBoolean</procedure></A>(type: M3AST_SM.TYPE_SPEC_UNSET): BOOLEAN RAISES {}=
  BEGIN
    RETURN M3CTypeRelation.Identical(
      M3CTypesMisc.CheckedUnpack(type), M3CStdTypes.Boolean());
  END IsBoolean;

PROCEDURE <A NAME="IsSubTypeOfInteger"><procedure>IsSubTypeOfInteger</procedure></A>(
    type: M3AST_SM.TYPE_SPEC_UNSET)
    : BOOLEAN
    RAISES {}=
  BEGIN
    RETURN M3CTypeRelation.SubType(type, M3CStdTypes.Integer());
  END IsSubTypeOfInteger;

PROCEDURE <A NAME="IsSubTypeOfBoolean"><procedure>IsSubTypeOfBoolean</procedure></A>(
    type: M3AST_SM.TYPE_SPEC_UNSET)
    : BOOLEAN
    RAISES {}=
  BEGIN
    RETURN M3CTypeRelation.SubType(type, M3CStdTypes.Boolean());
  END IsSubTypeOfBoolean;

PROCEDURE <A NAME="IsSubTypeOfCardinal"><procedure>IsSubTypeOfCardinal</procedure></A>(
    type: M3AST_SM.TYPE_SPEC_UNSET)
    : BOOLEAN
    RAISES {}=
  BEGIN
    RETURN M3CTypeRelation.SubType(type, M3CStdTypes.Cardinal());
  END IsSubTypeOfCardinal;

PROCEDURE <A NAME="IsSubTypeOfText"><procedure>IsSubTypeOfText</procedure></A>(type: M3AST_SM.TYPE_SPEC_UNSET): BOOLEAN RAISES {}=
  BEGIN
    RETURN M3CTypeRelation.SubType(type, M3CStdTypes.Text());
  END IsSubTypeOfText;

PROCEDURE <A NAME="IsSubTypeOfRefany"><procedure>IsSubTypeOfRefany</procedure></A>(
    type: M3AST_SM.TYPE_SPEC_UNSET)
    : BOOLEAN
    RAISES {}=
  BEGIN
    RETURN M3CTypeRelation.SubType(type, M3CStdTypes.RefAny());
  END IsSubTypeOfRefany;

PROCEDURE <A NAME="IsSubTypeOfAddress"><procedure>IsSubTypeOfAddress</procedure></A>(
    type: M3AST_SM.TYPE_SPEC_UNSET)
    : BOOLEAN
    RAISES {}=
  BEGIN
    RETURN M3CTypeRelation.SubType(type, M3CStdTypes.Address());
  END IsSubTypeOfAddress;

PROCEDURE <A NAME="IsTopLevel"><procedure>IsTopLevel</procedure></A>(id: M3AST_AS.Proc_id): BOOLEAN RAISES {}=
  VAR
    i: SeqM3AST_AS_DECL_REVL.Iter;
    decl: M3AST_AS.DECL_REVL;
    unit_id := NARROW(id.tmp_unit_id, M3AST_AS.UNIT_ID);
  BEGIN
    i := SeqM3AST_AS_DECL_REVL.NewIter(
        NARROW(unit_id.sm_spec, M3AST_AS.UNIT_NORMAL).as_block.as_decl_s);
    WHILE SeqM3AST_AS_DECL_REVL.Next(i, decl) DO
      TYPECASE decl OF
      | M3AST_AS.Proc_decl(procDecl) =&gt;
          IF procDecl.as_id = id THEN RETURN TRUE END;
      ELSE
      END; (* if *)
    END; (* while *)
    RETURN FALSE;
  END IsTopLevel;

PROCEDURE <A NAME="ClassifyProc"><procedure>ClassifyProc</procedure></A>(exp: M3AST_AS.EXP): Proc RAISES {}=
  VAR
    def: M3AST_SM.DEF_ID_UNSET;
    pf: M3CStdProcs.T;
  BEGIN
    TYPECASE exp.sm_exp_type_spec OF
    | NULL =&gt;
    | M3AST_AS.Procedure_type(pt) =&gt;
        def := pt.sm_def_id;
        TYPECASE def OF &lt;*NOWARN*&gt;
        | NULL =&gt; (* a procedure type declaration *)
        | M3AST_AS.Proc_id(procId) =&gt;
          IF M3CStdProcs.IsStandard(procId, pf) THEN
            RETURN Proc.Standard;
          ELSIF IsTopLevel(def) THEN
            RETURN Proc.TopLevel;
          ELSE
            RETURN Proc.Nested;
          END;
        | M3AST_AS.METHOD_OVERRIDE_ID, M3AST_AS.Type_id =&gt;
            RETURN Proc.Method;
        END;
    ELSE (* not a procedure *)
    END;
    RETURN Proc.Variable;
  END ClassifyProc;
</PRE> A note on the EXPAssignable procedure. If 'exp' is a constant it also checks
that the constant is a member of 'type'. This check looks too simple at first -
if 'type' is a subrange and 'exp' is constant then check that 'exp' is within
the bounds of the subrange. What about the other cases, when 'type' is not a
subrange? Well remember that the assignability of 'exp' to 'type' has already
been checked; that rules out a lot of weird cases. The assignment rule means
that we can assert:
<P>
  a)  E &lt;: T OR
  b)  E is a ref type or array type and T &lt;: E OR
  c)  E and T are ordinal types with at least one member in common
<P>
where T is 'type' and E is the type of 'exp'. If E &lt;: T then, by the definition
of subtyping, 'exp' must be a member of T. There are no ref constants
(caveat: what about Text) so we can ignore the ref part of clause (b). We can
also ignore the part of clause (b) referring to arrays because if an array
constant (i.e. a constructor) is assignable to T it will certainly also
be a member of T. This is because the values in the constructors are the
element type of the array (ultimately - there may be nested array constructors
for multi dimensional open arrays) and the element types of E and T must be
identical for E &lt;: T or T &lt;: E.
  So we are left with clause (c). Obviously if T is a base ordinal (i.e. an
enumeration or INTEGER) then 'exp' must be a member in order to be assignable.
Hence subranges are the only case we worry about 

<P><PRE>PROCEDURE <A NAME="EXPAssignable"><procedure>EXPAssignable</procedure></A>(
    type: M3AST_SM.TYPE_SPEC_UNSET;
    exp: M3AST_AS.EXP;
    safe: BOOLEAN)
    : BOOLEAN
    RAISES {}=
  CONST
    PossiblyTopLevel =
        ProcSet{Proc.TopLevel, Proc.Method, Proc.Variable};
  VAR
    unpacked: M3AST_SM.TYPE_SPEC_UNSET;
  BEGIN
    IF NOT M3CTypeRelation.Assignable(type, exp.sm_exp_type_spec, safe) THEN
      RETURN FALSE;
    END;
    unpacked := M3CTypesMisc.CheckedUnpack(type);
    TYPECASE unpacked OF
    | NULL =&gt;
    | M3AST_AS.Subrange_type(subrangeType) =&gt;
        IF exp.sm_exp_value # NIL THEN
          RETURN M3COrdinal.IsMemberOf(subrangeType, exp);
        END;
    | M3AST_AS.Procedure_type =&gt;
        RETURN ClassifyProc(exp) IN PossiblyTopLevel;
    ELSE
    END; (* if *)
    RETURN TRUE;
  END EXPAssignable;

PROCEDURE <A NAME="IsExpectedClass"><procedure>IsExpectedClass</procedure></A>(
    exp: M3AST_AS.EXP;
    classes: M3CExpsMisc.ClassSet)
    : BOOLEAN
    RAISES {}=
  VAR
    class := M3CExpsMisc.Classify(exp);
  BEGIN
    IF class IN classes THEN
      RETURN TRUE;
    ELSE
      M3CExpsMisc.WrongClass(exp, class);
      RETURN FALSE;
    END; (* if *)
  END IsExpectedClass;

PROCEDURE <A NAME="IsNormalEXP"><procedure>IsNormalEXP</procedure></A>(exp: M3AST_AS.EXP): BOOLEAN RAISES {}=
  BEGIN
    RETURN IsExpectedClass(exp, M3CExpsMisc.NormalOnly);
  END IsNormalEXP;

BEGIN
END M3CTypeChkUtil.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
