<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/sem/M3CTypesMisc.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/sem/M3CTypesMisc.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3CTypesMisc.i3">M3CTypesMisc</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P>
<P><PRE>IMPORT <A HREF="../ast/M3AST_LX.i3">M3AST_LX</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../ast/M3AST_SM.i3">M3AST_SM</A>, <A HREF="M3ASTNext.i3">M3ASTNext</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>;

IMPORT <A HREF="../../derived/SeqM3AST_AS_M3TYPE.i3">SeqM3AST_AS_M3TYPE</A>, <A HREF="../../derived/SeqM3AST_AS_Fields.i3">SeqM3AST_AS_Fields</A>, <A HREF="../../derived/SeqM3AST_AS_Enum_id.i3">SeqM3AST_AS_Enum_id</A>,
    <A HREF="../../derived/SeqM3AST_AS_Override.i3">SeqM3AST_AS_Override</A>;

IMPORT <A HREF="M3CBackEnd.i3">M3CBackEnd</A>, <A HREF="M3COrdinal.i3">M3COrdinal</A>, <A HREF="M3CConcTypeSpec.i3">M3CConcTypeSpec</A>;

PROCEDURE <A NAME="GetTYPE_SPECFromM3TYPE"><procedure>GetTYPE_SPECFromM3TYPE</procedure></A>(
    t: M3AST_AS.M3TYPE;
    VAR (*out*) ts: M3AST_SM.TYPE_SPEC_UNSET)
    RAISES {}=
  BEGIN
    TYPECASE t OF &lt;*NOWARN*&gt;
    | M3AST_AS.Named_type(namedType) =&gt;
        ts := namedType.sm_type_spec;
    | M3AST_AS.TYPE_SPEC(typeSpec) =&gt;
        ts := typeSpec;
    | M3AST_AS.Bad_M3TYPE =&gt;
        ts := NIL;
    END;
  END GetTYPE_SPECFromM3TYPE;

PROCEDURE <A NAME="Unpack"><procedure>Unpack</procedure></A>(
    p: M3AST_AS.Packed_type)
    : M3AST_SM.TYPE_SPEC_UNSET
    RAISES {}=
  VAR
    unpacked: M3AST_SM.TYPE_SPEC_UNSET;
  BEGIN
    LOOP
      GetTYPE_SPECFromM3TYPE(p.as_type, unpacked);
      TYPECASE unpacked OF
      | NULL =&gt;
          RETURN NIL;
      | M3AST_AS.Packed_type(packed) =&gt;
          p := packed; (* and loop *)
      ELSE
        RETURN unpacked;
      END;
    END;
  END Unpack;

PROCEDURE <A NAME="CheckedUnpack"><procedure>CheckedUnpack</procedure></A>(
    t: M3AST_SM.TYPE_SPEC_UNSET)
    : M3AST_SM.TYPE_SPEC_UNSET
    RAISES {}=
  BEGIN
    TYPECASE t OF
    | NULL =&gt; RETURN NIL;
    | M3AST_AS.Packed_type(p) =&gt; RETURN Unpack(p);
    ELSE
      RETURN t;
    END;
  END CheckedUnpack;

PROCEDURE <A NAME="Reveal"><procedure>Reveal</procedure></A>(
    ts: M3AST_SM.TYPE_SPEC_UNSET)
    : M3AST_SM.TYPE_SPEC_UNSET
    RAISES {}=
  BEGIN
    LOOP
      IF ts = NIL THEN RETURN ts
      ELSIF ISTYPE(ts, M3AST_AS.Opaque_type) THEN
        ts := M3CConcTypeSpec.CurrentReveal(ts);
      ELSE
        RETURN ts;
      END;
    END;
  END Reveal;

PROCEDURE <A NAME="Concrete"><procedure>Concrete</procedure></A>(
    ts: M3AST_SM.TYPE_SPEC_UNSET)
    : M3AST_SM.TYPE_SPEC_UNSET
    RAISES {}=
  VAR
    reveal := M3CConcTypeSpec.CurrentReveal(ts);
  BEGIN
    IF (reveal # ts) AND
        (NARROW(ts, M3AST_AS.Opaque_type).sm_concrete_type_spec = reveal) THEN
      RETURN reveal;
    ELSE
      RETURN ts;
    END;
  END Concrete;

PROCEDURE <A NAME="IsConcrete"><procedure>IsConcrete</procedure></A>(
    ts: M3AST_SM.TYPE_SPEC_UNSET;
    fully: BOOLEAN)
    : BOOLEAN
    RAISES {}=
  VAR
    typeSpec: M3AST_SM.TYPE_SPEC_UNSET;
  BEGIN
    TYPECASE ts OF
    | NULL =&gt;
        RETURN TRUE;
    | M3AST_AS.Object_type(object) =&gt;
        IF fully AND M3ASTNext.SimpleSuperType(object, typeSpec) THEN
          RETURN IsConcrete(typeSpec, TRUE);
        ELSE
          RETURN TRUE;
        END;
    | M3AST_AS.Opaque_type(opaque) =&gt;
        typeSpec := M3CConcTypeSpec.CurrentReveal(ts);
        IF (typeSpec # ts) AND
            (opaque.sm_concrete_type_spec = typeSpec) THEN
          RETURN (NOT fully) OR IsConcrete(typeSpec, TRUE);
        ELSE
          RETURN FALSE;
        END;
    ELSE
      RETURN TRUE;
    END;
  END IsConcrete;

PROCEDURE <A NAME="Index"><procedure>Index</procedure></A>(
    a: M3AST_AS.Array_type;
    VAR index: M3AST_SM.TYPE_SPEC_UNSET)
    : Ix
    RAISES {}=
  VAR
    i := SeqM3AST_AS_M3TYPE.NewIter(a.as_indextype_s);
    m3Type: M3AST_AS.M3TYPE;
  BEGIN
    IF SeqM3AST_AS_M3TYPE.Next(i, m3Type) THEN
      GetTYPE_SPECFromM3TYPE(m3Type, index);
      LOOP
        TYPECASE index OF
        | NULL =&gt;
            RETURN Ix.Unknown;
        | M3AST_AS.Integer_type,
          M3AST_AS.Enumeration_type,
          M3AST_AS.Subrange_type =&gt;
            RETURN Ix.Ordinal;
        | M3AST_AS.Packed_type(packed) =&gt;
            index := Unpack(packed);
            (* loop and try again *)
        ELSE
          RETURN Ix.Bad;
        END; (* case *)
      END;
    ELSE
      RETURN Ix.Open;
    END; (* if *)
  END Index;

PROCEDURE <A NAME="Indexable"><procedure>Indexable</procedure></A>(
    ts: M3AST_SM.TYPE_SPEC_UNSET;
    VAR a: M3AST_AS.Array_type)
    : BOOLEAN
    RAISES {}=
  BEGIN
    TYPECASE Concrete(CheckedUnpack(ts)) OF
    | M3AST_AS.Array_type(arrayType) =&gt;
        a := arrayType;
        RETURN TRUE; (* NIL case ok *)
    | M3AST_AS.Ref_type(refType) =&gt;
        VAR
          referent: M3AST_SM.TYPE_SPEC_UNSET;
        BEGIN
          GetTYPE_SPECFromM3TYPE(refType.as_type, referent);
          TYPECASE CheckedUnpack(referent) OF
          | M3AST_AS.Array_type(arrayType) =&gt;
              a := arrayType; (* NIL case ok *)
              RETURN TRUE;
          ELSE
          END;
        END;
    ELSE
    END;
    RETURN FALSE;
  END Indexable;

PROCEDURE <A NAME="IsRef"><procedure>IsRef</procedure></A>(ts: M3AST_SM.TYPE_SPEC_UNSET): BOOLEAN RAISES {}=
  BEGIN
    IF ts = NIL THEN RETURN TRUE END;
    TYPECASE ts OF
    | M3AST_AS.RefAny_type, M3AST_AS.Root_type,
      M3AST_AS.Address_type,
      M3AST_AS.Ref_type, M3AST_AS.Object_type,
      M3AST_AS.Opaque_type, M3AST_AS.Null_type =&gt;
        RETURN TRUE;
    ELSE
      RETURN FALSE;
    END; (* case *)
  END IsRef;

CONST
  BadSuperType = RefSet{Ref.Null, Ref.Not};

PROCEDURE <A NAME="IsTracedObject"><procedure>IsTracedObject</procedure></A>(o: M3AST_AS.Object_type): Ref RAISES {}=
  VAR
    super: M3AST_SM.TYPE_SPEC_UNSET;
    traced: Ref;
  BEGIN
    IF M3ASTNext.SimpleSuperType(o, super) THEN
      traced := IsTracedRef(super);
      IF traced IN BadSuperType THEN RETURN Ref.Unknown ELSE RETURN traced END;
    ELSE
      RETURN Ref.Traced;
    END;
  END IsTracedObject;

PROCEDURE <A NAME="IsTracedRef"><procedure>IsTracedRef</procedure></A>(type: M3AST_SM.TYPE_SPEC_UNSET): Ref RAISES {}=
  BEGIN
    IF type = NIL THEN RETURN Ref.Unknown END;
    TYPECASE type OF
    | M3AST_AS.RefAny_type =&gt;
        RETURN Ref.Traced;
    | M3AST_AS.Address_type =&gt;
        RETURN Ref.Untraced;
    | M3AST_AS.Root_type(root_type) =&gt;
        IF root_type.as_trace_mode = NIL THEN
          RETURN Ref.Traced;
        ELSE
          RETURN Ref.Untraced;
        END; (* if *)
    | M3AST_AS.Ref_type(ref_type) =&gt;
        IF ref_type.as_trace_mode = NIL THEN
          RETURN Ref.Traced;
        ELSE
          RETURN Ref.Untraced;
        END; (* if *)
    | M3AST_AS.Object_type(object_type) =&gt;
        RETURN IsTracedObject(object_type);
    | M3AST_AS.Opaque_type =&gt;
        WITH ref = IsTracedRef(Reveal(type)) DO
          IF ref IN BadSuperType THEN RETURN Ref.Unknown ELSE RETURN ref END;
        END;
    | M3AST_AS.Null_type =&gt;
        RETURN Ref.Null;
    ELSE
      RETURN Ref.Not;
    END; (* case *)
  END IsTracedRef;

PROCEDURE <A NAME="ContainsTracedFields"><procedure>ContainsTracedFields</procedure></A>(fields: SeqM3AST_AS_Fields.T): BOOLEAN RAISES {}=
  VAR
    iter := M3ASTNext.NewIterField(fields);
    fieldId: M3AST_AS.Field_id;
  BEGIN
    WHILE M3ASTNext.Field(iter, fieldId) DO
      IF IsTraced(fieldId.sm_type_spec) THEN RETURN TRUE END;
    END; (* while *)
    RETURN FALSE;
  END ContainsTracedFields;

PROCEDURE <A NAME="IsTraced"><procedure>IsTraced</procedure></A>(type: M3AST_SM.TYPE_SPEC_UNSET): BOOLEAN RAISES {}=
  BEGIN
    TYPECASE type OF
    | NULL =&gt;
        RETURN FALSE;
    | M3AST_AS.RefAny_type =&gt;
        RETURN TRUE;
    | M3AST_AS.Root_type(root) =&gt;
        RETURN root.as_trace_mode = NIL;
    | M3AST_AS.Ref_type(ref) =&gt;
        RETURN ref.as_trace_mode = NIL;
    | M3AST_AS.Object_type(object) =&gt;
        RETURN IsTracedObject(object) IN ProbablyTraced;
    | M3AST_AS.Record_type(record) =&gt;
        RETURN ContainsTracedFields(record.as_fields_s);
    | M3AST_AS.Array_type(array) =&gt;
        VAR
          elementType: M3AST_SM.TYPE_SPEC_UNSET;
        BEGIN
          GetTYPE_SPECFromM3TYPE(array.as_elementtype, elementType);
          RETURN IsTraced(elementType);
        END;
    | M3AST_AS.Packed_type(packed) =&gt;
        VAR
          component: M3AST_SM.TYPE_SPEC_UNSET;
        BEGIN
          GetTYPE_SPECFromM3TYPE(packed.as_type, component);
          RETURN IsTraced(component);
        END;
    ELSE
      RETURN FALSE;
    END; (* case *)
  END IsTraced;

PROCEDURE <A NAME="IsOpenArray"><procedure>IsOpenArray</procedure></A>(type: M3AST_SM.TYPE_SPEC_UNSET): BOOLEAN RAISES {}=
  BEGIN
    TYPECASE type OF
    | NULL =&gt; RETURN FALSE;
    | M3AST_AS.Array_type(array) =&gt; RETURN SeqM3AST_AS_M3TYPE.Empty(array.as_indextype_s);
    ELSE
      RETURN FALSE;
    END;
  END IsOpenArray;

PROCEDURE <A NAME="IsEmpty"><procedure>IsEmpty</procedure></A>(type: M3AST_SM.TYPE_SPEC_UNSET): BOOLEAN RAISES {}=
  BEGIN
    TYPECASE type OF
    | NULL =&gt;
        RETURN FALSE;
    | M3AST_AS.Enumeration_type(enum) =&gt;
        RETURN SeqM3AST_AS_Enum_id.Empty(enum.as_id_s);
    | M3AST_AS.Subrange_type =&gt;
        VAR
          first, last: M3AST_SM.Exp_value;
        BEGIN
          RETURN M3COrdinal.ValidBounds(type, first, last) AND
              M3CBackEnd.Compare(first, last) &gt; 0;
        END;
    | M3AST_AS.Array_type(array) =&gt;
        (* empty if element type is empty and primary index type is not empty;
         If both element type and primary index type are empty the null
         constructor is a valid value of the type *)
        VAR
          index, element: M3AST_SM.TYPE_SPEC_UNSET;
        BEGIN
          array := array.sm_norm_type;
          GetTYPE_SPECFromM3TYPE(array.as_elementtype, element);
          RETURN IsEmpty(element) AND Index(array, index) = Ix.Ordinal AND
              NOT IsEmpty(index);
        END;
    | M3AST_AS.Packed_type(packed) =&gt;
        RETURN IsEmpty(Unpack(packed));
    ELSE
      RETURN FALSE;
    END;
  END IsEmpty;

PROCEDURE <A NAME="NoDefaultForMethod"><procedure>NoDefaultForMethod</procedure></A>(
    o: M3AST_AS.Object_type;
    methodId: M3AST_AS.Method_id)
    : BOOLEAN
    RAISES {}=
  VAR
    id: M3AST_LX.Symbol_rep;
    iter: SeqM3AST_AS_Override.Iter;
    override: M3AST_AS.Override;
    ts, concrete: M3AST_SM.TYPE_SPEC_UNSET;
  BEGIN
    IF methodId.vINIT_ID.sm_init_exp # NIL THEN RETURN FALSE END;
    (* Assert: 'methodId' must be the defining occurence of the method. Only
     the defining occurence has the option of having no default. *)
    id := methodId.lx_symrep;
    IF id = NIL THEN RETURN FALSE END;
    LOOP
      (* Search overrides at current level of object type *)
      iter := SeqM3AST_AS_Override.NewIter(o.as_override_s);
      WHILE SeqM3AST_AS_Override.Next(iter, override) DO
        WITH mId = override.as_id DO
          IF mId.lx_symrep = id AND mId.vREDEF_ID.sm_int_def = methodId THEN
              RETURN FALSE; (* default found *)
          END;
        END;
      END;
      (* If no luck at the current level we look at the supertype *)
      IF NOT M3ASTNext.SimpleSuperType(o, ts) THEN RETURN TRUE END;
      LOOP
        TYPECASE ts OF
        | NULL =&gt;
            RETURN FALSE;
        | M3AST_AS.Object_type(objectType) =&gt;
            o := objectType;
            EXIT; (* to outer loop; search for default in supertype *)
        | M3AST_AS.Opaque_type =&gt;
            concrete := Concrete(ts);
            IF concrete = ts THEN
              (* We don't know the concrete representation; so the default may
               be hidden in the opaque supertype - we return FALSE *)
              RETURN FALSE;
            ELSE
              ts := concrete;
              (* Loop and check out the concrete supertype *)
            END;
        ELSE
          RETURN FALSE; (* A cockup elsewhere; we pretend there's no problem *)
        END;
      END;
    END;
  END NoDefaultForMethod;

PROCEDURE <A NAME="HiddenObjectParameter"><procedure>HiddenObjectParameter</procedure></A>(
    p: M3AST_AS.Procedure_type;
    VAR ts: M3AST_SM.TYPE_SPEC_UNSET)
    : BOOLEAN
    RAISES {}=
  BEGIN
    TYPECASE p.sm_def_id OF
    | NULL =&gt; RETURN FALSE;
    | M3AST_AS.METHOD_OVERRIDE_ID(methodId) =&gt;
        ts := methodId.vRECOBJ_ID.sm_enc_type_spec;
        RETURN TRUE;
    | M3AST_AS.Type_id(typeId) =&gt;
        ts := typeId.sm_type_spec;
        RETURN TRUE;
    ELSE
      RETURN FALSE;
    END;
  END HiddenObjectParameter;

BEGIN
END M3CTypesMisc.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
