<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/sem/M3CWordProcs.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/sem/M3CWordProcs.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3CWordProcs.i3">M3CWordProcs</A></implements></module>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../libm3/derived/TextRefTbl.i3">TextRefTbl</A>;

IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_TM_F.i3">M3AST_TM_F</A>;

IMPORT <A HREF="../syn/M3CId.i3">M3CId</A>, <A HREF="../misc/M3Assert.i3">M3Assert</A>, <A HREF="M3CExpsMisc.i3">M3CExpsMisc</A>;

PROCEDURE <A NAME="Enter"><procedure>Enter</procedure></A>(table: TextRefTbl.T; t: Text.T; w: T) RAISES {}=
  VAR
    new := NEW(REF T);
  BEGIN
    new^ := w;
    M3Assert.Check(NOT table.put(t, new));
  END Enter;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A>(): TextRefTbl.T RAISES {}=
  VAR
    result := NEW(TextRefTbl.Default).init(64);
  BEGIN
    Enter(result, &quot;Plus&quot;, T.Plus);
    Enter(result, &quot;Times&quot;, T.Times);
    Enter(result, &quot;Minus&quot;, T.Minus);
    Enter(result, &quot;Divide&quot;, T.Divide);
    Enter(result, &quot;Mod&quot;, T.Mod);
    Enter(result, &quot;LT&quot;, T.LT);
    Enter(result, &quot;LE&quot;, T.LE);
    Enter(result, &quot;GT&quot;, T.GT);
    Enter(result, &quot;GE&quot;, T.GE);
    Enter(result, &quot;And&quot;, T.And);
    Enter(result, &quot;Or&quot;, T.Or);
    Enter(result, &quot;Xor&quot;, T.Xor);
    Enter(result, &quot;Not&quot;, T.Not);
    Enter(result, &quot;Shift&quot;, T.Shift);
    Enter(result, &quot;LeftShift&quot;, T.Shift);
    Enter(result, &quot;RightShift&quot;, T.RightShift);
    Enter(result, &quot;Rotate&quot;, T.Rotate);
    Enter(result, &quot;LeftRotate&quot;, T.Rotate);
    Enter(result, &quot;RightRotate&quot;, T.RightRotate);
    Enter(result, &quot;Extract&quot;, T.Extract);
    Enter(result, &quot;Insert&quot;, T.Insert);
    RETURN result;
  END Initialize;

VAR
  table_g := Initialize();
  word_g: M3CId.T := NIL;

PROCEDURE <A NAME="IsWordCall"><procedure>IsWordCall</procedure></A>(call: M3AST_AS.Call; VAR t: T): BOOLEAN RAISES {}=
  VAR
    defId: M3AST_AS.DEF_ID;
  BEGIN
    IF M3CExpsMisc.IsId(call.as_callexp, defId) AND
        ISTYPE(defId, M3AST_AS.Proc_id) THEN
      VAR
        hId: REFANY;
      BEGIN
        IF word_g = NIL THEN word_g := M3CId.Enter(&quot;Word&quot;) END;
        IF defId.tmp_unit_id.lx_symrep = word_g THEN
          IF table_g.get(M3CId.ToText(defId.lx_symrep), hId) THEN
            t := NARROW(hId, REF T)^;
            RETURN TRUE;
          ELSE
            RETURN FALSE;
          END; (* if *)
        ELSE
          RETURN FALSE;
        END; (* if *)
      END;
    ELSE
      RETURN FALSE;
    END; (* if *)
  END IsWordCall;

PROCEDURE <A NAME="ArgCount"><procedure>ArgCount</procedure></A>(t: T): CARDINAL RAISES {}=
  BEGIN
    CASE t OF
    | T.Plus =&gt; RETURN 2;
    | T.Times =&gt; RETURN 2;
    | T.Minus =&gt; RETURN 2;
    | T.Divide =&gt; RETURN 2;
    | T.Mod =&gt; RETURN 2;
    | T.LT =&gt; RETURN 2;
    | T.LE =&gt; RETURN 2;
    | T.GT =&gt; RETURN 2;
    | T.GE =&gt; RETURN 2;
    | T.And =&gt; RETURN 2;
    | T.Or =&gt; RETURN 2;
    | T.Xor =&gt; RETURN 2;
    | T.Not =&gt; RETURN 1;
    | T.Shift =&gt; RETURN 2;
    | T.RightShift =&gt; RETURN 2;
    | T.Rotate =&gt; RETURN 2;
    | T.RightRotate =&gt; RETURN 2;
    | T.Extract =&gt; RETURN 3;
    | T.Insert =&gt; RETURN 4;
    END;
  END ArgCount;

BEGIN
END M3CWordProcs.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
