<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/syn/M3CComment.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/syn/M3CComment.i3</H2></A><HR>
<inInterface>
<PRE></PRE>***********************************************************************
!		                                                        *
!*                                                                      *
!*         Copyright 1994 Sun Microsystems, Inc. All Rights Reserved.   *
!*                                                                      *
!*      Permission to use, copy, modify, and distribute this software   *
!*      and its documentation for any purpose and without fee is hereby *
!*      granted, provided that the above copyright notice appear in all *
!*      copies and that both that copyright notice and this permission  *
!*      notice appear in supporting documentation, and that the name of *
!*      Sun Microsystems, Inc. (SMI) not be used in advertising or      *
!*      publicity pertaining to distribution of the software without    *
!*      specific, written prior permission.                             *
!*                                                                      *
!*                                                                      *
!*      SMI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,      *
!*      INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,	        *
!*      FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.           *
!*      IN NO EVENT SHALL SMI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,    *
!*	INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER     *
!*      RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN      *
!*      ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,        *
!*      ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE     *
!*      OF THIS SOFTWARE.                                               *
!*                                                                      *
!**********************************************************************

<P><PRE>INTERFACE <interface><A HREF="M3CComment.m3">M3CComment</A></interface>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="M3CSrcPos.i3">M3CSrcPos</A>;
</PRE> The following are used by the parser to build up a Comment store. 'NewStore'
creates a new Comment store and each Comment encountered is added with the
'AddToStore' procedure. Comments must be added in source position order. Comments
must start with <CODE>(*</CODE> and end with <CODE><PRE>&quot; *)

TYPE
  <A HREF="M3CComment.m3#Store">Store</A> &lt;: REFANY;
  <A HREF="M3CComment.m3#T">T</A> &lt;: REFANY;

PROCEDURE <A HREF="M3CComment.m3#NewStore">NewStore</A>(): Store RAISES {};
</PRE><BLOCKQUOTE><EM> Create new Comment store </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CComment.m3#AddToStore">AddToStore</A>(
    body: Text.T;
    pos: M3CSrcPos.T;
    precedingNode: M3AST_AS.SRC_NODE;
    VAR store: Store)
    : T
    RAISES {};
</PRE><BLOCKQUOTE><EM> Add a new Comment to a store, giving its body, position and the preceding
source node </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CComment.m3#AddFollowingNode">AddFollowingNode</A>(
    followingNode: M3AST_AS.SRC_NODE;
    store: Store)
    RAISES {};
</PRE><BLOCKQUOTE><EM> Called after a Comment (or Comments) has been added by 'AddToStore' and
another source node is encountered. Marks all the Comments after the last
source node as having the given 'followingNode' </EM></BLOCKQUOTE><PRE>
</PRE> The Comments in a Comment store can be iterated using 'NewIter' and 'Next'.
The iterator works even while the store is being built up using 'AddToStore' 

<P><PRE>TYPE
  <A HREF="M3CComment.m3#Iter">Iter</A> &lt;: REFANY;

PROCEDURE <A HREF="M3CComment.m3#NewIter">NewIter</A>(ps: Store): Iter RAISES {};
</PRE><BLOCKQUOTE><EM> Return iterator for Comments. They will be iterated in ascending positional
order. If 'after' is not null only the Comments whose position is greater than
'after' will be iterated </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CComment.m3#Next">Next</A>(VAR iter: Iter; VAR t: T): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> 'Next' returns FALSE if 'iter' is NIL </EM></BLOCKQUOTE><PRE>
</PRE> The following enquiry functions can be used on all Comments 

<P><PRE>PROCEDURE <A HREF="M3CComment.m3#Position">Position</A>(t: T): M3CSrcPos.T RAISES {};
</PRE><BLOCKQUOTE><EM> Source position of Comment </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CComment.m3#Body">Body</A>(t: T): Text.T RAISES {};
</PRE><BLOCKQUOTE><EM> Text of Comment. Includes opening and closing brackets </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CComment.m3#PrecedingNode">PrecedingNode</A>(t: T): M3AST_AS.SRC_NODE RAISES {};
</PRE><BLOCKQUOTE><EM> Return the node which immediately precedes the given Comment, or NIL if there
is no such node </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CComment.m3#FollowingNode">FollowingNode</A>(t: T): M3AST_AS.SRC_NODE RAISES {};
</PRE><BLOCKQUOTE><EM> Return the node which immediately follows the given Comment, or NIL if there
is no such node </EM></BLOCKQUOTE><PRE>

END M3CComment.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
