<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/syn/M3CComment.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/syn/M3CComment.m3</H2></A><HR>
<inModule>
<PRE></PRE>***********************************************************************
!		                                                        *
!*                                                                      *
!*         Copyright 1994 Sun Microsystems, Inc. All Rights Reserved.   *
!*                                                                      *
!*      Permission to use, copy, modify, and distribute this software   *
!*      and its documentation for any purpose and without fee is hereby *
!*      granted, provided that the above copyright notice appear in all *
!*      copies and that both that copyright notice and this permission  *
!*      notice appear in supporting documentation, and that the name of *
!*      Sun Microsystems, Inc. (SMI) not be used in advertising or      *
!*      publicity pertaining to distribution of the software without    *
!*      specific, written prior permission.                             *
!*                                                                      *
!*                                                                      *
!*      SMI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,      *
!*      INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,	        *
!*      FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.           *
!*      IN NO EVENT SHALL SMI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,    *
!*	INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER     *
!*      RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN      *
!*      ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,        *
!*      ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE     *
!*      OF THIS SOFTWARE.                                               *
!*                                                                      *
!**********************************************************************

<P><PRE>MODULE <module><implements><A HREF="M3CComment.i3">M3CComment</A></implements></module>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="M3CSrcPos.i3">M3CSrcPos</A>;
IMPORT <A HREF="M3CComment.i3">M3CComment</A>;
</PRE>*IMPORT M3AST_AS_F;*

<P><PRE>REVEAL
  M3CComment.<A NAME="T">T</A> = BRANDED OBJECT
    prev, next:  M3CComment.Iter := NIL;
    pos: M3CSrcPos.T;
    body: TEXT;
    precedingNode, followingNode: M3AST_AS.SRC_NODE := NIL;
  END;

  M3CComment.<A NAME="Iter">Iter</A> = M3CComment.T BRANDED OBJECT END;

  M3CComment.<A NAME="Store">Store</A> = BRANDED REF RECORD
    first, last: M3CComment.Iter := NIL;
  END;

PROCEDURE <A NAME="NewStore"><procedure>NewStore</procedure></A>(): Store RAISES {}=
  BEGIN
    RETURN NEW(Store);
  END NewStore;

PROCEDURE <A NAME="AddToStore"><procedure>AddToStore</procedure></A>(
    body: Text.T;
    pos: M3CSrcPos.T;
    precedingNode: M3AST_AS.SRC_NODE;
    VAR store: Store)
    : T
    RAISES {}=
  VAR
    new := NEW(Iter, pos := pos, body := body,
        precedingNode := precedingNode);
  BEGIN
    WITH last = store.last DO
      IF last = NIL THEN
        store.first := new;
      ELSE
        last.next := new;
        new.prev := last;
      END;
      last := new;
    END;
    RETURN new;
  END AddToStore;

PROCEDURE <A NAME="AddFollowingNode"><procedure>AddFollowingNode</procedure></A>(
    followingNode: M3AST_AS.SRC_NODE;
    store: Store)
    RAISES {}=
  VAR
    t := store.last;
    precedingNode := t.precedingNode;
  BEGIN
    REPEAT
      t.followingNode := followingNode;
      t := t.prev;
    UNTIL t = NIL OR t.precedingNode # precedingNode;
  END AddFollowingNode;

PROCEDURE <A NAME="NewIter"><procedure>NewIter</procedure></A>(ps: Store): Iter RAISES {}=
  BEGIN
    IF ps = NIL THEN RETURN NIL ELSE RETURN ps.first END;
  END NewIter;

PROCEDURE <A NAME="Next"><procedure>Next</procedure></A>(VAR iter: Iter; VAR t: T): BOOLEAN RAISES {}=
  BEGIN
    IF iter = NIL THEN RETURN FALSE END;
    t := iter;
    iter := iter.next;
    RETURN TRUE;
  END Next;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A>(t: T): M3CSrcPos.T RAISES {}=
  BEGIN
    RETURN t.pos;
  END Position;

PROCEDURE <A NAME="Body"><procedure>Body</procedure></A>(t: T): Text.T RAISES {}=
  BEGIN
    RETURN t.body;
  END Body;

PROCEDURE <A NAME="PrecedingNode"><procedure>PrecedingNode</procedure></A>(t: T): M3AST_AS.SRC_NODE RAISES {}=
  BEGIN
    RETURN t.precedingNode;
  END PrecedingNode;

PROCEDURE <A NAME="FollowingNode"><procedure>FollowingNode</procedure></A>(t: T): M3AST_AS.SRC_NODE RAISES {}=
  BEGIN
    RETURN t.followingNode;
  END FollowingNode;

BEGIN

END M3CComment.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
