<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/syn/M3CHash.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/syn/M3CHash.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="M3CHash.m3">M3CHash</A></interface>;
</PRE> Hash table for reserved words, literals, identifiers. 

<P><PRE>TYPE
  <A HREF="M3CHash.m3#Table">Table</A> &lt;: TablePublic;
  TablePublic = OBJECT
  METHODS
    init(size: CARDINAL; idCreator: IdCreator := NIL): Table;
    enter(text: TEXT): Id;
    lookup(text: TEXT; VAR id: Id): BOOLEAN;
    setCreator(idCreator: IdCreator): IdCreator;
    enterCharsWithValue(v: Value; READONLY chars: ARRAY OF CHAR): Id;
    enterTextWithValue(v: Value; text: TEXT): Id;
  END;

  <A HREF="M3CHash.m3#Id">Id</A> &lt;: IdPublic;
  IdPublic = OBJECT
  METHODS
    toText(): TEXT;
  END;

  IdCreator = OBJECT METHODS new(text: TEXT): Id END;
</PRE> When creating a table the client specifies:
\begin{itemize}
\item The table size. It is a bucket and chain style hash table; <CODE>size</CODE> 
      specifies the number of buckets).
\item An optional <CODE>IdCreator</CODE> object. If this is supplied its <CODE>new</CODE>
      method will be called whenever a text <CODE>n</CODE> is added to the table by
      the <CODE>enter(n)</CODE> method. The <CODE>id</CODE> returned by the <CODE>new</CODE> method (which 
      can be any subtype of <CODE>Id</CODE>) will be the value that is associated with 
      <CODE>n</CODE>. If no creation object is specified, a default subtype of <CODE>Id</CODE>
      will be associated. A different <CODE>id</CODE> value must be associated
      with each text that is entered in the table.
\end{itemize}
<P>
<P>
A call of <CODE>lookup(n, id)</CODE> returns <CODE>TRUE</CODE> if <CODE>n</CODE> has been entered in the
table, and sets <CODE>id</CODE> to the <CODE>Id</CODE> value that was associated with <CODE>n</CODE>.
Otherwise it returns <CODE>FALSE</CODE> and leaves <CODE>id</CODE> unchanged.
<P>
The <CODE>setCreator</CODE> method changes the <CODE>IdCreator</CODE> object that is associated
with the table, returning the previous value.
<P>
The <CODE>toText</CODE> method returns the text with which <CODE>id</CODE> has been associated.
<P>
\subsection{Incremental Hashing}
<P>
The following routines expose more of the hashing mechanism. They allow a
hash value to be built up incrementally and then specified when a text or
array of characters is entered into the table. They are intended for use by
a lexer which has to build up arrays of characters (e.g. identifiers,
reserved words) incrementally and hence can build up the hash value at the
same time 

<P><PRE>TYPE
  <A HREF="M3CHash.m3#Value">Value</A> &lt;: ValuePublic;
  ValuePublic = OBJECT
  METHODS
    init(): Value;
    reset();
    addCharToValue(ch: CHAR);
  END;
</PRE> A hash value is created by <CODE>NEW(Value).init()</CODE>. The <CODE>reset</CODE> method
resets the computed value to the initial value. Therefore, a lexer
need only allocate one <CODE>Value</CODE> object and reuse it many times.
The <CODE>addCharToValue</CODE> method adds the character <CODE>ch</CODE> to the hash value. 
Values must be added in sequence. For example the
the hash value for <CODE>ab</CODE> is constructed by:
<P>
<PRE>
       v := NEW(M3CHash.Value).init();
       v.addCharToValue('a');
       v.addCharToValue('b');
</PRE>
The <CODE>enterCharsWithValue</CODE> and <CODE>enterTextWithValue</CODE> methods add
<CODE>chars</CODE> and <CODE>text</CODE> to the table, using the precomputed hash value <CODE>v</CODE>. 

<P>
<P><PRE>END M3CHash.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
