<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/syn/M3CHash.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/syn/M3CHash.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3CHash.i3">M3CHash</A></implements></module>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../word/src/Word.i3">Word</A>;

REVEAL
  <A NAME="Table">Table</A> = TablePublic BRANDED OBJECT
    size: CARDINAL;
    idCreator: IdCreator;
    ids: REF ARRAY OF Id;
  OVERRIDES
    init := InitTable;
    enter := Enter;
    lookup := Lookup;
    setCreator := SetCreator;
    enterCharsWithValue := EnterCharsWithValue;
    enterTextWithValue := EnterTextWithValue;
  END;

  <A NAME="Id">Id</A> = IdPublic BRANDED OBJECT
    next: Id;
    text: Text.T;
  OVERRIDES
    toText := ToText;
  END;

  <A NAME="Value">Value</A> = ValuePublic BRANDED OBJECT
    sum, sumOfSums := 0;
  OVERRIDES
    init := InitValue;
    reset := ResetValue;
    addCharToValue := AddCharToValue;
  END;

&lt;*INLINE*&gt; PROCEDURE <A NAME="InitValue"><procedure>InitValue</procedure></A>(v: Value): Value=
  BEGIN
    RETURN v;
  END InitValue;

&lt;*INLINE*&gt; PROCEDURE <A NAME="ResetValue"><procedure>ResetValue</procedure></A>(v: Value)=
  BEGIN
    v.sum := 0; v.sumOfSums := 0;
  END ResetValue;

&lt;*INLINE*&gt; PROCEDURE <A NAME="AddCharToValue"><procedure>AddCharToValue</procedure></A>(v: Value; ch: CHAR)=
  BEGIN
    v.sum := Word.Plus(v.sum, ORD(ch));
    v.sumOfSums := Word.Plus(v.sumOfSums, v.sum);
  END AddCharToValue;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Create"><procedure>Create</procedure></A>(
    t: Table;
    text: Text.T;
    VAR list: Id)
    : Id=
  BEGIN
    WITH new = t.idCreator.new(text) DO
      new.next := list;
      new.text := text;
      list := new;
      RETURN new;
    END;
  END Create;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Equal"><procedure>Equal</procedure></A>(
    t: Text.T;
    READONLY chars: ARRAY OF CHAR)
    : BOOLEAN
   =
  BEGIN
    FOR i := 0 TO LAST(chars) DO
      IF Text.GetChar(t, i) # chars[i] THEN RETURN FALSE END;
    END;
    RETURN TRUE;
  END Equal;

&lt;*INLINE*&gt; PROCEDURE <A NAME="FindChars"><procedure>FindChars</procedure></A>(
    READONLY chars: ARRAY OF CHAR;
    id: Id)
    : Id=
  BEGIN
    WHILE id # NIL DO
      IF Text.Length(id.text) = NUMBER(chars) AND Equal(id.text, chars) THEN
        EXIT;
      ELSE
        id := id.next;
      END;
    END;
    RETURN id;
  END FindChars;

PROCEDURE <A NAME="EnterCharsWithValue"><procedure>EnterCharsWithValue</procedure></A>(
    t: Table;
    v: Value;
    READONLY chars: ARRAY OF CHAR)
    : Id
   =
  BEGIN
    WITH id = t.ids[v.sumOfSums MOD t.size], found = FindChars(chars, id) DO
      IF found # NIL THEN
        RETURN found;
      ELSE
        RETURN Create(t, Text.FromChars(chars), id);
      END;
    END;
  END EnterCharsWithValue;

&lt;*INLINE*&gt; PROCEDURE <A NAME="FindText"><procedure>FindText</procedure></A>(text: Text.T; id: Id): Id=
  BEGIN
    WHILE id # NIL DO
      IF Text.Equal(id.text, text) THEN
        EXIT;
      ELSE
        id := id.next;
      END;
    END;
    RETURN id;
  END FindText;

PROCEDURE <A NAME="EnterTextWithValue"><procedure>EnterTextWithValue</procedure></A>(t: Table; v: Value; text: Text.T): Id=
  BEGIN
    WITH id = t.ids[v.sumOfSums MOD t.size], found = FindText(text, id) DO
      IF found # NIL THEN
        RETURN found;
      ELSE
        RETURN Create(t, text, id);
      END;
    END;
  END EnterTextWithValue;

&lt;*INLINE*&gt; PROCEDURE <A NAME="TextValue"><procedure>TextValue</procedure></A>(text: Text.T): Value=
  VAR
    v := NEW(Value).init();
  BEGIN
    FOR i := 0 TO Text.Length(text) - 1 DO
      AddCharToValue(v, Text.GetChar(text, i));
    END; (* for *)
    RETURN v;
  END TextValue;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Enter"><procedure>Enter</procedure></A>(t: Table; text: Text.T): Id=
  BEGIN
    RETURN EnterTextWithValue(t, TextValue(text), text);
  END Enter;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Lookup"><procedure>Lookup</procedure></A>(t: Table; text: Text.T; VAR id: Id): BOOLEAN=
  VAR
    tempId := FindText(text, t.ids[TextValue(text).sumOfSums MOD t.size]);
  BEGIN
    IF tempId # NIL THEN id := tempId; RETURN TRUE ELSE RETURN FALSE END;
  END Lookup;

TYPE
  DefaultIdCreator = IdCreator OBJECT OVERRIDES new := DefaultNewId END;

&lt;*INLINE*&gt; PROCEDURE <A NAME="DefaultNewId"><procedure>DefaultNewId</procedure></A>(&lt;*UNUSED*&gt; c: IdCreator;
                                  &lt;*UNUSED*&gt; t: Text.T): Id=
  BEGIN
    RETURN NEW(Id);
  END DefaultNewId;

&lt;*INLINE*&gt; PROCEDURE <A NAME="NewDefaultIdCreator"><procedure>NewDefaultIdCreator</procedure></A>(): DefaultIdCreator=
  BEGIN
    RETURN NEW(DefaultIdCreator);
  END NewDefaultIdCreator;

VAR
  gDefaultIdCreator := NewDefaultIdCreator();

PROCEDURE <A NAME="InitTable"><procedure>InitTable</procedure></A>(
    init: Table;
    size: CARDINAL;
    idCreator: IdCreator := NIL): Table=
  BEGIN
    IF idCreator = NIL THEN idCreator := gDefaultIdCreator END;
    init.size := size;
    init.idCreator := idCreator;
    init.ids := NEW(REF ARRAY OF Id, size);
    RETURN init;
  END InitTable;

&lt;*INLINE*&gt; PROCEDURE <A NAME="SetCreator"><procedure>SetCreator</procedure></A>(t: Table; idCreator: IdCreator): IdCreator=
  VAR
    old := t.idCreator;
  BEGIN
    t.idCreator := idCreator;
    RETURN old;
  END SetCreator;

&lt;*INLINE*&gt; PROCEDURE <A NAME="ToText"><procedure>ToText</procedure></A>(id: Id): TEXT=
  BEGIN
    RETURN id.text;
  END ToText;

BEGIN

END M3CHash.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
