<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/syn/M3CId.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/syn/M3CId.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3CId.i3">M3CId</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../../../text/src/Text.i3">Text</A>;
IMPORT <A HREF="M3CHash.i3">M3CHash</A>, <A HREF="M3CReservedWord.i3">M3CReservedWord</A>;
</PRE> This implementation uses a global hash table 

<P><PRE>VAR
  table_g := M3CReservedWord.New(10240, NewIdCreator());
  atom_g := 0;

PROCEDURE <A NAME="NewId"><procedure>NewId</procedure></A>(&lt;*UNUSED*&gt; c: M3CHash.IdCreator;
                &lt;*UNUSED*&gt; text: Text.T): M3CHash.Id RAISES {}=
  BEGIN
    INC(atom_g);
    RETURN NEW(T, atom := atom_g);
  END NewId;

PROCEDURE <A NAME="NewIdCreator"><procedure>NewIdCreator</procedure></A>(): M3CHash.IdCreator RAISES {}=
  TYPE
    IdCreator = M3CHash.IdCreator OBJECT OVERRIDES new := NewId END;
  BEGIN
    RETURN NEW(IdCreator);
  END NewIdCreator;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Table"><procedure>Table</procedure></A>(): M3CReservedWord.Table RAISES {}=
  BEGIN
    RETURN table_g;
  END Table;

&lt;*INLINE*&gt; PROCEDURE <A NAME="ToText"><procedure>ToText</procedure></A>(id: T): Text.T RAISES {}=
  BEGIN
    RETURN id.toText();
  END ToText;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Enter"><procedure>Enter</procedure></A>(text: Text.T): T RAISES {}=
  BEGIN
    RETURN table_g.enter(text);
  END Enter;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Lookup"><procedure>Lookup</procedure></A>(text: Text.T; VAR id: T): BOOLEAN RAISES {}=
  VAR
    hashId: M3CHash.Id;
  BEGIN
    IF table_g.lookup(text, hashId) THEN
      TYPECASE hashId OF
      | T(ident) =&gt; id := ident; RETURN TRUE;
      ELSE
        RETURN FALSE;
      END;
    ELSE
      RETURN FALSE;
    END;
  END Lookup;

BEGIN

END M3CId.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
