<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/syn/M3CLex.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/syn/M3CLex.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="M3CLex.m3">M3CLex</A></interface>;

IMPORT <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>;
IMPORT <A HREF="../ast/M3AST_LX.i3">M3AST_LX</A>;
IMPORT <A HREF="M3CHash.i3">M3CHash</A>, <A HREF="M3CToken.i3">M3CToken</A>, <A HREF="M3CReservedWord.i3">M3CReservedWord</A>, <A HREF="M3CSrcPos.i3">M3CSrcPos</A>;
</PRE> Lexer for Modula 3 

<P><PRE>TYPE
  <A HREF="M3CLex.m3#T">T</A> &lt;: Public;
  Public = OBJECT
  METHODS
    init(rd: Rd.T;
         identifiers: M3CReservedWord.Table;
         literals: M3CHash.Table;
         callBack: CallBack): T;
    current(): M3CToken.T;
    next(): M3CToken.T RAISES {Rd.Failure};
    position(): M3CSrcPos.T;
    literal(): Literal_rep;
    identifier(): Symbol_rep;
    disable();
    disabled(): BOOLEAN;
    reset(pos := M3CSrcPos.Null; s: Rd.T := NIL);
    currentTokenToText(): TEXT;
  END;

  CallBack = OBJECT
  METHODS
    badChar(ch: CHAR);
    comment(t: TEXT);
    pragma(t: TEXT);
    whiteSpace(t: TEXT);
  END;
</PRE> A <CODE>CallBack</CODE> object is used by the lexer to notify the caller of
tokens that the lexer cannot handle. <CODE>badChar(ch)</CODE> will be called for
any illegal character. <CODE>comment</CODE> will be called for each comment, with
the comment text in <CODE>c</CODE> , <CODE>pragma</CODE> will be called for each pragma
with the pragma text in <CODE>p</CODE>, and <CODE>whiteSpace</CODE> will be called
with the white space between tokens. 

<P>  <PRE>Symbol_rep = M3AST_LX.Symbol_rep;      (* Represents an identifier *)
  Literal_rep = M3AST_LX.Literal_rep;    (* Represents a numeric, character *)
                                         (* or text literal *)

REVEAL
  Symbol_rep &lt;: M3CHash.Id;              (* Identifiers and literals are *)
  Literal_rep &lt;: M3CHash.Id;             (* both stored in hash tables *)
</PRE> <CODE>New(T).init: creates a new lexer. The lexer will read from the
given reader'rd'. Any identifiers found will be put into the
</CODE>identifiers<CODE> hash table. Note that this table already contains all
the reserved words; hence only one hash lookup/entry operation is
needed for a reserved word or identifier.  Any literals found will be
put in the </CODE>literals<CODE> hash table.  The appropriate </CODE>callBack<CODE> method
will be called when a bad character, comment, pragma or whitespace is found. 
<P>
</CODE>current<CODE> returns the current token. </CODE>next<CODE> 
advances to the next token and then returns the (new) current token. 
</CODE>position<CODE> returns the current position of the lexer encoded
as an </CODE>M3CSrcPos.T<CODE>. 
<P>
</CODE>literal<CODE> returns a handle for the current literal. Literals are
represented by a hash-id for a </CODE>TEXT<CODE> that is created by the lexer.
The texts are distinguished as follows:
<P>
\begin(itemize}
\item Valid numeric literals. The text starts with a digit and ends with a hex 
      digit.
\item Valid text literals. The text starts and ends with double quote 
      character.
\item Valid character literals. The text starts and ends with single quote 
      character.
\end{itemize}
<P>
In the case of an error in a literal, for example, a based number with
one of its digits is out of range, or a text literal with a mising
closing quote, the call will return an [|it invalid literal} value.
Invalid literals always have at least one character and their first
character can be used to distinguish the literal type (numerics start
with a digit, texts with double quote, chars with single quote). They
are distinguished by the last character being inappropriate, that is
not a (hex) digit, single quote or double quote, respectively.  If
</CODE>NOT current() IN M3CToken.T.Literals<CODE> the result of </CODE>literal<CODE> is
undefined.
<P>
<P>
If </CODE>current() = M3CToken.T.Identifier<CODE>, then </CODE>identifier<CODE> returns a
unique representative for the identifier text, otherwise the result is
undefined.
<P>
</CODE>disable<CODE> disables the lexer; any call of </CODE>next<CODE> will return
</CODE>M3CToken.T.Void<CODE> and the position will not advance.
<P>
</CODE>disabled<CODE> returns TRUE if and only if the lexer is disabled.
<P>
</CODE>reset<CODE> resets the lexer. It sets the current symbol to
</CODE>M3CToken.T.Void<CODE> and enables the lexer it is disabled.  If </CODE>pos<CODE> is
not </CODE>M3CSrcPos.Null<CODE> the lexer position is set to </CODE>pos<CODE>.  If </CODE>s<CODE> is
not NIL sets the lexer stream to be </CODE>s<CODE> and sets the lexer position to
be </CODE>pos<CODE> if </CODE>pos # M3CSrcPos.Null<CODE> or line </CODE>1<CODE> offset </CODE>0<CODE> otherwise.
<P>
<P>
The </CODE>TokenToText<CODE> procedure returns a </CODE>TEXT<CODE> that describes the
</CODE>token<CODE> argument. The </CODE>currentTokenToText<CODE> methods returns a text
describing the current token; this may give more information than
</CODE>TokenToText<CODE> because it incorporates identifier names or literal
values if the token is in those classes. 

<P><PRE>PROCEDURE <A HREF="M3CLex.m3#TokenToText">TokenToText</A>(token: M3CToken.T): TEXT;

END M3CLex.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
