<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/syn/M3CLex.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/syn/M3CLex.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>M3CLex</module> EXPORTS <A HREF="M3CLex.i3"><implements>M3CLex</A></implements>, <A HREF="M3CLexF.i3"><implements>M3CLexF</A></implements>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;
IMPORT <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../../types/src/ASCII.i3">ASCII</A>, <A HREF="../misc/RdExtras.i3">RdExtras</A>;
IMPORT <A HREF="M3CToken.i3">M3CToken</A>, <A HREF="M3CHash.i3">M3CHash</A>, <A HREF="M3CReservedWord.i3">M3CReservedWord</A>, <A HREF="M3CSrcPos.i3">M3CSrcPos</A>, <A HREF="M3CLexF.i3">M3CLexF</A>;

CONST
  MaxLookahead = 3;
</PRE><BLOCKQUOTE><EM> Need three characters lookahead for lexing, for example
   3.2E+A
which is not going to parse but lexes as a real literal followed by an
identifier followed by plus followed by another identifier.
  Actual lookahead buffer allows one more character for use when disabling the
lexer </EM></BLOCKQUOTE><PRE>

REVEAL
  <A NAME="Buffer">Buffer</A> = BRANDED REF RECORD
    chars: ARRAY [0..2047] OF CHAR;
    overflow: Buffer := NIL;
  END;

REVEAL
  <A NAME="T">T</A> = M3CLexF.FriendPart BRANDED OBJECT
    currentTok := M3CToken.Void;
    isDisabled := FALSE;
    lookahead: CARDINAL := 0;
    lookaheadBuffer: ARRAY [0..MaxLookahead] OF CHAR;
  OVERRIDES
    init := Init;
    current := Current;
    next := Next;
    position := Position;
    literal := Literal;
    identifier := Identifier;
    disable := Disable;
    disabled := Disabled;
    reset := Reset;
    currentTokenToText := CurrentTokenToText;
    get := Get;
    unget := Unget;
    readId := ReadId;
    readNumericLiteral := ReadNumericLiteral;
    readCharLiteral := ReadCharLiteral;
    readTextLiteral := ReadTextLiteral;
    readCommentOrPragma := ReadCommentOrPragma;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(
    t: T;
    rd: Rd.T;
    identifiers: M3CReservedWord.Table;
    literals: M3CHash.Table;
    callBack: CallBack): T=
  BEGIN
    t.rd := rd; t. identifiers := identifiers;  t.literals := literals;
    t.callBack := callBack; t.line := 1;
    t.hashValue := NEW(M3CHash.Value).init(); t.tokenBuffer := NEW(Buffer);
    RETURN t;
  END Init;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Get"><procedure>Get</procedure></A>(t: T): CHAR RAISES {Rd.Failure, Rd.EndOfFile}=
  &lt;*FATAL Thread.Alerted*&gt;
  BEGIN
    IF t.lookahead &gt; 0 THEN
      DEC(t.lookahead);
      RETURN t.lookaheadBuffer[t.lookahead];
    ELSE
      RETURN Rd.GetChar(t.rd);
    END;
  END Get;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Unget"><procedure>Unget</procedure></A>(t: T; ch: CHAR)=
  BEGIN
    t.lookaheadBuffer[t.lookahead] := ch;
    INC(t.lookahead);
  END Unget;
</PRE> Managing the token buffer; putting characters into the buffer and building
arrays or texts from the completed buffer 

<P><PRE>PROCEDURE <A NAME="BufferToChars"><procedure>BufferToChars</procedure></A>(
    buffer: Buffer;
    length: CARDINAL)
    : REF ARRAY OF CHAR
   =
  VAR
    chars := NEW(REF ARRAY OF CHAR, length);
  BEGIN
    VAR
      mod: CARDINAL := length MOD NUMBER(buffer.chars);
      pos: CARDINAL;
    BEGIN
      IF mod = 0 THEN mod := NUMBER(buffer.chars) END;
      pos := length - mod;
      IF mod # 0 THEN
        SUBARRAY(chars^, pos, mod) := SUBARRAY(buffer.chars, 0, mod);
      END;
      WHILE pos # 0 DO
        buffer := buffer.overflow;
        DEC(pos, NUMBER(buffer.chars));
        SUBARRAY(chars^, pos, NUMBER(buffer.chars)) := buffer.chars;
      END;
    END;
    RETURN chars;
  END BufferToChars;

PROCEDURE <A NAME="BufferToText"><procedure>BufferToText</procedure></A>(buffer: Buffer; length: CARDINAL): TEXT=
  BEGIN
    IF length &lt;= NUMBER(buffer.chars) THEN
      RETURN Text.FromChars(SUBARRAY(buffer.chars, 0, length));
    ELSE
      RETURN Text.FromChars(BufferToChars(buffer, length)^);
    END;
  END BufferToText;

PROCEDURE <A NAME="AddOverflow"><procedure>AddOverflow</procedure></A>(buffer: Buffer): Buffer=
  BEGIN
    RETURN NEW(Buffer, overflow := buffer);
  END AddOverflow;

&lt;*INLINE*&gt; PROCEDURE <A NAME="BufferPut"><procedure>BufferPut</procedure></A>(
    VAR buffer: Buffer;
    pos: CARDINAL;
    ch: CHAR)
   =
  VAR
    mod: CARDINAL := pos MOD NUMBER(buffer.chars);
  BEGIN
    IF mod = 0 AND pos # 0 THEN buffer := AddOverflow(buffer) END;
    buffer.chars[mod] := ch;
  END BufferPut;

&lt;*INLINE*&gt; PROCEDURE <A NAME="HashAndBufferPut"><procedure>HashAndBufferPut</procedure></A>(
    ch: CHAR;
    hashValue: M3CHash.Value;
    VAR buffer: Buffer;
    VAR pos: CARDINAL)
   =
  BEGIN
    BufferPut(buffer, pos, ch);
    hashValue.addCharToValue(ch);
    INC(pos);
  END HashAndBufferPut;
</PRE> Reading an identifier or reserved word 

<P><PRE>&lt;*INLINE*&gt; PROCEDURE <A NAME="IdOrReservedWord"><procedure>IdOrReservedWord</procedure></A>(
    t: T;
    hashValue: M3CHash.Value;
    READONLY chars: ARRAY OF CHAR)
    : M3CToken.T
   =
  VAR
    id := t.identifiers.enterCharsWithValue(hashValue, chars);
  BEGIN
    TYPECASE id OF &lt;*NOWARN*&gt;
    | M3CReservedWord.Id(r) =&gt;
        RETURN M3CReservedWord.Token(r);
    | Symbol_rep(s) =&gt;
        t.cur_identifier := s;
        RETURN M3CToken.Identifier;
    END;
  END IdOrReservedWord;

PROCEDURE <A NAME="ReadId"><procedure>ReadId</procedure></A>(t: T; firstCh: CHAR): M3CToken.T RAISES {Rd.Failure}=
  CONST
    IdentChars = ASCII.AlphaNumerics + ASCII.Set{'_'};
  VAR
    ch := firstCh;
    hashValue := t.hashValue;
    buffer := t.tokenBuffer;
    pos: CARDINAL := 0;
  BEGIN
    hashValue.reset();
    TRY
      REPEAT
        HashAndBufferPut(ch, hashValue, buffer, pos);
        ch := Get(t);
      UNTIL NOT ch IN IdentChars;
      Unget(t, ch);
    EXCEPT
    | Rd.EndOfFile =&gt;
    END;
    INC(t.offset, pos - 1);
    IF pos &lt;= NUMBER(buffer.chars) THEN
      WITH chars = SUBARRAY(buffer.chars, 0, pos) DO
        RETURN IdOrReservedWord(t, hashValue, chars);
      END;
    ELSE
      RETURN IdOrReservedWord(t, hashValue, BufferToChars(buffer, pos)^);
    END;
  END ReadId;
</PRE> Reading numeric literals 

<P><PRE>CONST
  BadLiteralTail = &quot; (bad literal)&quot;; (* Appended to all bad literals *)

PROCEDURE <A NAME="EnterLiteral"><procedure>EnterLiteral</procedure></A>(
    t: T;
    ok: BOOLEAN;
    hashValue: M3CHash.Value;
    buffer: Buffer;
    length: CARDINAL)
   =
  BEGIN
    IF NOT ok THEN
      FOR i := 0 TO Text.Length(BadLiteralTail) - 1 DO
        HashAndBufferPut(
            Text.GetChar(BadLiteralTail, i), hashValue, buffer, length);
      END;
    END;
    IF length &lt;= NUMBER(buffer.chars) THEN
      WITH chars = SUBARRAY(buffer.chars, 0, length) DO
        t.cur_literal := t.literals.enterCharsWithValue(hashValue, chars);
      END;
    ELSE
      t.cur_literal := t.literals.enterCharsWithValue(
          hashValue, BufferToChars(buffer, length)^);
    END;
  END EnterLiteral;

PROCEDURE <A NAME="CheckedGet"><procedure>CheckedGet</procedure></A>(t: T; VAR eof: BOOLEAN): CHAR RAISES {Rd.Failure}=
  BEGIN
    TRY
      eof := FALSE;
      RETURN Get(t);
    EXCEPT
    | Rd.EndOfFile =&gt;
        eof := TRUE;
        RETURN '\000';
    END;
  END CheckedGet;

PROCEDURE <A NAME="CalculateBase"><procedure>CalculateBase</procedure></A>(buffer: Buffer; pos: CARDINAL): CARDINAL=
  VAR
    mod := pos MOD NUMBER(buffer.chars);
    val := ORD(buffer.chars[mod]) - ORD('0');
  BEGIN
    IF pos &gt; 0 THEN
      IF mod = 0 THEN buffer := buffer.overflow END;
      INC(val, CalculateBase(buffer, pos - 1) * 10);
    END;
    RETURN val;
  END CalculateBase;

PROCEDURE <A NAME="HexValue"><procedure>HexValue</procedure></A>(ch: CHAR; VAR val: CARDINAL): BOOLEAN=
  BEGIN
    IF 'a' &lt;= ch AND ch &lt;= 'z' THEN
      val := ORD(ch) - ORD('a') + 10;
      RETURN TRUE;
    ELSIF 'A' &lt;= ch AND ch &lt;= 'Z' THEN
      val := ORD(ch) - ORD('A') + 10;
      RETURN TRUE;
    ELSIF '0' &lt;= ch AND ch &lt;= '9' THEN
      val := ORD(ch) - ORD('0');
      RETURN TRUE;
    ELSE
      RETURN FALSE;
    END; (* if *)
  END HexValue;

PROCEDURE <A NAME="ReadHexDigits"><procedure>ReadHexDigits</procedure></A>(
    t: T;
    hashValue: M3CHash.Value;
    VAR buffer: Buffer;
    VAR pos: CARDINAL)
    : BOOLEAN
    RAISES {Rd.Failure}=
  VAR
    start := pos;
    eof: BOOLEAN;
    ch := CheckedGet(t, eof);
    val, base: CARDINAL;
    ok := TRUE;
  BEGIN
    IF HexValue(ch, val) THEN
      IF pos &gt; 2 THEN
        base := 17; (* will force error; saves worry about overflow *)
      ELSE
        base := CalculateBase(buffer, pos - 1);
      END;
      IF 2 &gt; base OR base &gt; 16 THEN base := 16; ok := FALSE END;
      HashAndBufferPut('_', hashValue, buffer, pos);
      REPEAT
        IF val &gt;= base THEN ok := FALSE END;
        HashAndBufferPut(ch, hashValue, buffer, pos);
        ch := CheckedGet(t, eof);
      UNTIL NOT HexValue(ch, val);
    END;
    IF NOT eof THEN Unget(t, ch) END;
    IF pos = start THEN Unget(t, '_') END;
    RETURN ok;
  END ReadHexDigits;

PROCEDURE <A NAME="ReadExponent"><procedure>ReadExponent</procedure></A>(
    t: T;
    exponent: CHAR;
    hashValue: M3CHash.Value;
    VAR buffer: Buffer;
    VAR pos: CARDINAL)
    : M3CToken.T
    RAISES {Rd.Failure}=
  VAR
    sign := '\000';
    eof: BOOLEAN;
    ch := CheckedGet(t, eof);
  BEGIN
    IF ch = '-' OR ch = '+' THEN
      sign := ch;
      ch := CheckedGet(t, eof);
    END;
    IF ch IN ASCII.Digits THEN
      HashAndBufferPut(exponent, hashValue, buffer, pos);
      IF sign # '\000' THEN
        HashAndBufferPut(sign, hashValue, buffer, pos);
      END;
      REPEAT
        HashAndBufferPut(ch, hashValue, buffer, pos);
        ch := CheckedGet(t, eof);
      UNTIL NOT ch IN ASCII.Digits;
      IF NOT eof THEN Unget(t, ch) END;
      IF ASCII.Upper[exponent] = 'D' THEN
        RETURN M3CToken.LongRealLiteral;
      ELSIF ASCII.Upper[exponent] = 'X' THEN
        RETURN M3CToken.ExtendedLiteral;
      ELSE
        RETURN M3CToken.RealLiteral;
      END;
    ELSE
      IF NOT eof THEN Unget(t, ch) END;
      IF sign # '\000' THEN Unget(t, sign) END;
      Unget(t, exponent);
      RETURN M3CToken.RealLiteral;
    END;
  END ReadExponent;

PROCEDURE <A NAME="ReadRealOrRange"><procedure>ReadRealOrRange</procedure></A>(
    t: T;
    hashValue: M3CHash.Value;
    VAR buffer: Buffer;
    VAR pos: CARDINAL)
    : M3CToken.T
    RAISES {Rd.Failure}=
  VAR
    eof: BOOLEAN;
    ch := CheckedGet(t, eof);
  BEGIN
    IF ch IN ASCII.Digits THEN
      HashAndBufferPut('.', hashValue, buffer, pos);
      REPEAT
        HashAndBufferPut(ch, hashValue, buffer, pos);
        ch := CheckedGet(t, eof);
      UNTIL NOT ch IN ASCII.Digits;
      IF ch IN ASCII.Set{'D', 'd', 'E', 'e', 'X', 'x'} THEN
        RETURN ReadExponent(t, ch, hashValue, buffer, pos);
      ELSE
        IF NOT eof THEN Unget(t, ch) END;
        RETURN M3CToken.RealLiteral;
      END;
    ELSE
      Unget(t, ch);
      Unget(t, '.');
      RETURN M3CToken.IntegerLiteral;
    END;
  END ReadRealOrRange;

PROCEDURE <A NAME="ReadNumericLiteral"><procedure>ReadNumericLiteral</procedure></A>(
    t: T;
    firstCh: CHAR)
    : M3CToken.T
    RAISES {Rd.Failure}=
  VAR
    ch := firstCh;
    hashValue := t.hashValue;
    buffer := t.tokenBuffer;
    pos: CARDINAL := 0;
    result := M3CToken.IntegerLiteral;
    ok := TRUE;
  BEGIN
    hashValue.reset();
    TRY
      REPEAT
        HashAndBufferPut(ch, hashValue, buffer, pos);
        ch := Get(t);
      UNTIL NOT ch IN ASCII.Digits;
      IF ch = '_' THEN
        ok := ReadHexDigits(t, hashValue, buffer, pos);
      ELSIF ch = '.' THEN
        result := ReadRealOrRange(t, hashValue, buffer, pos);
      ELSE
        Unget(t, ch);
      END;
    EXCEPT
    | Rd.EndOfFile =&gt;
    END;
    INC(t.offset, pos - 1);
    EnterLiteral(t, ok, hashValue, buffer, pos);
    RETURN result;
  END ReadNumericLiteral;
</PRE> Reading character and text literals 

<P><PRE>PROCEDURE <A NAME="ReadEscape"><procedure>ReadEscape</procedure></A>(
    t: T;
    hashValue: M3CHash.Value;
    VAR buffer: Buffer;
    VAR pos: CARDINAL)
    : BOOLEAN
    RAISES {Rd.Failure, Rd.EndOfFile}=
  CONST
    OctalDigits = ASCII.Set{'0'..'7'};
    ValidEscapes = ASCII.Set{
        'n', 't', 'r', 'f', '\\', '\'', '\&quot;'} +
        OctalDigits;
  VAR
    ch: CHAR;
  BEGIN
    ch := Get(t);
    IF ch IN ValidEscapes THEN
      HashAndBufferPut(ch, hashValue, buffer, pos);
      IF ch IN OctalDigits THEN
        FOR i := 1 TO 2 DO
          ch := Get(t);
          IF ch IN OctalDigits THEN
            HashAndBufferPut(ch, hashValue, buffer, pos);
          ELSE
            Unget(t, ch);
            RETURN FALSE;
          END;
        END;
      END;
      RETURN TRUE;
    ELSE
      Unget(t, ch);
      RETURN FALSE;
    END;
  END ReadEscape;

PROCEDURE <A NAME="ReadCharLiteral"><procedure>ReadCharLiteral</procedure></A>(t: T): M3CToken.T RAISES {Rd.Failure}=
  VAR
    ch: CHAR;
    hashValue := t.hashValue;
    buffer := t.tokenBuffer;
    pos: CARDINAL := 0;
    ok := TRUE;
  BEGIN
    hashValue.reset();
    HashAndBufferPut('\'', hashValue, buffer, pos);
    TRY
      ch := Get(t);
      IF ch IN ASCII.Graphics - ASCII.Set{'\''} THEN
        HashAndBufferPut(ch, hashValue, buffer, pos);
        IF ch = '\\' THEN
          ok := ReadEscape(t, hashValue, buffer, pos);
        END;
        ch := Get(t);
        IF ch = '\'' THEN
          HashAndBufferPut(ch, hashValue, buffer, pos);
        ELSE
          Unget(t, ch);
          ok := FALSE;
        END;
      ELSE
        Unget(t, ch);
        ok := FALSE;
      END;
    EXCEPT
    | Rd.EndOfFile =&gt; ok := FALSE;
    END;
    INC(t.offset, pos - 1);
    EnterLiteral(t, ok, hashValue, buffer, pos);
    RETURN M3CToken.CharLiteral;
  END ReadCharLiteral;

PROCEDURE <A NAME="ReadTextLiteral"><procedure>ReadTextLiteral</procedure></A>(t: T): M3CToken.T RAISES {Rd.Failure}=
  VAR
    ch: CHAR;
    hashValue := t.hashValue;
    buffer := t.tokenBuffer;
    pos: CARDINAL := 0;
    ok := TRUE;
  BEGIN
    hashValue.reset();
    HashAndBufferPut('\&quot;', hashValue, buffer, pos);
    TRY
      LOOP
        ch := Get(t);
        IF ch IN ASCII.Graphics THEN
          HashAndBufferPut(ch, hashValue, buffer, pos);
          IF ch = '\\' THEN
            IF NOT ReadEscape(t, hashValue, buffer, pos) THEN ok := FALSE END;
          ELSIF ch = '\&quot;' THEN
            EXIT;
          ELSE
            (* loop *)
          END;
        ELSE
          Unget(t, ch);
          ok := FALSE;
          EXIT;
        END;
      END;
    EXCEPT
    | Rd.EndOfFile =&gt; ok := FALSE;
    END;
    INC(t.offset, pos - 1);
    EnterLiteral(t, ok, hashValue, buffer, pos);
    RETURN M3CToken.TextLiteral;
  END ReadTextLiteral;
</PRE> Comments and pragmas 

<P><PRE>PROCEDURE <A NAME="ReadCommentOrPragmaSection"><procedure>ReadCommentOrPragmaSection</procedure></A>(
    t: T;
    READONLY endOfSection: ASCII.Set;
    VAR buffer: Buffer;
    VAR pos: CARDINAL)
    : CHAR
    RAISES {Rd.Failure, Rd.EndOfFile}=
  &lt;*FATAL Thread.Alerted *&gt;
  BEGIN
    WITH n = NUMBER(buffer.chars) DO
      LOOP
        VAR
          mod: CARDINAL := pos MOD n;
          wanted: CARDINAL := n - mod;
          got: CARDINAL;
        BEGIN
          IF mod = 0 AND pos # 0 THEN buffer := AddOverflow(buffer) END;
          got := RdExtras.GetUntil(t.rd,
              SUBARRAY(buffer.chars, mod, wanted), endOfSection);
          INC(pos, got);
          IF got &gt; wanted THEN
            (* buffer overflow - loop to get new overflow section added *)
            DEC(pos);
          ELSE
            VAR
              save: Buffer := NIL;
            BEGIN
              IF mod = 0 AND got = 0 AND pos # 0 THEN
                (* new overflow section is empty and may not be needed if we
                 hit end of stream *)
                save := buffer;
                buffer := save.overflow;
              END;
              WITH ch = Rd.GetChar(t.rd) DO
                IF save # NIL THEN
                  save.chars[0] := ch;
                  buffer := save;
                ELSE
                  BufferPut(buffer, pos, ch);
                END;
                INC(pos);
                RETURN ch;
              END;
            END;
          END;
        END;
      END;
    END;
  END ReadCommentOrPragmaSection;

PROCEDURE <A NAME="ReadCommentOrPragma"><procedure>ReadCommentOrPragma</procedure></A>(t: T; isComment: BOOLEAN) RAISES {Rd.Failure}=
  &lt;*FATAL Thread.Alerted*&gt;
  VAR
    nesting := 0;
    pos: CARDINAL := 2;
    startOfLine := pos - t.offset;
    startChar, endChar, ch: CHAR;
    endOfSection: ASCII.Set;
    buffer := t.tokenBuffer;
  CONST
    EndOfLine = ASCII.Set{'\n', '\r', '\f'};
  BEGIN
    IF isComment THEN
      startChar := '(';
      endChar := ')';
      endOfSection := EndOfLine + ASCII.Set{'(', '*'};
    ELSE
      startChar := '&lt;';
      endChar := '&gt;';
      endOfSection := EndOfLine + ASCII.Set{'&lt;', '*'};
    END;

    BufferPut(buffer, 0, startChar);
    BufferPut(buffer, 1, '*');
    (* we know the lookahead buffer is empty at this point so we can safely
     use 'ReadCommentSection' which ignores the lookahead buffer *)
    TRY
      REPEAT
        ch := ReadCommentOrPragmaSection(t, endOfSection, buffer, pos);
        REPEAT
          VAR
            next: CHAR;
          BEGIN
            IF ch # startChar AND ch # '*' THEN
              (* must be newline *)
              INC(t.linesInToken);
              startOfLine := pos;
            END;
            next := Rd.GetChar(t.rd);
            BufferPut(buffer, pos, next); INC(pos);
            IF ch = startChar THEN
              IF next = '*' THEN INC(nesting); EXIT END;
            ELSIF ch = '*' THEN
              IF next = endChar THEN DEC(nesting); EXIT END;
            END;
            ch := next;
          END;
        UNTIL NOT ch IN endOfSection;
      UNTIL nesting &lt; 0;
    EXCEPT
    | Rd.EndOfFile =&gt;
    END;
    WITH text = BufferToText(buffer, pos) DO
      INC(t.line, t.linesInToken);
      t.offset := pos - startOfLine;
      IF startChar = '(' THEN
        t.callBack.comment(text);
      ELSE
        t.callBack.pragma(text);
      END;
    END;
    t.linesInToken := 0;
  END ReadCommentOrPragma;
</PRE> Get next token 

<P><PRE>PROCEDURE <A NAME="GetNext"><procedure>GetNext</procedure></A>(t: T) RAISES {Rd.Failure}=
  VAR
    ch: CHAR;
  BEGIN
    TRY
      t.linesInToken := 0;
      t.currentTok := M3CToken.Void;
      LOOP
        t.startOfToken := t.offset;
        ch := Get(t); INC(t.offset);
        CASE ch OF
        | '\t', ' ', '\013', '\f' =&gt;
        | '\n', '\r' =&gt;
            INC(t.line);
            t.offset := 0;
        | 'A'..'Z', 'a'..'z' =&gt;
            t.currentTok := ReadId(t, ch);
            EXIT;
        | '0'..'9'=&gt;
            t.currentTok := ReadNumericLiteral(t, ch);
            EXIT;
        | '\'' =&gt;
            t.currentTok := ReadCharLiteral(t);
            EXIT;
        | '\&quot;' =&gt;
            t.currentTok := ReadTextLiteral(t);
            EXIT;
        | '+' =&gt;
            t.currentTok := M3CToken.Plus;
            EXIT;
        | '-' =&gt;
            t.currentTok := M3CToken.Minus;
            EXIT;
        | '*' =&gt;
            t.currentTok := M3CToken.Times;
            EXIT;
        | '/' =&gt;
            t.currentTok := M3CToken.Divide;
            EXIT;
        | '&lt;' =&gt;
            t.currentTok := M3CToken.LessThan;
            ch := Get(t); INC(t.offset);
            IF ch = '=' THEN
              t.currentTok := M3CToken.LessThanOrEqual;
              EXIT;
            ELSIF ch = ':' THEN
              t.currentTok := M3CToken.Subtype;
              EXIT;
            ELSIF ch = '*' THEN
              ReadCommentOrPragma(t, IsPragma);
            ELSE
              Unget(t, ch); DEC(t.offset);
              EXIT;
            END; (* if *)
        | '&gt;' =&gt;
            ch := Get(t); INC(t.offset);
            IF ch = '=' THEN
              t.currentTok := M3CToken.GreaterThanOrEqual;
            ELSE
              Unget(t, ch); DEC(t.offset);
              t.currentTok := M3CToken.GreaterThan;
            END; (* if *)
            EXIT;
        | '#' =&gt;
            t.currentTok := M3CToken.NotEqual;
            EXIT;
        | '=' =&gt;
            t.currentTok := M3CToken.Equal;
            ch := Get(t); INC(t.offset);
            IF ch = '&gt;' THEN
              t.currentTok := M3CToken.Implies;
            ELSE
              Unget(t, ch); DEC(t.offset);
            END; (* if *)
            EXIT;
        | '{' =&gt;
            t.currentTok := M3CToken.CurlyBra;
            EXIT;
        | '}' =&gt;
            t.currentTok := M3CToken.CurlyKet;
            EXIT;
        | '[' =&gt;
            t.currentTok := M3CToken.SquareBra;
            EXIT;
        | ']' =&gt;
            t.currentTok := M3CToken.SquareKet;
            EXIT;
        | '(' =&gt;
            t.currentTok := M3CToken.Bra;
            ch := Get(t); INC(t.offset);
            IF ch = '*' THEN
              ReadCommentOrPragma(t, IsComment);
            ELSE
              Unget(t, ch); DEC(t.offset);
              EXIT;
            END; (* if *)
        | ')' =&gt;
            t.currentTok := M3CToken.Ket;
            EXIT;
        | ';' =&gt;
            t.currentTok := M3CToken.Semicolon;
            EXIT;
        | '|' =&gt;
            t.currentTok := M3CToken.Bar;
            EXIT;
        | '^' =&gt;
            t.currentTok := M3CToken.Dereference;
            EXIT;
        | '.' =&gt;
            t.currentTok := M3CToken.Dot;
            ch := Get(t); INC(t.offset);
            IF ch = '.' THEN
              t.currentTok := M3CToken.Range;
            ELSE
              Unget(t, ch); DEC(t.offset);
            END; (* if *)
            EXIT;
        | ':' =&gt;
            t.currentTok := M3CToken.Colon;
            ch := Get(t); INC(t.offset);
            IF ch = '=' THEN
              t.currentTok := M3CToken.Becomes;
            ELSE
              Unget(t, ch); DEC(t.offset);
            END; (* if *)
            EXIT;
        | ',' =&gt;
            t.currentTok := M3CToken.Comma;
            EXIT;
        | '&amp;' =&gt;
            t.currentTok := M3CToken.Ampersand;
            EXIT;
        ELSE
          IF t.isDisabled THEN
            Unget(t, '\000'); DEC(t.offset);
            EXIT;
          ELSE
            t.callBack.badChar(ch);
          END;
        END; (* case *)
      END;
    EXCEPT
    | Rd.EndOfFile =&gt;
    END;
  END GetNext;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Current"><procedure>Current</procedure></A>(t: T): M3CToken.T=
  BEGIN
    RETURN t.currentTok;
  END Current;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Next"><procedure>Next</procedure></A>(t: T): M3CToken.T RAISES {Rd.Failure}=
  BEGIN
    GetNext(t);
    RETURN t.currentTok
  END Next;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Position"><procedure>Position</procedure></A>(t: T): M3CSrcPos.T=
  BEGIN
    RETURN M3CSrcPos.Pack(t.line - t.linesInToken, t.startOfToken);
  END Position;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Literal"><procedure>Literal</procedure></A>(t: T): Literal_rep=
  BEGIN
    RETURN t.cur_literal;
  END Literal;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Identifier"><procedure>Identifier</procedure></A>(t: T): Symbol_rep=
  BEGIN
    RETURN t.cur_identifier;
  END Identifier;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A>(t: T; pos := M3CSrcPos.Null; s: Rd.T := NIL)=
  BEGIN
    IF s # NIL THEN
      t.rd := s;
      IF pos = M3CSrcPos.Null THEN
        t.line := 1; t.offset := 0;
      END;
    END;
    IF pos # M3CSrcPos.Null THEN
      t.line := M3CSrcPos.Unpack(pos, t.offset);
    END;
    t.currentTok := M3CToken.Void;
    t.cur_identifier := NIL;
    t.cur_literal := NIL;
    t.isDisabled := FALSE;
    t.linesInToken := 0;
    t.startOfToken := 0;
    t.lookahead := 0;
  END Reset;

PROCEDURE <A NAME="Disable"><procedure>Disable</procedure></A>(t: T)=
  BEGIN
    Unget(t, '\000');
    t.isDisabled := TRUE;
  END Disable;

PROCEDURE <A NAME="Disabled"><procedure>Disabled</procedure></A>(t: T): BOOLEAN=
  BEGIN
    RETURN t.isDisabled;
  END Disabled;

PROCEDURE <A NAME="TokenToText"><procedure>TokenToText</procedure></A>(token: M3CToken.T): TEXT=
  BEGIN
    CASE token OF &lt;*NOWARN*&gt;
    | ORD(FIRST(M3CToken.ReservedWord))..ORD(LAST(M3CToken.ReservedWord)) =&gt;
        RETURN M3CToken.Texts[VAL(token, M3CToken.E)];
    | M3CToken.Identifier =&gt;
        RETURN &quot;identifier&quot;
    | M3CToken.CharLiteral =&gt;
        RETURN &quot;char literal&quot;;
    | M3CToken.TextLiteral =&gt;
        RETURN &quot;text literal&quot;;
    | M3CToken.IntegerLiteral =&gt;
        RETURN &quot;integer literal&quot;;
    | M3CToken.RealLiteral =&gt;
        RETURN &quot;real literal&quot;;
    | M3CToken.LongRealLiteral =&gt;
        RETURN &quot;longreal literal&quot;;
    | M3CToken.ExtendedLiteral =&gt;
        RETURN &quot;extended literal&quot;;
    | M3CToken.Plus =&gt;
        RETURN &quot;\'+\'&quot;;
    | M3CToken.Minus =&gt;
        RETURN &quot;\'-\'&quot;;
    | M3CToken.Times =&gt;
        RETURN &quot;\'*\'&quot;;
    | M3CToken.Divide =&gt;
        RETURN &quot;\'/\'&quot;;
    | M3CToken.Equal =&gt;
        RETURN &quot;\'=\'&quot;;
    | M3CToken.NotEqual =&gt;
        RETURN &quot;\'#\'&quot;;
    | M3CToken.LessThan =&gt;
        RETURN &quot;\'&lt;\'&quot;;
    | M3CToken.GreaterThan =&gt;
        RETURN &quot;\'&gt;\'&quot;;
    | M3CToken.LessThanOrEqual =&gt;
        RETURN &quot;\'&lt;=\'&quot;;
    | M3CToken.GreaterThanOrEqual =&gt;
        RETURN &quot;\'&gt;=\'&quot;;
    | M3CToken.Ampersand =&gt;
        RETURN &quot;\'&amp;\'&quot;;
    | M3CToken.Dereference =&gt;
        RETURN &quot;\'^\'&quot;;
    | M3CToken.Dot =&gt;
        RETURN &quot;\'.\'&quot;;
    | M3CToken.Bra =&gt;
        RETURN &quot;\'(\'&quot;;
    | M3CToken.Ket =&gt;
        RETURN &quot;\')\'&quot;;
    | M3CToken.CurlyBra =&gt;
        RETURN &quot;\'{\'&quot;;
    | M3CToken.CurlyKet =&gt;
        RETURN &quot;\'}\'&quot;;
    | M3CToken.SquareBra =&gt;
        RETURN &quot;\'[\'&quot;;
    | M3CToken.SquareKet =&gt;
        RETURN &quot;\']\'&quot;;
    | M3CToken.Becomes =&gt;
        RETURN &quot;\':=\'&quot;;
    | M3CToken.Semicolon =&gt;
        RETURN &quot;\';\'&quot;;
    | M3CToken.Comma =&gt;
        RETURN &quot;\',\'&quot;;
    | M3CToken.Colon =&gt;
        RETURN &quot;\':\'&quot;;
    | M3CToken.Bar =&gt;
        RETURN &quot;\'|\'&quot;;
    | M3CToken.Range =&gt;
        RETURN &quot;\'..\'&quot;;
    | M3CToken.Subtype =&gt;
        RETURN &quot;\'&lt;:\'&quot;;
    | M3CToken.Implies =&gt;
        RETURN &quot;\'=&gt;\'&quot;;
    | M3CToken.Void =&gt;
        RETURN &quot;end of stream&quot;;
    END; (* case *)
  END TokenToText;

PROCEDURE <A NAME="CurrentTokenToText"><procedure>CurrentTokenToText</procedure></A>(t: T): TEXT=
  VAR
    text := TokenToText(t.currentTok);
  BEGIN
    CASE t.currentTok OF
    | M3CToken.Identifier =&gt;
        text := Fmt.F(&quot;identifier \'%s\'&quot;, t.cur_identifier.toText());
    | ORD(FIRST(M3CToken.Literal))..ORD(LAST(M3CToken.Literal)) =&gt;
        text := Fmt.F(&quot;%s %s&quot;, text, t.cur_literal.toText());
    ELSE
    END;
    RETURN text;
  END CurrentTokenToText;

BEGIN
END M3CLex.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
