<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/syn/M3CLexF.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/syn/M3CLexF.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="M3CLex.m3">M3CLexF</A></interface>;
</PRE> Friends interface for <CODE>M3CLex</CODE> 

<P><PRE>IMPORT <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>;
IMPORT <A HREF="../ast/M3AST_LX.i3">M3AST_LX</A>, <A HREF="M3CToken.i3">M3CToken</A>, <A HREF="M3CReservedWord.i3">M3CReservedWord</A>, <A HREF="M3CHash.i3">M3CHash</A>, <A HREF="M3CLex.i3">M3CLex</A>;

TYPE FriendPart = M3CLex.Public OBJECT
    rd: Rd.T := NIL;
    identifiers: M3CReservedWord.Table;
    literals: M3CHash.Table;
    cur_identifier: M3AST_LX.Symbol_rep := NIL;
    cur_literal: M3AST_LX.Literal_rep := NIL;
    line, offset, startOfToken, linesInToken: CARDINAL := 0;
    callBack: M3CLex.CallBack := NIL;
    tokenBuffer: Buffer;
    hashValue: M3CHash.Value := NIL;
  METHODS
    get(): CHAR RAISES {Rd.Failure, Rd.EndOfFile};
    unget(ch: CHAR);
    readId(firstCh: CHAR): M3CToken.T RAISES {Rd.Failure};
    readNumericLiteral(firstCh: CHAR): M3CToken.T RAISES {Rd.Failure};
    readCharLiteral(): M3CToken.T RAISES {Rd.Failure};
    readTextLiteral(): M3CToken.T RAISES {Rd.Failure};
    readCommentOrPragma(isComment: BOOLEAN) RAISES {Rd.Failure};
  END;

REVEAL M3CLex.T &lt;: FriendPart;

CONST
  IsComment = TRUE;
  IsPragma = FALSE;
</PRE> The <CODE>get</CODE> method returns the next character from the lookahead buffer,
raising <CODE>Rd.EndOfFile</CODE> if the stream is exhausted. <CODE>unget(ch)</CODE> puts
<CODE>ch</CODE> into the lookahead buffer, causing <CODE>get</CODE> to return it the next time
it is called. Multiple calls without an intervening <CODE>get</CODE> have no
effect. 
<P>
The <CODE>readId</CODE> method reads an identifier that begins with <CODE>firstCh</CODE>.
If the identifier correspsonds to a reserved word, the associated 
<CODE>M3CToken.T</CODE> value is returned, otherwise <CODE>M3CToken.T.Identifier</CODE>
is returned and the <CODE>identifier</CODE> field is set to the <CODE>Symbol_rep</CODE>
for the identifier.
<P>
The <CODE>readNumericLiteral</CODE> method reads a numeric literal that starts
with firstCh, returning the appropriate value of <CODE>M3CToken.T</CODE>, and
setting the <CODE>literal</CODE> field to the <CODE>Literal_rep</CODE> value for the
literal.
<P>
<CODE>readCharLiteral</CODE> and <CODE>readTextLiteral</CODE> read character literals and
text literals, respectively, and assume that the leading quote or
double-quote character has already been consumed. The value of the
<CODE>literal</CODE> field is set to the <CODE>Literal_rep</CODE> value for the literal.
<P>
<CODE>readCommentOrPragma</CODE> assumes that the leading <CODE>(</CODE> or <CODE>&lt;</CODE> character
has been consumed and tenh attempts to process the remainder of the
comment or pragma, calling the <CODE>callback</CODE> method with the result. 

<P> Manipulating the token buffer directly. Call these procedures with
   <CODE>buffer</CODE> = <CODE>t.tokenBuffer</CODE>. 

<P><PRE>TYPE
  <A HREF="M3CLex.m3#Buffer">Buffer</A> &lt;: REFANY;

PROCEDURE <A HREF="M3CLex.m3#BufferToText">BufferToText</A>(buffer: Buffer; length: CARDINAL): TEXT RAISES {};
</PRE><BLOCKQUOTE><EM> converts <CODE>length</CODE> chars from <CODE>buffer</CODE> to a TEXT and returns the result. </EM></BLOCKQUOTE><PRE>

&lt;*INLINE*&gt; PROCEDURE <A HREF="M3CLex.m3#BufferPut">BufferPut</A>(
    VAR buffer: Buffer;
    pos: CARDINAL;
    ch: CHAR) RAISES {};
</PRE><BLOCKQUOTE><EM> Stores <CODE>ch</CODE> as position <CODE>pos</CODE> in <CODE>buffer</CODE>, possibly adding an overflow
   area (hence VAR). </EM></BLOCKQUOTE><PRE>

&lt;*INLINE*&gt; PROCEDURE <A HREF="M3CLex.m3#HashAndBufferPut">HashAndBufferPut</A>(
    ch: CHAR;
    hashValue: M3CHash.Value;
    VAR buffer: Buffer;
    VAR pos: CARDINAL)
    RAISES {};
</PRE><BLOCKQUOTE><EM> As <CODE>BuffePut</CODE>, but also calls <CODE>M3CHash.AddCharToValue(ch, hashValue)</CODE>
   and increments <CODE>pos</CODE>. </EM></BLOCKQUOTE><PRE>

END M3CLexF.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
