<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/syn/M3CLiteral.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/syn/M3CLiteral.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3CLiteral.i3">M3CLiteral</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../../../text/src/Text.i3">Text</A>;
IMPORT <A HREF="../ast/M3AST_LX.i3">M3AST_LX</A>, <A HREF="M3CHash.i3">M3CHash</A>;

REVEAL
  M3AST_LX.<A NAME="Number_rep">Number_rep</A> = T BRANDED OBJECT END;
  M3AST_LX.<A NAME="Text_rep">Text_rep</A> = T BRANDED OBJECT END;

PROCEDURE <A NAME="NewLiteral"><procedure>NewLiteral</procedure></A>(&lt;*UNUSED*&gt; c: M3CHash.IdCreator;
                     text: Text.T): M3CHash.Id RAISES {}=
  BEGIN
    WITH ch = Text.GetChar(text, 0) DO
      IF ch = '\&quot;' OR ch = '\''  THEN
        RETURN NEW(M3AST_LX.Text_rep);
      ELSE
        RETURN NEW(M3AST_LX.Number_rep);
      END;
    END;
  END NewLiteral;

PROCEDURE <A NAME="NewLiteralCreator"><procedure>NewLiteralCreator</procedure></A>(): M3CHash.IdCreator RAISES {}=
  TYPE
    LiteralCreator = M3CHash.IdCreator OBJECT OVERRIDES new := NewLiteral END;
  BEGIN
    RETURN NEW(LiteralCreator);
  END NewLiteralCreator;

VAR
  table_g := NEW(M3CHash.Table).init(10240, NewLiteralCreator());

&lt;*INLINE*&gt; PROCEDURE <A NAME="Table"><procedure>Table</procedure></A>(): M3CHash.Table RAISES {}=
  BEGIN
    RETURN table_g;
  END Table;

&lt;*INLINE*&gt; PROCEDURE <A NAME="ToText"><procedure>ToText</procedure></A>(id: T): Text.T RAISES {}=
  BEGIN
    RETURN id.toText();
  END ToText;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Enter"><procedure>Enter</procedure></A>(text: Text.T): T RAISES {}=
  BEGIN
    RETURN table_g.enter(text);
  END Enter;

BEGIN

END M3CLiteral.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
