<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/syn/M3CParse.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/syn/M3CParse.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="M3CParse.m3">M3CParse</A></interface>;

IMPORT <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="M3CSrcPos.i3">M3CSrcPos</A>, <A HREF="M3CHash.i3">M3CHash</A>, <A HREF="M3CLex.i3">M3CLex</A>, <A HREF="M3CReservedWord.i3">M3CReservedWord</A>;
</PRE> Parser for Modula 3 

<P><PRE>TYPE
  <A HREF="M3CParse.m3#T">T</A> &lt;: Public;
  Public = OBJECT
  METHODS
    init(rd: Rd.T; identifiers: M3CReservedWord.Table;
         literals: M3CHash.Table; errorHandler: ErrorHandler;
         lexer: M3CLex.T := NIL): T;
    compilation(headerOnly := FALSE): M3AST_AS.Compilation_Unit
        RAISES {Rd.Failure};
    any(terminators := SET OF CHAR{}): REFANY RAISES {Rd.Failure};
    reset(pos := M3CSrcPos.Null; rd: Rd.T := NIL);
  END;

  ErrorHandler = OBJECT
  METHODS
    handle(pos: M3CSrcPos.T; msg: TEXT);
  END;
</PRE> The <CODE>init</CODE> method creates a new parser on the reader <CODE>rd</CODE>.
<CODE>identifiers</CODE> is the table that will be used for identifiers found
during parsing. Since it is an <CODE>M3CReservedWord.Table</CODE> it already
contains all the Modula-3 reserved words.  Any literals found will be
stored, as texts, in the <CODE>literals</CODE> table.  The <CODE>errorHandler</CODE> object
is used whenever an error occurs; the <CODE>handle</CODE> method is called with
the position of the error and a message. If <CODE>lexer</CODE> is <CODE>NIL</CODE> a default
lexer is created using the <CODE>identifiers</CODE> and <CODE>literals</CODE> tables.
Otherwise <CODE>lexer</CODE> is used and it is required that the <CODE>identifiers</CODE>
and <CODE>literals</CODE> tables are the same as were pass to the <CODE>M3CLex.T.init</CODE>
method.
<P>
The <CODE>compilation</CODE> method attempts to parse an entire compilation unit.
If the <CODE>headerOnly</CODE> flag is <CODE>TRUE</CODE> the parse is stopped after any
exports and/or import clauses have been parsed and a skeleton
compilation unit is returned. Such a skeleton may be useful for
dependency analysis. 
<P>
<P>
The <CODE>any</CODE> method attempts to parse whatever construct is next on the parse stream. The parse
finishes at a natural boundary, if end of stream is reached or if a character
in <CODE>terminators</CODE> is encountered. 
A natural boundary is rather vaguely defined. It depends on the first
symbol encountered on the parse stream. Here are the various cases. Note that
where a <CODE>list of whatever</CODE> is parsed the parse is terminated by any symbol
which cannot be the start of another <CODE>whatever</CODE>. e.g. a sequence of imports is
definitely at an end if you encounter a token which can never be in an import,
for example, the start of a declaration.
<P>
\begin{itemize}
\item
Start of unit               parse a single unit, returning a <CODE>UNIT</CODE>.
\item
Start of import statement   parse a list of <CODE>IMPORT</CODE> statements, returning a
                            <CODE>SeqM3AST_AS_IMPORTED.T</CODE>.
\item
Start of statement          parse a sequence of statements, returning a
                            <CODE>SeqM3AST_AS_STM.T</CODE>.
\item
Start of declaration        parse a sequence of declarations. If the sequence
                            is followed by <CODE>BEGIN</CODE> treat these declarations as
                            the start of a block statement - see the section on
                            statements. Otherwise return a
                            <CODE>SeqM3AST_AS_DECL_REVL.T</CODE>.
\item
Start of type               parse a single type, returning an 
                            <CODE>M3AST_AS.TYPE_SPEC</CODE>. Note that a named type cannot
                            be distinguished from an expression by the parser,
                            hence named types are parsed as expressions.
\item
Start of expression         parse a single expression. If the expression is
                            followed by <CODE>:=</CODE> treat it as the start of an
                            assignment - see the section on statements. If the
                            expression is a call and is followed by <CODE>;</CODE> treat
                            as a procedure call statement - see the section on
                            statements. Otherwise return the expression as an
                            <CODE>M3AST_AS.EXP</CODE>.
\end(itemize}
<P>
If the first symbol encountered is not the start of any of the items given
above <CODE>any</CODE> returns <CODE>NIL</CODE>. 

<P><PRE>CONST
  AnyTerminators =
      SET OF CHAR{'!', '$', '%', '?', '@', '\\', '_', '`', '~'};
</PRE> If the end of stream is encountered the parse is terminated. In
addition, if a character in the set <CODE>terminators</CODE> is encountered the
parse is terminated.  If <CODE>terminators</CODE> is not a subset of
<CODE>AnyTerminators</CODE> a checked runtime error will occur.
<P>
The <CODE>reset</CODE> method resets the lexer and optionally sets the position
and reader used by the lexer and parser. The position is significant
because many nodes have source positions and also because error
messages need positions.  If <CODE>rd</CODE> is NIL the position is only changed
if <CODE>pos</CODE> is not M3CSrcPos.Null. If <CODE>rd</CODE> is not NIL the position is
changed to <CODE>pos</CODE> if it is not <CODE>M3CSrcPos.Null</CODE> and otherwise to line 1
offset 0. 

<P><PRE>END M3CParse.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
