<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/syn/M3CPragma.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/syn/M3CPragma.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="M3CPragma.m3">M3CPragma</A></interface>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="M3CSrcPos.i3">M3CSrcPos</A>;
</PRE> The following are used by the parser to build up a pragma store. 'NewStore'
creates a new pragma store and each pragma encountered is added with the
'AddToStore' procedure. Pragmas must be added in source position order. Pragmas
must start with <CODE>&lt;*</CODE> and end with <CODE>*&gt;</CODE> 

<P><PRE>TYPE
  <A HREF="M3CPragmaF.i3#Store">Store</A> &lt;: REFANY;
  T &lt;: REFANY;

PROCEDURE <A HREF="M3CPragma.m3#NewStore">NewStore</A>(): Store RAISES {};
</PRE><BLOCKQUOTE><EM> Create new pragma store </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CPragma.m3#AddToStore">AddToStore</A>(
    body: Text.T;
    pos: M3CSrcPos.T;
    precedingNode: M3AST_AS.SRC_NODE;
    VAR store: Store)
    : T
    RAISES {};
</PRE><BLOCKQUOTE><EM> Add a new pragma to a store, giving its body, position and the preceding
source node </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CPragma.m3#AddFollowingNode">AddFollowingNode</A>(
    followingNode: M3AST_AS.SRC_NODE;
    store: Store)
    RAISES {};
</PRE><BLOCKQUOTE><EM> Called after a pragma (or pragmas) has been added by 'AddToStore' and
another source node is encountered. Marks all the pragmas after the last
source node as having the given 'followingNode' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CPragma.m3#AddPrecedingStmOrDecl">AddPrecedingStmOrDecl</A>(
    followingStmOrDecl: M3AST_AS.SRC_NODE;
    store: Store)
    RAISES {};
</PRE><BLOCKQUOTE><EM>  Called after a pragma (or pragmas) has been added by 'AddToStore' and
the end of a statement or declaration is encountered. Marks all the pragmas
after the last source node as being after the given 'stmOrDecl' </EM></BLOCKQUOTE><PRE>
</PRE> The pragmas in a pragma store can be iterated using 'NewIter' and 'Next'.
The iterator works even while the store is being built up using 'AddToStore' 

<P><PRE>TYPE
  Iter &lt;: REFANY;

PROCEDURE <A HREF="M3CPragma.m3#NewIter">NewIter</A>(ps: Store; after := M3CSrcPos.Null): Iter RAISES {};
</PRE><BLOCKQUOTE><EM> Return iterator for pragmas. They will be iterated in ascending positional
order. If 'after' is not null only the pragmas whose position is greater than
'after' will be iterated </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CPragma.m3#Next">Next</A>(VAR iter: Iter; VAR t: T): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> 'Next' returns FALSE if 'iter' is NIL </EM></BLOCKQUOTE><PRE>
</PRE> The following enquiry functions can be used on all pragmas 

<P><PRE>PROCEDURE <A HREF="M3CPragma.m3#Position">Position</A>(t: T): M3CSrcPos.T RAISES {};
</PRE><BLOCKQUOTE><EM> Source position of pragma </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CPragma.m3#Body">Body</A>(t: T): Text.T RAISES {};
</PRE><BLOCKQUOTE><EM> Text of pragma. Includes opening and closing brackets </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CPragma.m3#Match">Match</A>(t: T; keyword: Text.T; VAR args: Text.T): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> If the first word in 't' is 'keyword' returns TRUE and sets 'args' to the
remaining words in 't'. 'args' will have no leading or trailing whitespace and
can be NIL if 'keyword' is the only word in 't'.
  If the first word in 't' is not 'keyword' returns FALSE and leaves args
untouched </EM></BLOCKQUOTE><PRE>
</PRE> A pragma has a hook field from which data can be hung. It is intended for
use by the code which processes the pragma. A pragma with a NIL hook field
is assumed to be unprocessed so any code which uses a pragma e.g. binds it to
a node and processes its contents, should set the hook to a non NIL value to
let everyone know the pragma has been dealt with.
  Pragmas with NIL hook fields at the end of compilation are assumed to be
errors and a warning message will result. 

<P><PRE>PROCEDURE <A HREF="M3CPragma.m3#Hook">Hook</A>(t: T): REFANY RAISES {};
PROCEDURE <A HREF="M3CPragma.m3#SetHook">SetHook</A>(t: T; hook: REFANY) RAISES {};

PROCEDURE <A HREF="M3CPragma.m3#BeforeNode">BeforeNode</A>(
    store: Store;
    node: M3AST_AS.SRC_NODE)
    : Iter
    RAISES {};
</PRE><BLOCKQUOTE><EM> Returns an iterator which will iterate the pragmas in 'store' starting at
the first which is immediately before the given node. Returns NIL if there are
no pragmas immediately before 'node' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CPragma.m3#AfterNode">AfterNode</A>(
    store: Store;
    node: M3AST_AS.SRC_NODE)
    : Iter
    RAISES {};
</PRE><BLOCKQUOTE><EM> Returns an iterator which will iterate the pragmas in 'store' starting at
the first which is immediately after the given node. Returns NIL if there are
no pragmas immediately after 'node' </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CPragma.m3#AfterStmOrDecl">AfterStmOrDecl</A>(
    store: Store;
    stmOrDecl: M3AST_AS.SRC_NODE)
    : Iter
    RAISES {};
</PRE><BLOCKQUOTE><EM> Returns an iterator which will iterate the pragmas in 'store' starting at
the first which is immediately after the given statement, declaration or
revelation. Returns NIL if there are no pragmas immediately after 'stmOrDecl'
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CPragma.m3#PrecedingNode">PrecedingNode</A>(t: T): M3AST_AS.SRC_NODE RAISES {};
</PRE><BLOCKQUOTE><EM> Return the node which immediately precedes the given pragma, or NIL if there
is no such node </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CPragma.m3#FollowingNode">FollowingNode</A>(t: T): M3AST_AS.SRC_NODE RAISES {};
</PRE><BLOCKQUOTE><EM> Return the node which immediately follows the given pragma, or NIL if there
is no such node </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CPragma.m3#PrecedingStmOrDecl">PrecedingStmOrDecl</A>(t: T): M3AST_AS.SRC_NODE RAISES {};
</PRE><BLOCKQUOTE><EM> Return the statement, declaration or revelation which precedes the given
pragma, or NIL if there is no such node </EM></BLOCKQUOTE><PRE>
</PRE> Example of use of 'BeforeNode':
<P>
VAR
  iter := M3CPragma.BeforeNode(store, node);
  pragma: M3CPragma.T;
BEGIN
  WHILE M3CPragma.Next(iter, pragma) AND
      M3CPragma.FollowingNode(pragma) = node DO
    (* here we know that 'pragma' is immediately before 'node' 
  <PRE>END;
END;
*)

END M3CPragma.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
