<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/syn/M3CPragma.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/syn/M3CPragma.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>M3CPragma</module> EXPORTS <A HREF="M3CPragma.i3"><implements>M3CPragma</A></implements>, <A HREF="M3CPragmaF.i3"><implements>M3CPragmaF</A></implements>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../misc/TextExtras.i3">TextExtras</A>, <A HREF="../../../types/src/ASCII.i3">ASCII</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="M3CSrcPos.i3">M3CSrcPos</A>;
</PRE>*IMPORT M3AST_AS_F;*

<P><PRE>PROCEDURE <A NAME="NewStore"><procedure>NewStore</procedure></A>(): Store RAISES {}=
  BEGIN
    RETURN NEW(Store);
  END NewStore;

PROCEDURE <A NAME="AddToStore"><procedure>AddToStore</procedure></A>(
    body: Text.T;
    pos: M3CSrcPos.T;
    precedingNode: M3AST_AS.SRC_NODE;
    VAR store: Store)
    : T
    RAISES {}=
  VAR
    new := NEW(Iter, pos := pos, body := body,
        precedingNode := precedingNode);
  BEGIN
    WITH last = store.last DO
      IF last = NIL THEN
        store.first := new;
      ELSE
        last.next := new;
        new.prev := last;
      END;
      last := new;
    END;
    RETURN new;
  END AddToStore;

PROCEDURE <A NAME="AddFollowingNode"><procedure>AddFollowingNode</procedure></A>(
    followingNode: M3AST_AS.SRC_NODE;
    store: Store)
    RAISES {}=
  VAR
    t := store.last;
    precedingNode := t.precedingNode;
  BEGIN
    REPEAT
      t.followingNode := followingNode;
      t := t.prev;
    UNTIL t = NIL OR t.precedingNode # precedingNode;
  END AddFollowingNode;

PROCEDURE <A NAME="AddPrecedingStmOrDecl"><procedure>AddPrecedingStmOrDecl</procedure></A>(
    stmOrDecl: M3AST_AS.SRC_NODE;
    store: Store)
    RAISES {}=
  VAR
    t := store.last;
    precedingNode := t.precedingNode;
  BEGIN
    WHILE t # NIL AND t.precedingNode = precedingNode AND
        t.precedingStmOrDecl = NIL DO
      t.precedingStmOrDecl := stmOrDecl;
      t := t.prev;
    END;
  END AddPrecedingStmOrDecl;

PROCEDURE <A NAME="NewIter"><procedure>NewIter</procedure></A>(ps: Store; after := M3CSrcPos.Null): Iter RAISES {}=
  BEGIN
    IF ps = NIL THEN RETURN NIL END;
    IF after = M3CSrcPos.Null OR ps.first = NIL OR
        M3CSrcPos.Compare(ps.first.pos, after) &gt; 0 THEN
      RETURN ps.first;
    ELSE
      VAR
        t := ps.last;
      BEGIN
        LOOP
          IF M3CSrcPos.Compare(t.pos, after) &lt;= 0 THEN
            RETURN t.next;
          ELSE
            t := t.prev;
          END;
        END;
      END;
    END;
  END NewIter;

PROCEDURE <A NAME="Next"><procedure>Next</procedure></A>(VAR iter: Iter; VAR t: T): BOOLEAN RAISES {}=
  BEGIN
    IF iter = NIL THEN RETURN FALSE END;
    t := iter;
    iter := iter.next;
    RETURN TRUE;
  END Next;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A>(t: T): M3CSrcPos.T RAISES {}=
  BEGIN
    RETURN t.pos;
  END Position;

PROCEDURE <A NAME="Body"><procedure>Body</procedure></A>(t: T): Text.T RAISES {}=
  BEGIN
    RETURN t.body;
  END Body;

PROCEDURE <A NAME="Match"><procedure>Match</procedure></A>(t: T; keyword: Text.T; VAR args: Text.T): BOOLEAN RAISES {}=
  VAR
    body := t.body;
    pos: CARDINAL := 2;
    length := Text.Length(keyword);
    startOfClosingBracket := Text.Length(body) - 2;
  BEGIN
    IF TextExtras.FindCharSet(body, ASCII.All - ASCII.Spaces, pos) THEN
      IF pos + length &gt; startOfClosingBracket THEN RETURN FALSE END;
      FOR i := 0 TO length - 1 DO
        IF Text.GetChar(keyword, i) # Text.GetChar(body, pos + i) THEN
          RETURN FALSE;
        END;
      END;
      INC(pos, length);
      IF pos = startOfClosingBracket THEN
        args := NIL;
        RETURN TRUE;
      ELSIF NOT Text.GetChar(body, pos) IN ASCII.Spaces THEN
        RETURN FALSE
      ELSE
        INC(pos);
        IF TextExtras.FindCharSet(body, ASCII.All - ASCII.Spaces, pos) THEN
          IF pos &gt;= startOfClosingBracket THEN
            args := NIL;
          ELSE
            VAR
              end := startOfClosingBracket - 1;
            BEGIN
              WHILE Text.GetChar(body, end) IN ASCII.Spaces DO
                DEC(end);
              END;
              args := TextExtras.Extract(body, pos, end + 1);
            END;
          END; (* if *)
        END;
        RETURN TRUE;
      END; (* if *)
    ELSE
      RETURN FALSE;
    END; (* if *)
  END Match;

PROCEDURE <A NAME="Hook"><procedure>Hook</procedure></A>(t: T): REFANY RAISES {}=
  BEGIN
    RETURN t.hook;
  END Hook;

PROCEDURE <A NAME="SetHook"><procedure>SetHook</procedure></A>(t: T; hook: REFANY) RAISES {}=
  BEGIN
    t.hook := hook;
  END SetHook;

PROCEDURE <A NAME="AfterNode"><procedure>AfterNode</procedure></A>(
    store: Store;
    node: M3AST_AS.SRC_NODE)
    : Iter
    RAISES {}=
  BEGIN
    IF store = NIL THEN RETURN NIL END;
    VAR
      search := store.first;
    BEGIN
      WHILE search # NIL DO
        IF search.precedingNode = node THEN RETURN search END;
        search := search.next;
      END;
      RETURN NIL;
    END;
  END AfterNode;

PROCEDURE <A NAME="BeforeNode"><procedure>BeforeNode</procedure></A>(
    store: Store;
    node: M3AST_AS.SRC_NODE)
    : Iter
    RAISES {}=
  BEGIN
    IF store = NIL THEN RETURN NIL END;
    VAR
      search := store.first;
    BEGIN
      WHILE search # NIL DO
        IF search.followingNode = node THEN RETURN search END;
        search := search.next;
      END;
      RETURN NIL;
    END;
  END BeforeNode;

PROCEDURE <A NAME="AfterStmOrDecl"><procedure>AfterStmOrDecl</procedure></A>(
    store: Store;
    stmOrDecl: M3AST_AS.SRC_NODE)
    : Iter
    RAISES {}=
  BEGIN
    IF store = NIL THEN RETURN NIL END;
    VAR
      search := store.first;
    BEGIN
      WHILE search # NIL DO
        IF search.precedingStmOrDecl = stmOrDecl THEN RETURN search END;
        search := search.next;
      END;
      RETURN NIL;
    END;
  END AfterStmOrDecl;

PROCEDURE <A NAME="PrecedingNode"><procedure>PrecedingNode</procedure></A>(t: T): M3AST_AS.SRC_NODE RAISES {}=
  BEGIN
    RETURN t.precedingNode;
  END PrecedingNode;

PROCEDURE <A NAME="FollowingNode"><procedure>FollowingNode</procedure></A>(t: T): M3AST_AS.SRC_NODE RAISES {}=
  BEGIN
    RETURN t.followingNode;
  END FollowingNode;

PROCEDURE <A NAME="PrecedingStmOrDecl"><procedure>PrecedingStmOrDecl</procedure></A>(t: T): M3AST_AS.SRC_NODE RAISES {}=
  BEGIN
    RETURN t.precedingStmOrDecl;
  END PrecedingStmOrDecl;

BEGIN

END M3CPragma.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
