<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/target/M3CBackEnd_C_cc.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/target/M3CBackEnd_C_cc.i3</H2></A><HR>
<inInterface>
<PRE>INTERFACE <interface><A HREF="M3CBackEnd_C_cc.m3">M3CBackEnd_C_cc</A></interface>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P> This interface defines the size and alignment information that is needed
   by the C back-end.  Units are in BITS.


<P><PRE>VAR
  (* alignment of generic things of the given size with typical defaults *)

  a64: INTEGER; (* := 32 *)
  a32: INTEGER; (* := 32 *)
  a16: INTEGER; (* := 16 *)
  a8: INTEGER;  (* := 8 *)

  minAlignment: INTEGER; (* := 8 *)
  recAlignment: INTEGER; (* := 8 *)
  arrayAlignment: INTEGER; (* := 8 *)

  (* type-dependent size/alignment, with typical defaults *)

  ptrA: INTEGER; (*  = a32; *)
  ptrS: INTEGER; (* = 32; *)
  realA: INTEGER; (* = a32; *)
  realS: INTEGER; (* = 32; *)
  longRealA: INTEGER; (* = a64; *)
  longRealS: INTEGER; (* = 64; *)
  intA: INTEGER; (* = a32; *)
  intS: INTEGER; (* = 32; *)

  target: TEXT;  (* name of current target *)
</PRE> Support for registering/looking up targets 

<P><PRE>TYPE
  TargetInitProc = PROCEDURE() RAISES {};
  (* one of these sets the above variables appropriately *)

PROCEDURE <A HREF="M3CBackEnd_C_cc.m3#RegisterTarget">RegisterTarget</A>(t: TEXT; p: TargetInitProc) RAISES {};
</PRE><BLOCKQUOTE><EM> associate 'p' with target named 't'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CBackEnd_C_cc.m3#LookupTarget">LookupTarget</A>(
    t: TEXT;
    VAR (*out*) rp: REF TargetInitProc): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> look up 't' and return TRUE and set 'p' if found, else return FALSE. </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="M3CBackEnd_C_cc.m3#Iter">Iter</A> &lt;: REFANY;

PROCEDURE <A HREF="M3CBackEnd_C_cc.m3#NewIter">NewIter</A>(): Iter RAISES {};
</PRE><BLOCKQUOTE><EM> Create an iterator on the registered targets. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CBackEnd_C_cc.m3#Next">Next</A>(
    iter: Iter;
    VAR (*out*) t: TEXT;
    VAR (*out*) rp: REF TargetInitProc
    ): BOOLEAN RAISES {};
</PRE><BLOCKQUOTE><EM> Return the next target, or FALSE if exhausted. </EM></BLOCKQUOTE><PRE>

END M3CBackEnd_C_cc.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
