<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/target/M3CBackEnd_Float.mg</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/target/M3CBackEnd_Float.mg</H2></A><HR>
<inModule>
<PRE>GENERIC MODULE <genericModule><A HREF="M3CBackEnd_Float.ig">M3CBackEnd_Float</A></genericModule>(FloatType);

Copyright

IMPORT M3AST_AS, M3AST_SM, M3CStdProcs;

IMPORT M3CBackEnd, M3CBackEnd_C;
IMPORT M3CBackEnd_Float_Real, M3CBackEnd_Float_LongReal,
    M3CBackEnd_Float_Extended;

PROCEDURE <A NAME="New_value"><procedure>New_value</procedure></A>(r: FloatType.T): T RAISES {}=
  BEGIN
    RETURN NEW(T, sm_value := r);
  END New_value;

PROCEDURE <A NAME="UnaryOp"><procedure>UnaryOp</procedure></A>(
    op: M3AST_AS.UNARY;
    e: T;
    VAR (*out*) er: M3AST_SM.Exp_value)
    : M3CBackEnd.NumStatus
    RAISES {}=
  VAR r: FloatType.T;
  BEGIN
    TYPECASE op OF
    | M3AST_AS.Unaryplus =&gt;
	r := e.sm_value;
    | M3AST_AS.Unaryminus =&gt;
	r := -e.sm_value;
    ELSE
        RETURN M3CBackEnd.NumStatus.Unknown;
    END; (* case *)
    er := New_value(r);
    RETURN M3CBackEnd.NumStatus.Valid;
  END UnaryOp;

PROCEDURE <A NAME="StdUnaryOp"><procedure>StdUnaryOp</procedure></A>(
    f: M3CStdProcs.Func;
    e: T;
    VAR (*out*) er: M3AST_SM.Exp_value;
    ft: M3AST_AS.FLOAT_TYPE := NIL
    ): M3CBackEnd.NumStatus RAISES {}=
  VAR
    float: FloatType.T := e.sm_value;
  BEGIN
    CASE f OF
    | M3CStdProcs.T.Abs =&gt;
        er := New_value(ABS(float));
    | M3CStdProcs.T.Float =&gt;
        TYPECASE ft OF &lt;*NOWARN*&gt;
        | M3AST_AS.Real_type =&gt;
  	    er := M3CBackEnd_Float_Real.New_value(FLOAT(float, REAL));
        | M3AST_AS.LongReal_type =&gt;
            er := M3CBackEnd_Float_LongReal.New_value(FLOAT(float, LONGREAL));
        | M3AST_AS.Extended_type =&gt;
            er := M3CBackEnd_Float_Extended.New_value(FLOAT(float, EXTENDED));
        END; (* typecase *)

    | M3CStdProcs.T.Floor =&gt;
	er := M3CBackEnd_C.NewInteger_value(FLOOR(float));
    | M3CStdProcs.T.Ceiling =&gt;
	er := M3CBackEnd_C.NewInteger_value(CEILING(float));
    | M3CStdProcs.T.Round =&gt;
	er := M3CBackEnd_C.NewInteger_value(ROUND(float));
    | M3CStdProcs.T.Trunc =&gt;
	er := M3CBackEnd_C.NewInteger_value(TRUNC(float));
    ELSE RETURN M3CBackEnd.NumStatus.Unknown;
    END; (* case *)
    RETURN M3CBackEnd.NumStatus.Valid;
  END StdUnaryOp;

PROCEDURE <A NAME="BinaryOp"><procedure>BinaryOp</procedure></A>(
    op: M3AST_AS.BINARY;
    e1, e2: T;
    VAR (*out*) er: M3AST_SM.Exp_value)
    : M3CBackEnd.NumStatus
    RAISES {}=
  VAR
    float1 := e1.sm_value;
    float2 := e2.sm_value;
    floatr: FloatType.T;
    intr := -1;
  BEGIN
    TYPECASE op OF
    | M3AST_AS.Plus =&gt; floatr := float1 + float2;
    | M3AST_AS.Minus =&gt; floatr := float1 - float2;
    | M3AST_AS.Times =&gt; floatr := float1 * float2;
    | M3AST_AS.Rdiv =&gt; floatr := float1 / float2;
    ELSE
      TYPECASE op OF
      | M3AST_AS.Eq =&gt; intr := ORD(float1 = float2);
      | M3AST_AS.Ne =&gt; intr := ORD(float1 # float2);
      | M3AST_AS.Gt =&gt; intr := ORD(float1 &gt; float2);
      | M3AST_AS.Lt =&gt; intr := ORD(float1 &lt; float2);
      | M3AST_AS.Ge =&gt; intr := ORD(float1 &gt;= float2);
      | M3AST_AS.Le =&gt; intr := ORD(float1 &lt;= float2);
      ELSE RETURN M3CBackEnd.NumStatus.Unknown;
      END; (* case *)
    END;
    IF intr &lt; 0 THEN (* float result *)
      er := New_value(floatr);
    ELSE
      er := M3CBackEnd_C.NewInteger_value(intr);
    END;
    RETURN M3CBackEnd.NumStatus.Valid;
  END BinaryOp;

PROCEDURE <A NAME="StdBinaryOp"><procedure>StdBinaryOp</procedure></A>(f: M3CStdProcs.Func;
    e1, e2: T;
    VAR (*out*) er: M3AST_SM.Exp_value): M3CBackEnd.NumStatus RAISES {}=
  BEGIN
    CASE f OF &lt;*NOWARN*&gt;
    | M3CStdProcs.T.Min =&gt;
        IF e1.sm_value &lt; e2.sm_value THEN
          er := e1;
        ELSE
          er := e2;
        END;
    | M3CStdProcs.T.Max =&gt;
        IF e1.sm_value &gt; e2.sm_value THEN
          er := e1;
        ELSE
          er := e2;
        END;
    END; (* case *)
    RETURN M3CBackEnd.NumStatus.Valid;
  END StdBinaryOp;

BEGIN

END M3CBackEnd_Float.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
