<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/toolframe/M3PathTool.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/toolframe/M3PathTool.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="M3PathTool.m3">M3PathTool</A></interface>;

IMPORT <A HREF="../files/Common/M3Extension.i3">M3Extension</A>, <A HREF="../files/Common/M3FindFile.i3">M3FindFile</A>;
</PRE> This tool provides control over the search path used by an <CODE>M3TK</CODE>
application. The <CODE>Define_Arg</CODE> and <CODE>TFile_Arg</CODE> arguments are <CODE>prefix</CODE>
keywords, that is, any keyword that begins with a <CODE>D</CODE> or a <CODE>T</CODE> will
match and the value returned by <CODE>M3Args.GetPrefixArg</CODE> will be the text
of the keyword with the prefix removed. 
<P>
<P>
The <CODE>TFile_Arg</CODE> may also occur zero or more time, and each occurrence
names a file that contains an explicit mapping of Modula-3 files to
directories, in the syntax specified in the <CODE>M3DirFindFile</CODE> interface.
For each occurrence, a file finder is generated
by a call to <CODE>NEW(M3DirFindFile.TFinder).init</CODE>.
<P>
The <CODE>Define_Arg</CODE> may occur zero or more times, and each occurrence specifies
a list of directories, in an OS-dependent syntax, in which to look for
Modula-3 files.  Each instance generates an <CODE>M3PathElemList.T</CODE>, by a
call of <CODE>M3PathElemOS.DecomposePath</CODE>; the separate lists are then
concatenated in the order of occurrence of the associated arguments.
<P>
If neither of these arguments is given, a file named {\it m3path},
that is assumed to contain a search path, is searched for in the
current directory. If such a file is found an <CODE>M3PathElemList.T</CODE>
is generated by a call of <CODE>M3PathFile.Read</CODE>, otherwise a value
of <CODE>NIL</CODE> is returned.
<P>
In the latter two cases, the current working directory is prepended to
the search list by a call of <CODE>M3PathDefaults.EnsureCurrentFirst</CODE> and,
unless the <CODE>NOSTD_Arg</CODE> is set, the default library directories, as
given by <CODE>M3Config.Pub()</CODE>, are appended to the search list.  A file
finder is then generated by a call to <CODE>NEW(M3DirFindFile.Finder).init</CODE>.
<P>
Finally, the finders are merged into a single instance with the <CODE>merge</CODE>
method. The merge process begins with the finder generated from the
<CODE>Define_Arg</CODE> arguments, if any, and then proceeds with the <CODE>TFile_Arg</CODE>
finders, in reverse order of occurrence.
<P>
The <CODE>Check</CODE> procedure checks for the above arguments and returns
the generated finder. 

<P><PRE>CONST
  Define_Arg = &quot;D&quot;;
  TFile_Arg = &quot;T&quot;;
  NOSTD_Arg = &quot;NOSTD&quot;;

PROCEDURE <A HREF="M3PathTool.m3#Check">Check</A>(exts := M3Extension.All): M3FindFile.T;
</PRE><BLOCKQUOTE><EM> Check for the tool arguments, set up the search path accordingly,
and return a finder for the given set of extensions. </EM></BLOCKQUOTE><PRE>

END M3PathTool.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
