<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/toolframe/M3PathTool.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/toolframe/M3PathTool.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3PathTool.i3">M3PathTool</A></implements></module>;

IMPORT <A HREF="../misc/M3Args.i3">M3Args</A>, <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../../rw/src/Common/FileRd.i3">FileRd</A>, <A HREF="../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../../atom/src/Atom.i3">Atom</A>, <A HREF="#x1">Err</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>;
IMPORT <A HREF="../files/Common/M3Extension.i3">M3Extension</A>, <A HREF="../files/Common/M3FindFile.i3">M3FindFile</A>, <A HREF="../files/Common/M3PathElem.i3">M3PathElem</A>, <A HREF="../files/Common/M3PathElemOS.i3">M3PathElemOS</A>, <A HREF="../files/Common/M3PathElemList.i3">M3PathElemList</A>,
       <A HREF="../files/Common/M3DirFindFile.i3">M3DirFindFile</A>;

CONST
  Version = &quot;9-Apr-93&quot;;

VAR
  tool_g := M3Args.New(&quot;m3pathtool&quot;, &quot;search path tool&quot;, Version);

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A>(exts := M3Extension.All): M3FindFile.T RAISES {}=
  VAR path, tfile: REF ARRAY OF TEXT;
      dirs: M3PathElemList.T := NIL;
      dfinder, result: M3DirFindFile.Finder := NIL;
      tfinders: REF ARRAY OF M3DirFindFile.Finder := NIL;
      rd: Rd.T;
  BEGIN
    IF M3Args.Find(tool_g) THEN
      tfile := M3Args.GetPrefix(tool_g, TFile_Arg);
      IF tfile # NIL THEN
        tfinders := NEW(REF ARRAY OF M3DirFindFile.Finder, NUMBER(tfile^));
        FOR i := 0 TO NUMBER(tfile^)-1 DO tfinders[i] := NIL END;
        FOR i := 0 TO NUMBER(tfile^)-1 DO
          TRY
            rd := FileRd.Open(tfile[i]);
            TRY
              tfinders[i] := NEW(M3DirFindFile.TFinder).init(exts, rd);
            FINALLY
              &lt;*FATAL Rd.Failure, Thread.Alerted*&gt;
              BEGIN Rd.Close(rd); END;
            END;
          EXCEPT
          | OSError.E(e) =&gt;
              Err.Print(Fmt.F(&quot;error opening '%s' - %s&quot;, tfile[i],
                  Atom.ToText(e.head)), Err.Severity.Error);
          END;
        END;
      END;

      path := M3Args.GetPrefix(tool_g, Define_Arg);
      IF path # NIL THEN
        FOR i := 0 TO NUMBER(path^)-1 DO
          WITH p = path[i] DO
            dirs := M3PathElemList.AppendD(dirs,
                                             M3PathElemOS.DecomposePath(p));
          END;
        END; (* for *)
      END;
</PRE><P>
      IF NOT M3Args.GetFlag(tool_g, NOSTD_Arg) THEN
        VAR pub := M3Config.Pub();
        BEGIN
          WHILE pub # NIL DO
            dirs := M3PathDefaults.Add(dirs,
                        M3PathElem.FromText(pub.head, pub.head));
            pub := pub.tail;
          END;
        END;
      END;

      <PRE>&lt;*FATAL OSError.E*&gt;
      BEGIN
        dfinder := NEW(M3DirFindFile.Finder).init(exts, dirs, NIL,
                       NEW(ErrorHandler));
      END;

      result := dfinder;
      (* merge *)
      IF tfinders # NIL THEN
        VAR
          start := NUMBER(tfinders^) - 1;
        BEGIN
          IF result = NIL THEN
            REPEAT
              result := tfinders[start]; DEC(start);
            UNTIL result # NIL OR start &lt; 0
          END;
          WHILE start &gt;= 0 DO
            result := NEW(M3DirFindFile.Finder).merge(result, tfinders[start]);
            DEC(start);
          END;
        END
      END
    END; (* if *)
    RETURN result;
  END Check;

TYPE
  ErrorHandler = M3DirFindFile.ErrorHandler OBJECT
  OVERRIDES
    callback := ErrorProc;
  END;

PROCEDURE <A NAME="ErrorProc"><procedure>ErrorProc</procedure></A>(&lt;*UNUSED*&gt; t: ErrorHandler; dir: M3PathElem.T;
                    ec: OSError.Code): BOOLEAN=
  BEGIN
    Err.Print(Fmt.F(&quot;error opening '%s' - %s&quot;, dir.text(),
                    Atom.ToText(ec.head)), Err.Severity.Error);
    RETURN TRUE;
  END ErrorProc;

BEGIN
  M3Args.RegisterPrefix(tool_g, Define_Arg,
    &quot;specify an explicit path to be used for file searching&quot;);
  M3Args.RegisterPrefix(tool_g, TFile_Arg,
    &quot;specify a file with an explicit map to be used for file searching&quot;);
  M3Args.RegisterFlag(tool_g, NOSTD_Arg,
    &quot;suppress default scan of standard libraries&quot;);
END M3PathTool.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Err is in:
</A><UL>
<LI><A HREF="../../../dps/src/Err.i3#0TOP0">dps/src/Err.i3</A>
<LI><A HREF="../misc/Err.i3#0TOP0">m3tk/src/misc/Err.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
