<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/toolframe/M3ToolFrame.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/toolframe/M3ToolFrame.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="M3ToolFrame.m3">M3ToolFrame</A></interface>;
</PRE> Basic framework for an M3TK tool. 

<P><PRE>IMPORT <A HREF="../toolmisc/M3Context.i3">M3Context</A>;

PROCEDURE <A HREF="M3ToolFrame.m3#Init">Init</A>(c: M3Context.T): INTEGER;
</PRE><BLOCKQUOTE><EM> Initialise the toolkit, using context <CODE>c</CODE> </EM></BLOCKQUOTE><PRE>

TYPE
  Worker = OBJECT
  METHODS
    work(context: M3Context.T;
         compileResult: INTEGER): INTEGER RAISES ANY;
  END;

PROCEDURE <A HREF="M3ToolFrame.m3#Startup">Startup</A>(
    worker: Worker;
    compile := TRUE;
    ): INTEGER RAISES ANY;
</PRE><BLOCKQUOTE><EM> Initialise the toolkit and then invoke <CODE>worker</CODE> </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>Init</CODE> procedure  is equivalent to the following code:
<P>
<PRE>
       BEGIN
         (* register target machine variants 

<PRE>|    M3CBE_C_Tool.ToolInit();
|    (* check for -help *)
|    IF M3Args.CheckHelp() THEN RETURN 0 END;
|    (* check for target machine and fail if bad *)
|    IF M3CBE_C_Tool.Init() &lt; 0 THEN RETURN -1 END;
|    (* establish a finder for M3 files ans store in &quot;context&quot; *)
|    context.put(M3PathTool.Check());
|    (* include &quot;standard&quot; interface *)
|    WiredStandard.Set(context);
|    RETURN 1
|  END;

&quot;Init&quot; returns &quot;&lt; 0&quot; if an initialisation error occurs, &quot;0&quot; if help
was requested and &quot;&gt; 0&quot; otherwise.

The &quot;Startup&quot;  procedure is equivalent to the following code:

|  VAR
|    context := M3Context.New();
|    compileResult: INTEGER := Init(context);
|  BEGIN
|    IF compileResult &lt;= 0 THEN RETURN compileResult END;
|    IF compile THEN compileResult := M3CFETool.CompileInContext(context) END;
|    RETURN worker.work(context, compileResult);  (* call user method *)
|  END;

*)

END M3ToolFrame.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
