<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/toolmisc/M3CUnit.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/toolmisc/M3CUnit.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="M3CUnit.m3">M3CUnit</A></interface>;

IMPORT <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../files/Common/M3FindFile.i3">M3FindFile</A>, <A HREF="../../../os/src/Common/OSError.i3">OSError</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../ast/M3AST_FE.i3">M3AST_FE</A>;

TYPE
  (* for convenience we alias the types that this interface uses from
     M3AST_FE. *)

  Uid = M3AST_FE.Unit_uid;
  State = M3AST_FE.Unit_state;
  Status = M3AST_FE.Unit_status;
  Type = M3AST_FE.Unit_type;

  TypeSet = SET OF Type;

CONST
  Errors = M3AST_FE.Unit_Errors;
  AllPhases = M3AST_FE.Unit_AllPhases;
  AllTypes = TypeSet{FIRST(Type)..LAST(Type)};
  Interfaces = TypeSet{Type.Interface,
                       Type.Interface_gen_def,
                       Type.Interface_gen_ins};
  Modules = TypeSet{Type.Module,
                    Type.Module_gen_def,
                    Type.Module_gen_ins};

TYPE
  Form = {Source, Ast, DontCare};

PROCEDURE <A HREF="M3CUnit.m3#FindUnit">FindUnit</A>(
    f: M3FindFile.T;
    name: TEXT;
    unitType: Type;
    VAR (*inout*) uf: Form;
    VAR (*out*) id: Uid)
    : Rd.T
    RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Given a name and <CODE>unitType</CODE>, indicating whether an interface or a module is
required, <CODE>FindSource</CODE> attempts to open a stream to an file containing a
representation of a compilation unit. The representation can be requested as:
i) A source file; in this case <CODE>id</CODE> is set to be a unique id for the source
and the returned stream can be used to parse the source.
ii) A pickled graph; in this case <CODE>id</CODE> is set to a unique id for the pickle
and the returned stream should be used to <CODE>unpickle</CODE> the graph.
iii) Dontcare.  Either will do.
<P>
If <CODE>FindUnit</CODE> fails to find a file containing the requested
compilation unit, it returns <CODE>NIL</CODE>.  If an errors occurs in opening a
found file, <CODE>OSError.E</CODE> is raised, as per <CODE>FileRd.Open</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CUnit.m3#FindStandard">FindStandard</A>(
    f: M3FindFile.T;
    VAR (*inout*) uf: Form;
    VAR (*out*) id: Uid): Rd.T RAISES {M3FindFile.Failed, OSError.E};
</PRE><BLOCKQUOTE><EM> This procedure is a special case of <CODE>FindUnit</CODE>. It attempts to open a
stream to the representation of the standard interface.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CUnit.m3#TextName">TextName</A>(id: Uid): TEXT;
</PRE><BLOCKQUOTE><EM> Given a <CODE>Uid</CODE> this procedure returns a text, suitable for use
in error messages </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CUnit.m3#TypeName">TypeName</A>(ut: Type): TEXT;
</PRE><BLOCKQUOTE><EM> Returns <CODE>interface</CODE> or <CODE>module</CODE> based on <CODE>ut</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CUnit.m3#ToType">ToType</A>(u: M3AST_AS.UNIT): Type;
</PRE><BLOCKQUOTE><EM> u # NIL, maps from ISTYPE(u, ..) to <CODE>Type</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CUnit.m3#ToGenIns">ToGenIns</A>(
    cu: M3AST_AS.Compilation_Unit;
    VAR (*inout*) ut: Type): M3AST_AS.Compilation_Unit;
</PRE><BLOCKQUOTE><EM> If <CODE>cu</CODE> is a generic instantiation, return the instantiated unit,
   (i.e. cu.as_root.sm_ins_comp_unit). The value of <CODE>ut</CODE> is also updated.
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3CUnit.m3#Equal">Equal</A>(id1, id2: Uid): BOOLEAN;
</PRE><BLOCKQUOTE><EM> TRUE if <CODE>id1</CODE> and <CODE>id2</CODE> represent the same unit </EM></BLOCKQUOTE><PRE>

&lt;*INLINE*&gt; PROCEDURE <A HREF="M3CUnit.m3#InclState">InclState</A>(VAR status: Status; state: State);
</PRE><BLOCKQUOTE><EM> status := status + Status{state}; </EM></BLOCKQUOTE><PRE>

&lt;*INLINE*&gt; PROCEDURE <A HREF="M3CUnit.m3#ExclState">ExclState</A>(VAR status: Status; state: State);
</PRE><BLOCKQUOTE><EM> status := status - Status{state}; </EM></BLOCKQUOTE><PRE>

END M3CUnit.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
