<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/toolmisc/M3CUnit.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/toolmisc/M3CUnit.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>M3CUnit</module> EXPORTS <A HREF="M3CUnit.i3"><implements>M3CUnit</A></implements>, <A HREF="../ast/M3AST_FE.i3"><implements>M3AST_FE</A></implements>, <A HREF="M3CUnitRep.i3"><implements>M3CUnitRep</A></implements>;

IMPORT <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="#x1">Err</A>, <A HREF="../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../../atom/src/Atom.i3">Atom</A>, <A HREF="../../../os/src/Common/FS.i3">FS</A>, <A HREF="../../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../../../rw/src/Common/FileRd.i3">FileRd</A>;
IMPORT <A HREF="../files/Common/M3Extension.i3">M3Extension</A>, <A HREF="../files/Common/M3FindFile.i3">M3FindFile</A>;
IMPORT <A HREF="M3Conventions.i3">M3Conventions</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>;

TYPE ExtSet = M3Extension.TSet; Ext = M3Extension.T;

PROCEDURE <A NAME="FindUnit"><procedure>FindUnit</procedure></A>(
    f: M3FindFile.T;
    name: TEXT;
    unitType: Type;
    VAR (*inout*) uf: Form;
    VAR id: Uid)
    : Rd.T
    RAISES {OSError.E} =
  VAR
    m3Exts: ExtSet;
    result: Rd.T;
    t: M3Extension.T;
    pn: Pathname.T;
  BEGIN
    IF unitType = Type.Interface THEN
      IF uf # Form.Source THEN m3Exts := ExtSet{Ext.PInt}
      ELSE m3Exts := M3Extension.Ints;
      END;
    ELSE m3Exts := M3Extension.Mods
    END;
    IF M3Extension.Has(name, t) AND t # M3Extension.T.Null THEN
      result := FileRd.Open(name);
      pn := name;
    ELSE
      (* strip to module name *)
      name := Pathname.Base(name);
      result := OpenFromSet(f, name, m3Exts, pn);
    END;
    IF (result = NIL) AND (uf # Form.Source) THEN
      IF unitType = Type.Interface THEN
        m3Exts := M3Extension.Ints;
	result := OpenFromSet(f, name, m3Exts, pn);
      END;
    END;

    IF result # NIL THEN
      id := NEW(Uid, filename := pn);
      IF NOT (Ext.PInt IN m3Exts) THEN
        TRY
          WITH status = FS.Status(pn) DO
    	    id.stamp := status.modificationTime;
          END;
	EXCEPT
        | OSError.E(t) =&gt;
            Err.Print(Fmt.F(&quot;problem reading timestamp for %s - %s&quot;,
                id.filename, Atom.ToText(t.head)), Err.Severity.Error);
            result := NIL;
        END;
        uf := Form.Source;
      ELSE
        uf := Form.Ast;
      END;
    END; (* if *)
    RETURN result;
  END FindUnit;

PROCEDURE <A NAME="OpenFromSet"><procedure>OpenFromSet</procedure></A>(
    f: M3FindFile.T;
    name: TEXT;
    exts: M3Extension.TSet;
    VAR (*out*) pn: Pathname.T)
    : Rd.T
    RAISES {OSError.E}=
  VAR rd: Rd.T := NIL;
  BEGIN
    FOR ext := FIRST(M3Extension.T) TO LAST(M3Extension.T) DO
      IF ext IN exts THEN
        TRY
           pn := f.find(name, ext);
           rd := f.openRead(name, ext);
           EXIT;
        EXCEPT
        | M3FindFile.Failed =&gt;
        END;
      END; (* if *)
    END; (* for *)
    RETURN rd;
  END OpenFromSet;

PROCEDURE <A NAME="FindStandard"><procedure>FindStandard</procedure></A>(
    f: M3FindFile.T;
    VAR uf: Form;
    VAR id: Uid
    ): Rd.T RAISES {OSError.E} =
  BEGIN
    RETURN FindUnit(f, M3Conventions.Standard, Type.Interface, uf, id);
  END FindStandard;

PROCEDURE <A NAME="TextName"><procedure>TextName</procedure></A>(id: Uid): TEXT RAISES {} =
  BEGIN
    RETURN id^.filename;
  END TextName;

PROCEDURE <A NAME="TypeName"><procedure>TypeName</procedure></A>(ut: Type): TEXT RAISES {} =
  BEGIN
    CASE ut OF
    | Type.Interface =&gt; RETURN &quot;interface&quot;;
    | Type.Module =&gt; RETURN &quot;module&quot;;
    | Type.Interface_gen_def =&gt; RETURN &quot;generic interface&quot;
    | Type.Interface_gen_ins =&gt; RETURN &quot;instantiated interface&quot;
    | Type.Module_gen_def =&gt; RETURN &quot;generic module&quot;
    | Type.Module_gen_ins =&gt; RETURN &quot;instantiated module&quot;
    (*ELSE crash *)
    END;
  END TypeName;

EXCEPTION NullUNIT;

PROCEDURE <A NAME="ToType"><procedure>ToType</procedure></A>(u: M3AST_AS.UNIT): Type RAISES {}=
  &lt;*FATAL NullUNIT*&gt;
  BEGIN
    TYPECASE u OF &lt;*NOWARN*&gt;
    | NULL =&gt; RAISE NullUNIT;
    | M3AST_AS.Interface =&gt; RETURN Type.Interface;
    | M3AST_AS.Module =&gt; RETURN Type.Module;
    | M3AST_AS.Interface_gen_def =&gt; RETURN Type.Interface_gen_def;
    | M3AST_AS.Module_gen_def =&gt; RETURN Type.Module_gen_def;
    | M3AST_AS.Interface_gen_ins =&gt; RETURN Type.Interface_gen_ins;
    | M3AST_AS.Module_gen_ins =&gt; RETURN Type.Module_gen_ins;
    END;
  END ToType;

PROCEDURE <A NAME="ToGenIns"><procedure>ToGenIns</procedure></A>(cu: M3AST_AS.Compilation_Unit;
    VAR (*inout*) ut: Type): M3AST_AS.Compilation_Unit RAISES {}=
  BEGIN
    TYPECASE cu.as_root OF
    | M3AST_AS.UNIT_GEN_INS(unit_ins) =&gt;
        cu := unit_ins.sm_ins_comp_unit;
        IF cu # NIL THEN
          IF ISTYPE(cu.as_root, M3AST_AS.Interface) THEN ut := Type.Interface
          ELSE ut := Type.Module
          END;
        END;
    ELSE
    END; (* typecase *)
    RETURN cu
  END ToGenIns;

PROCEDURE <A NAME="Equal"><procedure>Equal</procedure></A>(id1, id2: Uid): BOOLEAN=
  BEGIN
    RETURN id1.stamp = id2.stamp;
  END Equal;

&lt;*INLINE*&gt; PROCEDURE <A NAME="InclState"><procedure>InclState</procedure></A>(VAR status: Status; state: State) RAISES {}=
  BEGIN
    status := status + Status{state};
  END InclState;

&lt;*INLINE*&gt; PROCEDURE <A NAME="ExclState"><procedure>ExclState</procedure></A>(VAR status: Status; state: State) RAISES {}=
  BEGIN
    status := status - Status{state};
  END ExclState;

BEGIN

END M3CUnit.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Err is in:
</A><UL>
<LI><A HREF="../../../dps/src/Err.i3#0TOP0">dps/src/Err.i3</A>
<LI><A HREF="../misc/Err.i3#0TOP0">m3tk/src/misc/Err.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
