<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/toolmisc/M3Context.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/toolmisc/M3Context.i3</H2></A><HR>
<inInterface>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="M3Context.m3">M3Context</A></interface>;
</PRE> This module defines a compilation context, in terms of a set of
compilation units. The set is keyed by the text 'name' which is passed
as argument to the 'Add' procedure. At most one <CODE>interface</CODE> and one
<CODE>module</CODE> AST may be associated with this name, and these may be
generic definitions, instantations or normal ASTs. The assumption
is that the unit name in the AST matches 'name' and that the AST actually 
corresponds to the indicated type. However this is not checked and in fact
the 'as_root' field may be NIL when the Add takes place. 

<P><PRE>IMPORT <A HREF="../../../property/src/Property.i3">Property</A>;
IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="M3CUnit.i3">M3CUnit</A>, <A HREF="../syn/M3CId.i3">M3CId</A>;

TYPE <A HREF="M3Context.m3#T">T</A> &lt;: Property.Set;
</PRE><BLOCKQUOTE><EM> A handle on a compilation context. It is handy to be able to
   associate values pertaining to context, which might otherwise
   have to be global variables, hence the definition as a subtype
   of <CODE>Property.Set</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE>***************************************************************************
               Creation/Adding/Removing units                              
***************************************************************************

<P><PRE>EXCEPTION Duplicate;

PROCEDURE <A HREF="M3Context.m3#New">New</A>(): T RAISES {};
</PRE><BLOCKQUOTE><EM> create an empty context </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Context.m3#Add">Add</A>(
    t: T;
    name: TEXT;
    unitType: M3CUnit.Type;
    cu: M3AST_AS.Compilation_Unit) RAISES {Duplicate};
</PRE><BLOCKQUOTE><EM> Add a new unit to the context. If 'unitType IN M3CUnit.Interfaces'
and there already exists another interface with the same 'name'
the Duplicate exception will be raised. Similarly for modules. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Context.m3#Remove">Remove</A>(t: T; name: TEXT; unitType: M3CUnit.Type) RAISES {};
</PRE><BLOCKQUOTE><EM> If 'unitType' IN M3CUnit.Interfaces, remove the interface 'name' from 
this context, else remove the module 'name'. </EM></BLOCKQUOTE><PRE>
</PRE>***************************************************************************
                            Finding units                                  
***************************************************************************

<P><PRE>PROCEDURE <A HREF="M3Context.m3#Find">Find</A>(
    t: T;
    name: TEXT;
    unitType: M3CUnit.Type;
    VAR (*out*) cu: M3AST_AS.Compilation_Unit;
    ): BOOLEAN
    RAISES {};
</PRE><BLOCKQUOTE><EM> If 'unitType IN M3CUnit.Interfaces', find the interface 'name', else
find the module. Returns true and sets 'cu' appropriately if successful, 
otherwise returns false and sets 'cu' to NIL. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Context.m3#FindExact">FindExact</A>(
    t: T;
    name: TEXT;
    unitType: M3CUnit.Type;
    VAR (*out*) cu: M3AST_AS.Compilation_Unit;
    ): BOOLEAN
    RAISES {};
</PRE><BLOCKQUOTE><EM> This is like 'Find', except that the type of the interface or module
has to match exactly. So, if a generic definition was added under 'name',
the call will only succeed if 'unitType = M3CUnit.Type.Interface_gen_def'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Context.m3#FindFromId">FindFromId</A>(
    t: T;
    name: M3CId.T;
    unitType: M3CUnit.Type;
    VAR (*out*) cu: M3AST_AS.Compilation_Unit;
    ): BOOLEAN
    RAISES {};
</PRE><BLOCKQUOTE><EM> As Find, but using a hash-id. </EM></BLOCKQUOTE><PRE>
</PRE>***************************************************************************
                            Iteratation                                    
***************************************************************************

<P><PRE>TYPE
  <A HREF="M3Context.m3#Iter">Iter</A> &lt;: REFANY;

PROCEDURE <A HREF="M3Context.m3#NewIter">NewIter</A>(
    t: T; unitType:
    M3CUnit.Type;
    findStandard := TRUE
    ): Iter RAISES {};
</PRE><BLOCKQUOTE><EM> create an iterator on context 't'. 'unitType' is treated as an exact match 
so, for example, one can iterate generic interfaces only. 
The 'Standard' interface will only be included if 'findStandard = TRUE
AND unitType = M3CUnit.Type.Interface'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Context.m3#Next">Next</A>(
    iter: Iter;
    VAR (*out*) name: TEXT;
    VAR (*out*) cu: M3AST_AS.Compilation_Unit;

    ): BOOLEAN
    RAISES {};
</PRE><BLOCKQUOTE><EM>  The iterator should be used as follows:
<P>
  i := M3Context.NewIter(unitType);
  WHILE M3Context.Next(iter, name, cu) DO
    ... code using 'name', 'cu' ...
  END; (* while </EM></BLOCKQUOTE><PRE>

To iterate over all kinds of interfaces and modules use the above within a
FOR loop.
*)

TYPE
  <A HREF="M3Context.m3#Closure">Closure</A> &lt;: Closure_public;
  Closure_public = OBJECT
    context: T;
  METHODS
     callback(
         ut: M3CUnit.Type;
         name: TEXT;
         cu: M3AST_AS.Compilation_Unit) RAISES ANY;
     init(): Closure RAISES {};
  END;
  (* Create by NEW(Closure, callback := YourCallback).init() *)

EXCEPTION Aborted;

PROCEDURE <A HREF="M3Context.m3#Apply">Apply</A>(t: T; cl: Closure; findStandard := TRUE) RAISES ANY;
</PRE><BLOCKQUOTE><EM> Apply p to all units in 't'.  This is just really just a convience
to avoid driving the iterator directly. 'cl' may be subtyped by client
to hold state; 'cl.callback' is called for each unit in the context.
'cl.t' is set to 't' before any callbacks. 'findStandard' is TRUE
for backward compatibility; most clients will set it to FALSE (see
ApplyToSet below). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Context.m3#ApplyToSet">ApplyToSet</A>(
    t: T;
    cl: Closure;
    unitTypeSet := M3CUnit.AllTypes;
    findStandard := FALSE) RAISES ANY;
</PRE><BLOCKQUOTE><EM> As 'Apply', but to a restricted set of unit types, e.g. excluding
  generic definitions. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Context.m3#AbortApply">AbortApply</A>()
    RAISES {Aborted};
</PRE><BLOCKQUOTE><EM> The current iteration is aborted by raising the 'Aborted' exception, which
is caught by 'Apply', thus control returns to caller of that procedure. </EM></BLOCKQUOTE><PRE>
</PRE>***************************************************************************
                            Miscellaneous                                  
***************************************************************************

<P> These procedures keep track of the special 'Standard' interface - the
interface that makes available the standard identifiers such as 'INTEGER' etc.
The 'Standard' interface is an implicit member of every context - it is a
global constant.  These procs operate without a context but once a context
exists, they have a simple rewrite given in the comment. 

<P><PRE>PROCEDURE <A HREF="M3Context.m3#SetStandard">SetStandard</A>(cu: M3AST_AS.Compilation_Unit) RAISES {};
</PRE><BLOCKQUOTE><EM>  Add(t, M3Conventions.Standard, M3CUnit.Type.Interface, cu); </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Context.m3#Standard">Standard</A>(): M3AST_AS.Compilation_Unit RAISES {};
</PRE><BLOCKQUOTE><EM>  Find(t, M3Conventions.Standard, M3CUnit.Type.Interface, cu, TRUE); </EM></BLOCKQUOTE><PRE>

END M3Context.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
