<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/toolmisc/M3Context.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/toolmisc/M3Context.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3Context.i3">M3Context</A></implements></module>;

IMPORT <A HREF="../../../property/src/Property.i3">Property</A>, <A HREF="../../../libm3/derived/TextRefTbl.i3">TextRefTbl</A>, <A HREF="../../../text/src/Text.i3">Text</A>;

IMPORT <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>, <A HREF="../syn/M3CId.i3">M3CId</A>, <A HREF="M3CUnit.i3">M3CUnit</A>, <A HREF="M3Conventions.i3">M3Conventions</A>;
IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>;

REVEAL <A NAME="T">T</A> = Property.Set BRANDED OBJECT t: TextRefTbl.T; END;

TYPE
  UnitHandle = REF RECORD
    interface: M3AST_AS.Compilation_Unit := NIL;
    module: M3AST_AS.Compilation_Unit := NIL;
  END;

VAR
  standard_g: M3AST_AS.Compilation_Unit;
  standardId_g: M3CId.T;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(): T RAISES {} =
  BEGIN
    RETURN NEW(T, t := NEW(TextRefTbl.Default).init(256));
  END New;

PROCEDURE <A NAME="Add"><procedure>Add</procedure></A>(
    t: T;
    name: TEXT;
    unitType: M3CUnit.Type;
    cu: M3AST_AS.Compilation_Unit) RAISES {Duplicate} =
  VAR
    ra: REFANY;
    bp: UnitHandle;
  BEGIN
    IF unitType = M3CUnit.Type.Interface AND
      Text.Equal(name, M3Conventions.Standard) THEN
      IF standard_g = NIL THEN SetStandard(cu) END;
      RETURN
    END;

    IF t.t.get(name, ra) THEN
      bp := NARROW(ra, UnitHandle);
    ELSE
      bp := NEW(UnitHandle);
      EVAL t.t.put(name, bp);
    END;
    IF unitType IN M3CUnit.Interfaces THEN
      IF (bp.interface # NIL) AND (bp.interface # cu) THEN RAISE Duplicate END;
      bp.interface := cu;
    ELSE
      IF (bp.module # NIL) AND (bp.module # cu) THEN RAISE Duplicate END;
      bp.module := cu;
    END; (* if *)
  END Add;

PROCEDURE <A NAME="Remove"><procedure>Remove</procedure></A>(t: T; name: TEXT; unitType: M3CUnit.Type) RAISES {} =
  VAR
    ra: REFANY;
    bp: UnitHandle;
  BEGIN
    IF t.t.get(name, ra) THEN
      bp := NARROW(ra, UnitHandle);
      IF unitType IN M3CUnit.Interfaces THEN
        bp.interface := NIL;
      ELSE
        bp.module := NIL;
      END;
    END;
  END Remove;

PROCEDURE <A NAME="FindPossiblyExact"><procedure>FindPossiblyExact</procedure></A>(
    t: T;
    name: TEXT;
    unitType: M3CUnit.Type;
    VAR cu: M3AST_AS.Compilation_Unit;
    exact := FALSE)
    : BOOLEAN
    RAISES {} =
  VAR
    ra: REFANY;
    bp: UnitHandle;
  BEGIN
    IF standard_g # NIL AND unitType = M3CUnit.Type.Interface AND
       Text.Equal(name, M3Conventions.Standard) THEN
      cu := standard_g;
      RETURN TRUE;
    ELSIF t.t.get(name, ra) THEN
      bp := NARROW(ra, UnitHandle);
      IF unitType IN M3CUnit.Interfaces THEN
        cu := bp.interface;
      ELSE
        cu := bp.module;
      END;
      IF exact THEN
        RETURN cu.as_root # NIL AND M3CUnit.ToType(cu.as_root) = unitType;
      ELSE
        RETURN cu # NIL;
      END; (* if *)
    ELSE
      cu := NIL;
      RETURN FALSE;
    END; (* if *)
  END FindPossiblyExact;

PROCEDURE <A NAME="Find"><procedure>Find</procedure></A>(
    t: T;
    name: TEXT;
    unitType: M3CUnit.Type;
    VAR cu: M3AST_AS.Compilation_Unit)
    : BOOLEAN
    RAISES {} =
  BEGIN
    RETURN FindPossiblyExact(t, name, unitType, cu);
  END Find;

PROCEDURE <A NAME="FindExact"><procedure>FindExact</procedure></A>(
    t: T;
    name: TEXT;
    unitType: M3CUnit.Type;
    VAR cu: M3AST_AS.Compilation_Unit)
    : BOOLEAN
    RAISES {} =
  BEGIN
    RETURN FindPossiblyExact(t, name, unitType, cu, TRUE);
  END FindExact;

PROCEDURE <A NAME="FindFromId"><procedure>FindFromId</procedure></A>(
    t: T;
    id: M3CId.T;
    unitType: M3CUnit.Type;
    VAR (*out*) cu: M3AST_AS.Compilation_Unit)
    : BOOLEAN RAISES {} =
  BEGIN
    IF standard_g # NIL AND unitType = M3CUnit.Type.Interface AND
       standardId_g = id THEN
      cu := standard_g;
      RETURN cu # NIL;
    ELSE
      RETURN FindPossiblyExact(t, M3CId.ToText(id), unitType, cu)
    END;
  END FindFromId;

REVEAL
  <A NAME="Iter">Iter</A> = BRANDED OBJECT
    needStandard := FALSE;
    unitType: M3CUnit.Type;
    tblIter: TextRefTbl.Iterator;
  END;

PROCEDURE <A NAME="NewIter"><procedure>NewIter</procedure></A>(
    t: T;
    unitType: M3CUnit.Type;
    findStandard := TRUE
    ): Iter RAISES {} =
  BEGIN
    RETURN NEW(Iter, unitType := unitType,
            needStandard := unitType = M3CUnit.Type.Interface AND findStandard,
            tblIter := t.t.iterate());
  END NewIter;

PROCEDURE <A NAME="Next"><procedure>Next</procedure></A>(
    iter: Iter;
    VAR name: TEXT;
    VAR cu: M3AST_AS.Compilation_Unit)
    : BOOLEAN
    RAISES {} =
  VAR
    ra: REFANY;
    uh: UnitHandle;
  BEGIN
    IF iter.needStandard AND standard_g # NIL THEN
       iter.needStandard := FALSE;
       cu := standard_g;
       name := M3Conventions.Standard;
       RETURN TRUE;
    ELSE
      WHILE iter.tblIter.next(name, ra) DO
        uh := NARROW(ra, UnitHandle);
        IF iter.unitType IN M3CUnit.Interfaces THEN cu := uh.interface
        ELSE cu := uh.module
        END;
        IF cu # NIL AND cu.as_root # NIL AND
           M3CUnit.ToType(cu.as_root) = iter.unitType THEN
          RETURN TRUE
        END;
      END;
    END;
    RETURN FALSE;
  END Next;

REVEAL
  <A NAME="Closure">Closure</A> = Closure_public BRANDED OBJECT OVERRIDES init := Init END;

PROCEDURE <A NAME="ApplyToSet"><procedure>ApplyToSet</procedure></A>(t: T; cl: Closure; unitTypeSet := M3CUnit.AllTypes;
    findStandard := FALSE) RAISES ANY =
  VAR
    iter: Iter;
    name: TEXT;
    cu: M3AST_AS.Compilation_Unit;
  BEGIN
    cl.context := t;
    TRY
      FOR unitType := FIRST(M3CUnit.Type) TO LAST(M3CUnit.Type) DO
        IF unitType IN unitTypeSet THEN
          iter := NewIter(t, unitType, findStandard);
          WHILE Next(iter, name, cu) DO
            cl.callback(unitType, name, cu);
          END; (* while *)
        END;
      END;
    EXCEPT
    | Aborted =&gt;
    END;
  END ApplyToSet;

PROCEDURE <A NAME="Apply"><procedure>Apply</procedure></A>(t: T; cl: Closure; findStandard := TRUE) RAISES ANY=
  BEGIN
    ApplyToSet(t, cl, findStandard := findStandard);
  END Apply;

PROCEDURE <A NAME="AbortApply"><procedure>AbortApply</procedure></A>() RAISES {Aborted}=
  BEGIN
    RAISE Aborted;
  END AbortApply;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(c: Closure): Closure RAISES {}=
  BEGIN
    RETURN c;
  END Init;

PROCEDURE <A NAME="SetStandard"><procedure>SetStandard</procedure></A>(cu: M3AST_AS.Compilation_Unit) RAISES {} =
  BEGIN
    standard_g := cu;
    standardId_g := M3CId.Enter(M3Conventions.Standard);
  END SetStandard;

PROCEDURE <A NAME="Standard"><procedure>Standard</procedure></A>(): M3AST_AS.Compilation_Unit RAISES {} =
  BEGIN
    RETURN standard_g;
  END Standard;

BEGIN
  standard_g := NIL;
END M3Context.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
