<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/toolmisc/M3ContextRemove.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/toolmisc/M3ContextRemove.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3ContextRemove.i3">M3ContextRemove</A></implements></module>;

IMPORT <A HREF="../../../libm3/derived/RefList.i3">RefList</A>;
IMPORT <A HREF="M3Context.i3">M3Context</A>, <A HREF="M3CUnit.i3">M3CUnit</A>, <A HREF="M3Conventions.i3">M3Conventions</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>, <A HREF="../ast/M3AST_FE_F.i3">M3AST_FE_F</A>;

IMPORT <A HREF="../../derived/SeqM3AST_AS_Used_interface_id.i3">SeqM3AST_AS_Used_interface_id</A>;

TYPE
  UnitsClosure = M3Context.Closure OBJECT
    unit_id_to_remove: M3AST_AS.UNIT_ID := NIL;
  OVERRIDES
    callback := RemoveInterfaceUsers;
  END;

  GenUnitsClosure = UnitsClosure OBJECT
  OVERRIDES
    callback := RemoveGenericUsers
  END;

  ErrorClosure =  M3Context.Closure OBJECT
  OVERRIDES
    callback := RemoveIfErrors;
  END;

TYPE NotificationElem = REF RECORD e: Notification END;

VAR notifications_g: RefList.T := NIL;
    notificationsMutex_g := NEW(MUTEX);

PROCEDURE <A NAME="AddNotification"><procedure>AddNotification</procedure></A>(e: Notification) RAISES {}=
  BEGIN
    LOCK notificationsMutex_g DO
      notifications_g := RefList.AppendD(notifications_g,
                             RefList.List1(NEW(NotificationElem, e := e)));
    END; (* lock *)
  END AddNotification;

PROCEDURE <A NAME="RemoveNotification"><procedure>RemoveNotification</procedure></A>(e: Notification) RAISES {}=
  VAR l: RefList.T := notifications_g; prev: RefList.T := NIL;
  BEGIN
    LOCK notificationsMutex_g DO
      WHILE l # NIL DO
        IF NARROW(l.head, NotificationElem).e = e THEN
          IF prev = NIL THEN notifications_g := l.tail
          ELSE prev.tail := l.tail;
          END;
          RETURN
        END;
        prev := l; l := l.tail;
      END;
    END; (* lock *)
  END RemoveNotification;

PROCEDURE <A NAME="Notify"><procedure>Notify</procedure></A>(
    &lt;*UNUSED*&gt; context: M3Context.T;
    unitType: M3CUnit.Type; name: TEXT;
    cu: M3AST_AS.Compilation_Unit)=
  &lt;*FATAL ANY*&gt;
  BEGIN
    LOCK notificationsMutex_g DO
      VAR list: RefList.T := notifications_g;
      BEGIN
        WHILE list # NIL DO
          NARROW(list.head, NotificationElem).e.callback(unitType, name, cu);
          list := list.tail;
        END;
      END;
    END;
  END Notify;

PROCEDURE <A NAME="SafeToUnit"><procedure>SafeToUnit</procedure></A>(cu: M3AST_AS.Compilation_Unit; ut: M3CUnit.Type):
  M3CUnit.Type =
  BEGIN
    IF cu.as_root = NIL THEN
      RETURN ut
    ELSE
      RETURN M3CUnit.ToType(cu.as_root)
    END;
  END SafeToUnit;

PROCEDURE <A NAME="Units"><procedure>Units</procedure></A>(
    context: M3Context.T;
    READONLY units: ARRAY OF TEXT;
    unitType: M3CUnit.Type;
    ) RAISES {}=
  VAR
    mname: TEXT;
    cu: M3AST_AS.Compilation_Unit;
  BEGIN
    (* Remove any old instances of the requested units from the context. *)
    FOR i := 0 TO NUMBER(units)-1 DO
      mname := M3Conventions.ModuleName(units[i]);
      IF M3Context.Find(context, mname, unitType, cu) THEN
        RemoveUnit(context, unitType, mname, cu);
      END;
    END; (* for *)
  END Units;

PROCEDURE <A NAME="UnitsWithErrors"><procedure>UnitsWithErrors</procedure></A>(context: M3Context.T)=
  &lt;*FATAL ANY*&gt;
  BEGIN
    M3Context.Apply(context,
      NEW(ErrorClosure), findStandard := FALSE);
  END UnitsWithErrors;

PROCEDURE <A NAME="RemoveIfErrors"><procedure>RemoveIfErrors</procedure></A>(
    cl: ErrorClosure;
    unitType: M3CUnit.Type; name: TEXT;
    cu: M3AST_AS.Compilation_Unit) RAISES {}=
  BEGIN
    IF (cu.fe_status * M3CUnit.Errors) # M3CUnit.Status{} THEN
      RemoveUnit(cl.context, unitType, name, cu);
    END; (* if *)
  END RemoveIfErrors;

PROCEDURE <A NAME="RemoveUnit"><procedure>RemoveUnit</procedure></A>(
    context: M3Context.T;
    unitType: M3CUnit.Type; name: TEXT;
    cu: M3AST_AS.Compilation_Unit) RAISES {}=

  BEGIN
    M3Context.Remove(context, name, unitType);
    Notify(context, SafeToUnit(cu, unitType), name, cu);

    IF cu.as_root = NIL THEN RETURN END;

    IF ISTYPE(cu.as_root, M3AST_AS.UNIT_GEN_DEF) THEN
      &lt;*FATAL ANY*&gt; BEGIN
        M3Context.ApplyToSet(context,
            NEW(GenUnitsClosure, unit_id_to_remove := cu.as_root.as_id),
            M3CUnit.TypeSet{M3CUnit.Type.Interface_gen_ins,
                            M3CUnit.Type.Module_gen_ins})
      END;
    END;

    IF (unitType = M3CUnit.Type.Interface) THEN
      (* remove everything that uses this interface *)
      TYPECASE cu.as_root OF
      | M3AST_AS.UNIT_GEN_INS(unit_ins) =&gt;
          (* importers are bound to the generated UNIT_NORMAL *)
          cu := unit_ins.sm_ins_comp_unit;
          IF cu = NIL OR cu.as_root = NIL THEN RETURN END;
      ELSE
      END; (* typecase *)

      &lt;*FATAL ANY*&gt; BEGIN
        M3Context.Apply(context,
            NEW(UnitsClosure, unit_id_to_remove := cu.as_root.as_id),
                findStandard := FALSE);
      END;
    END; (* if *)
  END RemoveUnit;

PROCEDURE <A NAME="RemoveInterfaceUsers"><procedure>RemoveInterfaceUsers</procedure></A>(
    cl: UnitsClosure;
    unitType: M3CUnit.Type; name: TEXT;
    cu: M3AST_AS.Compilation_Unit) RAISES {}=
  VAR
    iter: SeqM3AST_AS_Used_interface_id.Iter;
    intf_id: M3AST_AS.Used_interface_id;
  BEGIN
    TYPECASE cu.as_root OF
    | M3AST_AS.UNIT_GEN_INS(unit_ins) =&gt;
        cu := unit_ins.sm_ins_comp_unit;
        IF cu = NIL THEN RETURN END;
    ELSE
    END; (* typecase *)
    iter := SeqM3AST_AS_Used_interface_id.NewIter(
        NARROW(cu.as_root, M3AST_AS.UNIT_WITH_BODY).sm_import_s);
    WHILE SeqM3AST_AS_Used_interface_id.Next(iter, intf_id) DO
      IF (intf_id.sm_def # NIL) AND
         (NARROW(intf_id.sm_def, M3AST_AS.Interface_id) = cl.unit_id_to_remove) THEN
        M3Context.Remove(cl.context, name, unitType);
	Notify(cl.context, unitType, name, cu);
      END; (* if *)
    END; (* while *)
  END RemoveInterfaceUsers;

PROCEDURE <A NAME="RemoveGenericUsers"><procedure>RemoveGenericUsers</procedure></A>(
    cl: GenUnitsClosure;
    unitType: M3CUnit.Type; name: TEXT;
    cu: M3AST_AS.Compilation_Unit) RAISES {}=
  VAR gen_id := NARROW(cu.as_root, M3AST_AS.UNIT_GEN_INS).as_gen_id;
  BEGIN
    (* If this instantation is bound to the generic definition
    to be removed, remove it as well. *)
    IF gen_id.sm_def # NIL AND
       (NARROW(gen_id.sm_def, M3AST_AS.UNIT_ID) = cl.unit_id_to_remove) THEN
      RemoveUnit(cl.context, unitType, name, cu);
    END; (* if *)
  END RemoveGenericUsers;

BEGIN

END M3ContextRemove.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
