<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/toolmisc/M3Conventions.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/toolmisc/M3Conventions.m3</H2></A><HR>
<inModule>
<PRE></PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>MODULE <module><implements><A HREF="M3Conventions.i3">M3Conventions</A></implements></module>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../misc/TextExtras.i3">TextExtras</A>, <A HREF="../../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../misc/M3Time.i3">M3Time</A>;

PROCEDURE <A NAME="IsStandard"><procedure>IsStandard</procedure></A>(name: TEXT): BOOLEAN RAISES {} =
  BEGIN
    RETURN (name = NIL) OR Text.Equal(ModuleName(name), Standard);
  END IsStandard;

PROCEDURE <A NAME="ModuleName"><procedure>ModuleName</procedure></A>(name: TEXT): TEXT RAISES {} =
  VAR
    index: CARDINAL;
  BEGIN
    index := 0;
    (* strip leading pathnames and trailing extensions *)
    name := Pathname.LastBase(name);
    (* strip trailing version tags -xxx *)
    IF TextExtras.FindChar(name, VersionSep, index) THEN
      name := TextExtras.Extract(name, 0, index);
    END;
    RETURN name;
  END ModuleName;

REVEAL
  <A NAME="CompTime">CompTime</A> = CompTime_public BRANDED OBJECT
  OVERRIDES
    init := Init;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(&lt;*UNUSED*&gt; c: CompTime): CompTime =
  BEGIN
    RETURN NEW(CompTime, open := M3Time.Zero(), parse := M3Time.Zero(),
               semantic := M3Time.Zero());
  END Init;

BEGIN

END M3Conventions.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
