<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/toolmisc/M3Error.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/toolmisc/M3Error.i3</H2></A><HR>
<inInterface>
<PRE>INTERFACE <interface><A HREF="M3Error.m3">M3Error</A></interface>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../ast/M3AST_LX.i3">M3AST_LX</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="../syn/M3CSrcPos.i3">M3CSrcPos</A>;
</PRE> This interface supports the reporting and subsequent display
   of errors. Errors can be reported with reference to source
   position, for parsers, or by association with a node in the
   AST. Since any given node does not have a back pointer to
   the root, this interface defines the notion of the <CODE>current</CODE>
   unit, which must be set explicitly by the client before
   calling most procedures. 

<P><PRE>PROCEDURE <A HREF="M3Error.m3#SetCu">SetCu</A>(cu: M3AST_AS.Compilation_Unit) RAISES {};
</PRE><BLOCKQUOTE><EM> Since AST nodes may not contain a reference to the root, this
procedure must be called to establish the unit, before any calls to
the report procedures occur. 
</EM></BLOCKQUOTE><PRE>

TYPE
  ERROR_NODE = M3AST_AS.SRC_NODE;
</PRE> The following procedures report errors.  Errors are typically associated
   with AST nodes, with an implied unit and source position, and usually
   include identifier names.  Consequently, 'message' may contain 'Fmt' %s 
   specifiers. The method of error presentation is implementation dependent.

<P><PRE>PROCEDURE <A HREF="M3Error.m3#Report">Report</A>(n: ERROR_NODE; message: TEXT) RAISES {};
</PRE><BLOCKQUOTE><EM> Reports an error associated with node 'n'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Error.m3#ReportWithId">ReportWithId</A>(n: ERROR_NODE; message: TEXT;
    id1, id2, id3, id4: M3AST_LX.Symbol_rep := NIL) RAISES {};
</PRE><BLOCKQUOTE><EM> Reports an error associated with node 'n', with optional arguments
denoting identifier names that correspond with %s specifiers in 'message'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Error.m3#ReportAtPos">ReportAtPos</A>(pos: M3CSrcPos.T; message: TEXT) RAISES {};
</PRE><BLOCKQUOTE><EM> If no node is available, e.g. some syntax errors, this associates
an error with source position 'pos'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Error.m3#Warn">Warn</A>(n: ERROR_NODE; message: TEXT) RAISES {};
</PRE><BLOCKQUOTE><EM> As 'Report', but only a warning. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Error.m3#WarnWithId">WarnWithId</A>(n: ERROR_NODE; message: TEXT;
    id1, id2, id3, id4: M3AST_LX.Symbol_rep := NIL) RAISES {};
</PRE><BLOCKQUOTE><EM> As 'Report', but only a warning, with arguments as per WarnWithId. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Error.m3#SuppressWarnings">SuppressWarnings</A>(b := TRUE) RAISES {};
</PRE><BLOCKQUOTE><EM> Switch off/on the interpretation of warning messages. </EM></BLOCKQUOTE><PRE>
</PRE> These procedures control when errors are presented and allow a client
   to be notified when an error is reported by one of the above procs. 

<P><PRE>PROCEDURE <A HREF="M3Error.m3#Show">Show</A>(n: ERROR_NODE; forget := TRUE) RAISES {};
</PRE><BLOCKQUOTE><EM> Show (in some implementation dependent way) any errors on node 'n',
in the current unit. The error is forgotten unless 'forget = FALSE'. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="M3Error.m3#ShowAll">ShowAll</A>(n: ERROR_NODE; forget := TRUE) RAISES {};
</PRE><BLOCKQUOTE><EM> Calls 'Show' for the entire subtree rooted at 'n', in the current
   unit. </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="M3Error.m3#Notification">Notification</A> &lt;: Notification_public;
  Notification_public = OBJECT
  METHODS
    notify(cu: M3AST_AS.Compilation_Unit; isError: BOOLEAN);
    (* &quot;notify&quot; will be called at least once for each unit in which
       an error is found. The &quot;cu&quot; argument will only be non-NIL if the
       error is not in the current unit, e.g. clashing declarations in
       imported interfaces. The second arg is FALSE if only a warning
       (i.e. from Warn(...))
    *)
  END;

PROCEDURE <A HREF="M3Error.m3#AddNotification">AddNotification</A>(n: Notification);

PROCEDURE <A HREF="M3Error.m3#RemoveNotification">RemoveNotification</A>(n: Notification);

END M3Error.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
