<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/warn/M3CChkObsolete.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/warn/M3CChkObsolete.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="M3CChkObsolete.i3">M3CChkObsolete</A></implements></module>;

IMPORT <A HREF="../../../property/src/PropertyV.i3">PropertyV</A>;

IMPORT <A HREF="../gast/ASTWalk.i3">ASTWalk</A>;
IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;
IMPORT <A HREF="../toolmisc/M3Error.i3">M3Error</A>, <A HREF="../syn/M3CPragma.i3">M3CPragma</A>;
IMPORT <A HREF="../../derived/SeqM3AST_AS_DEF_ID.i3">SeqM3AST_AS_DEF_ID</A>, <A HREF="../../derived/SeqM3AST_AS_Used_interface_id.i3">SeqM3AST_AS_Used_interface_id</A>;
IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_SM_F.i3">M3AST_SM_F</A>, <A HREF="../ast/M3AST_TM_F.i3">M3AST_TM_F</A>, <A HREF="../ast/M3AST_TL_F.i3">M3AST_TL_F</A>;

REVEAL
  <A NAME="Handle">Handle</A> = ASTWalk.Closure BRANDED OBJECT
  OVERRIDES callback := Node;
  END; (* record *)

PROCEDURE <A NAME="Node"><procedure>Node</procedure></A>(
    &lt;*UNUSED*&gt; h: Handle;
    n: AST.NODE;
    vm: ASTWalk.VisitMode)
    RAISES {}=
  VAR used_id: M3AST_AS.USED_ID;
  BEGIN
    IF vm = ASTWalk.VisitMode.Entry THEN
      IF n.IsA_USED_ID(used_id) THEN
        TYPECASE used_id.sm_def OF
        | NULL =&gt; (* not bound *)
        | M3AST_AS.DEF_ID(d) =&gt;
            (* Now we can look at the pre-computed set of
               OBSOLETE DEF_IDs in &quot;d.tmp_unit_id&quot; *)
            IF IsObsolete(d) THEN
              M3Error.WarnWithId(used_id, &quot;%s is OBSOLETE&quot;, used_id.lx_symrep);
            END;
        END;
      END;
    END;
  END Node;

PROCEDURE <A NAME="NewHandle"><procedure>NewHandle</procedure></A>(cu: M3AST_AS.Compilation_Unit): Handle RAISES {}=
  BEGIN
    (* Set up information on OBSOLETE declarations for this unit,
       and all imported ones. *)
    TYPECASE cu.as_root OF
    | NULL =&gt;
    | M3AST_AS.UNIT_NORMAL(unit) =&gt;
        SetupDefIds(cu);
        VAR iter := SeqM3AST_AS_Used_interface_id.NewIter(unit.sm_import_s);
            used_id: M3AST_AS.Used_interface_id;
        BEGIN
          WHILE SeqM3AST_AS_Used_interface_id.Next(iter, used_id) DO
            TYPECASE used_id.sm_def OF
            | NULL =&gt;
            | M3AST_AS.UNIT_ID(unit_id)=&gt;
                SetupDefIds(unit_id.sm_spec.sm_comp_unit);
            ELSE
            END;
          END;
        END
    ELSE
    END;
    RETURN NEW(Handle);
  END NewHandle;

PROCEDURE <A NAME="SetupDefIds"><procedure>SetupDefIds</procedure></A>(cu: M3AST_AS.Compilation_Unit)=
  VAR iter := M3CPragma.NewIter(cu.lx_pragmas);
      pragma: M3CPragma.T;
      args: TEXT;
      follower: M3AST_AS.SRC_NODE;
      bad: BOOLEAN;
  BEGIN
    IF GetSeq(cu) # NIL THEN RETURN END;

    WITH usd = NEW(UniqSeqM3AST_AS_DEF_ID) DO
      PropertyV.Put(cu.tl_pset, usd);
      WHILE M3CPragma.Next(iter, pragma) DO
        IF M3CPragma.Match(pragma, &quot;OBSOLETE&quot;, args) THEN
          follower := M3CPragma.FollowingNode(pragma);
          bad := FALSE;
          TYPECASE follower OF
          | NULL =&gt; bad := TRUE;
          | M3AST_AS.DECL_REVL(d) =&gt;
              &lt;*FATAL ANY*&gt; BEGIN
                ASTWalk.VisitNodes(d, NEW(SetupClosure, rs := usd));
              END;
          ELSE bad := TRUE
          END;
          IF bad THEN M3Error.ReportAtPos(M3CPragma.Position(pragma),
              &quot;OBSOLETE must precede a declaration or revelation&quot;);
          END;
        END;
      END;
    END;
  END SetupDefIds;

TYPE SetupClosure = ASTWalk.Closure OBJECT
    rs: UniqSeqM3AST_AS_DEF_ID;
  OVERRIDES callback := Setup
  END;

  UniqSeqM3AST_AS_DEF_ID = BRANDED REF SeqM3AST_AS_DEF_ID.T;

PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>(cl: SetupClosure; n: AST.NODE; &lt;*UNUSED*&gt; vm: ASTWalk.VisitMode)=
  BEGIN
    TYPECASE n OF
    | M3AST_AS.DEF_ID(d) =&gt;
        SeqM3AST_AS_DEF_ID.AddFront(cl.rs^, d);
    ELSE
    END;
  END Setup;

PROCEDURE <A NAME="IsObsolete"><procedure>IsObsolete</procedure></A>(d: M3AST_AS.DEF_ID): BOOLEAN=
  BEGIN
    WITH cu = d.tmp_unit_id.sm_spec.sm_comp_unit DO
      VAR iter := SeqM3AST_AS_DEF_ID.NewIter(GetSeq(cu)^);
        od: M3AST_AS.DEF_ID;
      BEGIN
        WHILE SeqM3AST_AS_DEF_ID.Next(iter, od) DO
          IF d = od THEN RETURN TRUE END;
        END;
      END;
    END;
    RETURN FALSE;
  END IsObsolete;

PROCEDURE <A NAME="GetSeq"><procedure>GetSeq</procedure></A>(cu: M3AST_AS.Compilation_Unit): UniqSeqM3AST_AS_DEF_ID=
  BEGIN
    RETURN PropertyV.Get(cu.tl_pset, TYPECODE(UniqSeqM3AST_AS_DEF_ID));
  END GetSeq;

BEGIN

END M3CChkObsolete.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
