<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3tk/src/warn/M3CChkReturn.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3tk/src/warn/M3CChkReturn.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="M3CChkReturn.i3">M3CChkReturn</A></implements></module>;
</PRE>*************************************************************************
                      Copyright (C) Olivetti 1989                        
                          All Rights reserved                            
                                                                         
 Use and copy of this software and preparation of derivative works based 
 upon this software are permitted to any person, provided this same      
 copyright notice and the following Olivetti warranty disclaimer are      
 included in any copy of the software or any modification thereof or     
 derivative work therefrom made by any person.                           
                                                                         
 This software is made available AS IS and Olivetti disclaims all        
 warranties with respect to this software, whether expressed or implied  
 under any law, including all implied warranties of merchantibility and  
 fitness for any purpose. In no event shall Olivetti be liable for any   
 damages whatsoever resulting from loss of use, data or profits or       
 otherwise arising out of or in connection with the use or performance   
 of this software.                                                       
*************************************************************************

<P><PRE>IMPORT <A HREF="../../../text/src/Text.i3">Text</A>;

IMPORT <A HREF="../gast/AST.i3">AST</A>, <A HREF="../ast/M3AST_AS.i3">M3AST_AS</A>;

IMPORT <A HREF="../ast/M3AST_AS_F.i3">M3AST_AS_F</A>, <A HREF="../ast/M3AST_TM_F.i3">M3AST_TM_F</A>;

IMPORT <A HREF="../../derived/SeqM3AST_AS_STM.i3">SeqM3AST_AS_STM</A>;
IMPORT <A HREF="../gast/ASTWalk.i3">ASTWalk</A>;
IMPORT <A HREF="../syn/M3CPragma.i3">M3CPragma</A>, <A HREF="../toolmisc/M3Error.i3">M3Error</A>;

TYPE
  Stack = BRANDED REF RECORD
    next: Stack;
    procDecl: M3AST_AS.Proc_decl;
    stm: M3AST_AS.STM;
    ignoring := TRUE;
    inLoop := 0;
    returnInLoop := FALSE;
  END; (* record *)

REVEAL
  <A NAME="Handle">Handle</A> = ASTWalk.Closure BRANDED OBJECT
    cu: M3AST_AS.Compilation_Unit;
    stack: Stack := NIL;
  OVERRIDES callback := Node;
  END; (* record *)

&lt;*INLINE*&gt; PROCEDURE <A NAME="DoWarning"><procedure>DoWarning</procedure></A>(n: M3Error.ERROR_NODE; m: TEXT) RAISES {}=
  BEGIN
    M3Error.Warn(n, m);
  END DoWarning;

PROCEDURE <A NAME="NeedsReturnCheck"><procedure>NeedsReturnCheck</procedure></A>(s: Stack) RAISES {}=
  BEGIN
    WHILE s # NIL DO
      IF s.procDecl # NIL THEN
        s.procDecl.tmp_needs_return_check := TRUE;
        RETURN;
      END;
      s := s.next;
    END;
  END NeedsReturnCheck;

PROCEDURE <A NAME="NotReachedAfterSrcNode"><procedure>NotReachedAfterSrcNode</procedure></A>(
    h: Handle;
    srcNode: M3AST_AS.SRC_NODE)
    : BOOLEAN
    RAISES {}=
  VAR
    iter := M3CPragma.AfterNode(h.cu.lx_pragmas, srcNode);
    pragma: M3CPragma.T;
    args: Text.T;
  BEGIN
    WHILE M3CPragma.Next(iter, pragma) AND
        M3CPragma.PrecedingNode(pragma) = srcNode DO
      IF M3CPragma.Match(pragma, &quot;NOTREACHED&quot;, args) AND args = NIL THEN
        RETURN TRUE;
      END;
    END;
    RETURN FALSE;
  END NotReachedAfterSrcNode;

PROCEDURE <A NAME="PushLastStm"><procedure>PushLastStm</procedure></A>(
    h: Handle;
    srcNode: M3AST_AS.SRC_NODE;
    seqSTM: SeqM3AST_AS_STM.T;
    procDecl: M3AST_AS.Proc_decl := NIL)
    RAISES {}=
  VAR
    last, stm: M3AST_AS.STM := NIL;
    iter := SeqM3AST_AS_STM.NewIter(seqSTM);
  BEGIN
    WHILE SeqM3AST_AS_STM.Next(iter, stm) DO last := stm END;
    IF last = NIL THEN
      IF NOT NotReachedAfterSrcNode(h, srcNode) THEN
        DoWarning(srcNode, &quot;last statement in function is not a RETURN&quot;);
      END;
      IF procDecl # NIL THEN
        procDecl.tmp_needs_return_check := TRUE;
      ELSE
        NeedsReturnCheck(h.stack);
      END;
    ELSE
      h.stack := NEW(Stack, next := h.stack, procDecl := procDecl, stm := last);
    END;
  END PushLastStm;

PROCEDURE <A NAME="NotReachedAfterStm"><procedure>NotReachedAfterStm</procedure></A>(h: Handle; stm: M3AST_AS.STM): BOOLEAN RAISES {}=
  VAR
    iter := M3CPragma.AfterStmOrDecl(h.cu.lx_pragmas, stm);
    pragma: M3CPragma.T;
    args: Text.T;
  BEGIN
    WHILE M3CPragma.Next(iter, pragma) AND
        M3CPragma.PrecedingStmOrDecl(pragma) = stm DO
      IF M3CPragma.Match(pragma, &quot;NOTREACHED&quot;, args) AND args = NIL THEN
        RETURN TRUE;
      END;
    END;
    RETURN FALSE;
  END NotReachedAfterStm;

PROCEDURE <A NAME="Node"><procedure>Node</procedure></A>(
    h: Handle;
    n: AST.NODE;
    vm: ASTWalk.VisitMode)
    RAISES {}=
  BEGIN
    IF vm = ASTWalk.VisitMode.Entry THEN
      TYPECASE n OF
      | M3AST_AS.Proc_decl(procDecl) =&gt;
          VAR
            body := procDecl.as_body;
          BEGIN
            IF body # NIL AND procDecl.as_type.as_result_type # NIL THEN
              PushLastStm(h, body, body.as_stm_s, procDecl);
            END;
          END;
      ELSE
        IF h.stack # NIL THEN
          IF h.stack.ignoring THEN
            IF h.stack.stm # n THEN RETURN END;
            TYPECASE n OF
            | M3AST_AS.Assign_st, M3AST_AS.Call_st,
              M3AST_AS.Exit_st, M3AST_AS.Eval_st =&gt;
                NeedsReturnCheck(h.stack);
                IF NOT NotReachedAfterStm(h, h.stack.stm) THEN
                  DoWarning(h.stack.stm,
                      &quot;last statement in function is not a RETURN&quot;);
                END;
            | M3AST_AS.Return_st, M3AST_AS.Raise_st =&gt;
            ELSE
              (* Complex statement, containing sub statements *)
              h.stack.ignoring := FALSE;
              TYPECASE n OF
              | M3AST_AS.While_st, M3AST_AS.Repeat_st,
                M3AST_AS.Loop_st, M3AST_AS.For_st =&gt;
                  INC(h.stack.inLoop);
                  NeedsReturnCheck(h.stack);
              | M3AST_AS.If_st(ifSt) =&gt;
                  IF ifSt.as_else = NIL THEN
                    NeedsReturnCheck(h.stack);
                    IF NOT NotReachedAfterStm(h, ifSt) THEN
                      DoWarning(ifSt,
                          &quot;last statement in function is IF with no ELSE&quot;);
                    END;
                  ELSE
                    PushLastStm(h, ifSt, ifSt.as_stm_s);
                  END;
              | M3AST_AS.STM_WSS(stmWSS) =&gt;
                  PushLastStm(h, stmWSS, stmWSS.as_stm_s);
              ELSE
              END;
            END;
            RETURN;
          ELSE
            IF h.stack.inLoop &gt; 0 THEN
              TYPECASE n OF
              | M3AST_AS.Return_st =&gt;
                  h.stack.returnInLoop := TRUE;
              | M3AST_AS.Exit_st(exitSt) =&gt;
                  IF h.stack.inLoop = 1 THEN
                    DoWarning(exitSt,
                        &quot;EXIT will leave function without returning value&quot;);
                  END;
              | M3AST_AS.While_st, M3AST_AS.Repeat_st,
                M3AST_AS.Loop_st, M3AST_AS.For_st =&gt;
                  INC(h.stack.inLoop);
              ELSE
              END;
            ELSE
              TYPECASE n OF
              | M3AST_AS.Try_except =&gt;
                  (* AST problem; not really a SUBSTM_WSS at all.. *)
              | M3AST_AS.SUBSTM_WSS(subStmWSS) =&gt;
                  PushLastStm(h, subStmWSS, subStmWSS.as_stm_s);
              ELSE
              END;
            END;
          END;
        END;
      END; (* typecase *)
    ELSE
      IF h.stack # NIL THEN
        IF h.stack.stm = n THEN
          IF h.stack.inLoop # 0 AND NOT h.stack.returnInLoop THEN
            IF NOT NotReachedAfterStm(h, h.stack.stm) THEN
              DoWarning(h.stack.stm,
                  &quot;loop at end of function does not contain RETURN&quot;);
            END;
          END;
          h.stack := h.stack.next;
        ELSIF h.stack.inLoop &gt; 1 THEN
          TYPECASE n OF
          | M3AST_AS.While_st, M3AST_AS.Repeat_st,
            M3AST_AS.Loop_st, M3AST_AS.For_st =&gt;
                DEC(h.stack.inLoop);
          ELSE
          END;
        END;
      END;
    END;
  END Node;

PROCEDURE <A NAME="NewHandle"><procedure>NewHandle</procedure></A>(cu: M3AST_AS.Compilation_Unit): Handle RAISES {}=
  BEGIN
    RETURN NEW(Handle, cu := cu);
  END NewHandle;

BEGIN

END M3CChkReturn.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
